#!/bin/bash
#
##
## TO:Crossfire Installer
##
## Copyright (C) 2006 The TO:Crossfire Team
##
## Version: 0.01
##
## 18/04/06: 0.01 - Initial version (Hydro)
##

function main() {
    displayWelcome;
    if [ "$SHOWLICENSEOPT" == 1 ]; then
	displayLicense;
    fi
    findInstallPath;
    doInstall;
    displayFinalMessage;
    exit 0
}

function displayFinalMessage {
    # adjust our final message depending on install success / failure
    if [ "$SUCCESSFLAG" == 1 ]; then
	echo "$FINALOK"
    else
	echo "$FINALFAIL"
	exit 1
    fi
}

function doInstall {
    SUCCESSFLAG=0
    # untar the bits
    tar -xzf "$TARBALLPATH" --no-same-permissions -C "$FINALPATH" 2> /dev/null
    if [ "$?" == 0 ]; then
	export SUCCESSFLAG=1
    fi
    # write out the run script
    if [ "$SUCCESSFLAG" == 1 ]; then
	echo ${RUNSCRIPT/SCRIPTPATH/$FINALPATH} | tr _ \\n > "$RUNTOCPATH"
	chmod u+rwx "$RUNTOCPATH"
    fi
}

function findInstallPath {
    RESP=
    # look for default install locations
    if [ -d "$TESTPATH" ]; then
	FINALPATH="$TESTPATH"
    elif [ -d "$TESTPATH2" ]; then
	FINALPATH="$TESTPATH2"
    fi
    # confirm the path with user
    printf "${QRYFINALPATH} [${FINALPATH}]: "
    read RESP
    if [ "$RESP" != "" ]; then
	FINALPATH="$RESP"
    fi
    # fully expand path
    FINALPATH=$(eval echo "$FINALPATH")
    # tidy the path
    if [ ${FINALPATH:0-1} != "/" ]; then
	FINALPATH="$FINALPATH/"
    fi
    # display path we're about to use
    echo "${USINGPATHMSG}: ${FINALPATH}"
    # check the user didn't make a mistake
    if [ ! -d "$FINALPATH" ]; then
	echo "$PATHMISSINGMSG"
	exit 1
    fi
}

function displayLicense {
    RESP=
    # display license and acceptance message
    echo "$LICENSEHEADER"
    read
    echo "$LICENSE" | less
    printf "${ACCEPTMSG}: "
    read RESP
    # we must have a correct response
    while [ "$RESP" != "Yes" ] && [ "$RESP" != "No" ]; do
	printf "${REACCEPTMSG}: "
	read RESP
    done;
    # don't continue install if they didn't agree
    if [ "$RESP" == "No" ]; then
	exit 0;
    fi;
}

function displayWelcome {
    printf "$WELCOME"
}

# -------- Configurable Internals --------
# 1 = display license, 0 = hide license
SHOWLICENSEOPT=1

## Parameters
# File paths indicating existing UT2K4 install
TESTPATH=~/ut2004/
TESTPATH2=/usr/local/games/ut2004

# File path of install files
TARBALLPATH=./TOCinstall.tgz

# File path to install TO:C run script
RUNTOCPATH=~/runTOC.sh
RUNSCRIPT="""
#!/bin/bash_
_
sh SCRIPTPATHut2004 -MOD=TOCrossfire -log=TOCrossfire.log_
"""

## Messages
WELCOME="""
TO:Crossfire Beta Release 1.5 Updater
"""

LICENSE="""
END- USER LICENSE AGREEMENT

PLEASE READ CAREFULLY.  BY USING OR INSTALLING THIS SOFTWARE, OR BY PLACING OR COPYING THIS SOFTWARE ON YOUR COMPUTER HARDWARE, COMPUTER RAM OR OTHER STORAGE MEDIUM, YOU ARE AGREEING TO BE BOUND BY THE TERMS OF THIS LICENSE.  IF YOU DO NOT AGREE TO THESE TERMS, PROMPTLY DISCONTINUE THE INSTALLATION PROCESS AND CEASE ALL USE OF THIS SOFTWARE.

1. Thanks.  Congratulations and thank you for licensing our software.  We're sorry to cramp your style, but out lawyers tell us that if we want to keep control and ownership of the cool stuff we're developing, we have to make sure you understand and agree that you are just buying a right to use it and that that right is limited in certain ways.  So what follows is what you need to know and agree to. 
2. License.  The software accompanying this license and the related documentation (the Software) are licensed for your use and gaming enjoyment, subject to terms and limitations in this license agreement.  
3. Commercial Exploitation. You may not use this game, or any parts this game or using the tools provided with this game, for any commercial purposes. a. If you are the proprietor of an Internet caf or gaming room, you may operate the Software in a pay for play environment provided that all computers used have validly licensed Software installed.
4. Use Restrictions.  We want you to enjoy our products for years to come, and we want to be able to continue to make awesome games, so you need to be aware that there are some things you cannot do with the Software.  The Software contains copyrighted material, trade secrets and other proprietary material.  You may not decompile, modify, reverse engineer, publicly display, prepare derivative works based on the Software (except as permitted in Section 8, below), disassemble or otherwise reproduce the Software.  You may not delete the copyright notices or any other proprietary legends on the original copy of the Software.  You may not offer the Software on a pay-per-play basis or otherwise commercially exploit the Software or use the Software for any commercial purpose except as described in this agreement.  
5. CHEATING.  Nobody likes a cheater.  It's a disgraceful way to earn a win and really is an insult to those players who earn their wins in on-line games the old fashioned way WITH TALENT.  We're pretty hard on cheating in on-line games using the Software because it sullies the overall gaming experience and is JUST PLAIN LAME.  With that in mind if you are caught cheating in an on-line game using the Software we will immediately and permanently ban your CD Key.  At that point this License Agreement is automatically terminated and you must immediately delete this software from your PC.  Failure to comply with this last bit (deleting the software) may bring on the wrath of the lawyers.  Trust usyou don't want that.
6. Termination.  This license is effective until one of us terminate it.  You may terminate this license at any time by destroying the Software and related documentation. In the unlikely event that you are naughty and fail to comply with any provision of this license, this license will terminate immediately without notice from us. Upon termination, you must destroy the Software and related documentation.  Please don't wait for us to come after you; it would not be pleasant for either of us.  If we do have to come after you, we're going to expect you to pay us for our troubles, including the cost of our lawyers.
7. Disclaimer of Warranty on Software.  You are aware and agree that use of the Software and the media on which it is recorded at your sole risk.  The Software, related documentation and the media are provided AS IS.  Unless otherwise provided by applicable law.  WE DO NOT WARRANT THAT THE FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET YOUR REQUIREMENTS.  NO ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY US OR ANY OF OUR AUTHORIZED REPRESENTATIVES SHALL CREATE A WARRANTY OR IN ANY WAY INCREASE THE SCOPE OF THIS WARRANTY.  SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF IMPLIED WARRANTIES, S0 THE ABOVE EXCLUSIONS MAY NOT APPLY TO YOU.
8. Limitation of Liability.  UNDER NO CIRCUMSTANCES, INCLUDING WITHOUT LIMITATION, NEGLIGENCE, SHALL THE TO:CROSSFIRE TEAM OR ANY OF THEIR RESPECTIVE OFFICERS, EMPLOYEES, DIRECTORS, AGENTS OR ASSIGNS BE LIABLE FOR ANY INCIDENTAL, SPECIAL OR CONSEQUENTIAL DAMAGES THAT RESULT FROM THE USE OR INABILITY TO USE THE SOFTWARE OR RELATED DOCUMENTATION, EVEN IF SUCH PARTIES HAVE BEEN ADVISED OF THE POSSIBILITY OF THOSE DAMAGES.  SOME JURISDICTIONS DO NOT ALLOW THE LIMITATION OR EXCLUSION OF LIABILITY FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES SO THE ABOVE LIMITATION OR EXCLUSION MAY NOT APPLY TO YOU.  In no event shall our total liability to you for all damages, losses, and causes of action (whether in contract, tort or otherwise) exceed the amount paid by you for the Software.
9. Controlling Law and Severability.  This license is governed by and construed in accordance with the laws of the State of North Carolina, USA.  Exclusive venue for all litigation shall be in Wake County, North Carolina.  If any provision of this license is unenforceable, the rest of it shall remain in effect.
10. Complete Agreement.  This license constitutes the entire agreement between the parties with respect to the use of the Software and the related documentation.  However, the TO:Crossfire Team reserve the right to modify the terms of this license from time to time and will post notice of material changes somewhere within www.to-crossfire.net 
11. Copyright.  The Software and all copyrights, trademarks and all other conceivable intellectual property rights related to the Software are owned by the TO:Crossfire Team or such parties' licensors and are protected by United States copyrights laws, international treaty provisions, an army of clones, and all applicable law, such as the Lanham Act.  You must treat the Software like any other copyrighted material, as required by 17 U.S.C. section 101 et seq. and other applicable law.  
12. Enjoyment Requirements.  We are aware that there are rumblings and grumblings within the gaming community about heavy handed, legally onerous license agreements.  You have our word that this one is as fair and even handed as it gets and, as you have read this far, you know it to be true.  Now, be gone from this screen and enjoy the Software.
"""

LICENSEHEADER="(Press any key to read the license - q to quit license)"
ACCEPTMSG="Do you accept the terms of this license? [Yes/No]"
REACCEPTMSG="Please enter Yes or No"
QRYFINALPATH="Enter the location of your UT2004 install"
USINGPATHMSG="Using path"
PATHMISSINGMSG="Path does not exist"
FINALOK="Install completed successfully."
FINALFAIL="Install aborted / failed."

# --------- DO NOT TOUCH ---------
FINALPATH=
RESP=
SUCCESSFLAG=0

## Call the main function and get the ball rolling...
main;