//
// TRACKER SCHEME RESOURCE FILE
//
// sections:
//		colors			- all the colors used by the scheme
//		basesettings	- contains settings for app to use to draw controls
//		fonts			- list of all the fonts used by app
//		borders			- description of all the borders
//
//		
Scheme
{
	//Name - currently overriden in code
	//{
	//	"Name"	"ClientScheme"
	//}

	//////////////////////// COLORS ///////////////////////////
	Colors
	{
		// base colors
		"Orange"			"255 176 0 255"
		"OrangeDim"			"255 176 0 120"
		"LightOrange"		"188 112 0 128"
		
		"PureWhite"			"255 255 255 224"
		"White"				"255 255 255 200"
		"LightWhite"        "255 255 255 100"
		
		"Red"				"192 28 0 140"
		"Black"				"0 0 0 255"
		"TransparentBlack"	"0 0 0 196"
		"TransparentLightBlack"	"0 0 0 90"

		"Blank"				"0 0 0 0"
		"ForTesting"		"255 0 0 32"
		"ForTesting_Magenta"	"255 0 255 255"
		"ForTesting_MagentaDim"	"255 0 255 120"
	}

	///////////////////// BASE SETTINGS ////////////////////////
	// default settings for all panels
	// controls use these to determine their settings
	BaseSettings
	{
		// vgui_controls color specifications
		Border.Bright					"255 255 255 128"		// the lit side of a control
		Border.Dark						"Border.Bright"		// the dark/unlit side of a control
		Border.Selection				"Blank"				// the additional border color for displaying the default/selected button

		Button.TextColor				"PureWhite"
		Button.BgColor					"255 255 255 64"
		Button.ArmedTextColor			"255 255 255 128"
		Button.ArmedBgColor				"255 255 255 32"
		Button.DepressedTextColor		"255 255 255 64"
		Button.DepressedBgColor			"255 255 255 16"

		CheckButton.TextColor			"PureWhite"
		CheckButton.SelectedTextColor	"PureWhite"
		CheckButton.BgColor				"Blank"
		CheckButton.Border1  			"Border.Dark" 		// the left checkbutton border
		CheckButton.Border2  			"Border.Bright"		// the right checkbutton border
		CheckButton.Check				"PureWhite"				// color of the check itself

		ComboBoxButton.ArrowColor		"PureWhite"
		ComboBoxButton.ArmedArrowColor	"PureWhite"
		ComboBoxButton.BgColor			"TransparentBlack"
		ComboBoxButton.DisabledBgColor	"Blank"

		Frame.BgColor					"TransparentBlack"
		Frame.OutOfFocusBgColor			"TransparentBlack"
		Frame.FocusTransitionEffectTime	"0.0"	// time it takes for a window to fade in/out on focus/out of focus
		Frame.TransitionEffectTime		"0.0"	// time it takes for a window to fade in/out on open/close
		Frame.AutoSnapRange				"0"
		FrameGrip.Color1				"Blank"
		FrameGrip.Color2				"Blank"
		FrameTitleButton.FgColor		"Blank"
		FrameTitleButton.BgColor		"Blank"
		FrameTitleButton.DisabledFgColor	"Blank"
		FrameTitleButton.DisabledBgColor	"Blank"
		FrameSystemButton.FgColor		"Blank"
		FrameSystemButton.BgColor		"Blank"
		FrameSystemButton.Icon			""
		FrameSystemButton.DisabledIcon	""
		FrameTitleBar.TextColor			"Orange"
		FrameTitleBar.BgColor			"Blank"
		FrameTitleBar.DisabledTextColor	"Orange"
		FrameTitleBar.DisabledBgColor	"Blank"

		GraphPanel.FgColor				"Orange"
		GraphPanel.BgColor				"TransparentBlack"

		Label.TextDullColor				"PureWhite"
		Label.TextColor					"PureWhite"
		Label.TextBrightColor			"PureWhite"
		Label.SelectedTextColor			"PureWhite"
		Label.BgColor					"Blank"
		Label.DisabledFgColor1			"Blank"
		Label.DisabledFgColor2			"LightWhite"

		ListPanel.TextColor					"255 255 200 255"
		ListPanel.BgColor					"0 0 0 32"
		ListPanel.SelectedTextColor			"ListPanel.TextColor"
		ListPanel.SelectedBgColor			"Blank"
		ListPanel.SelectedOutOfFocusBgColor	"Blank"
		ListPanel.EmptyListInfoTextColor	"Orange"
		ListPanel.HeaderTextColor			"ListPanel.TextColor"
		ListPanel.HeaderBgColor				"Blank"
		ListPanel.DividerColor				"ListPanel.TextColor"

		HTML.BgColor	"0 0 0 128"
		
		Menu.TextColor					"Button.FgColor"
		Menu.BgColor					"0 0 0 144"
		Menu.ArmedTextColor				"Black"
		Menu.ArmedBgColor				"255 255 255 64"
		Menu.TextInset					"6"

		ScrollBarButton.TextColor					"Button.FgColor"
		ScrollBarButton.BgColor					"Button.BgColor"
		ScrollBarButton.ArmedTextColor				"Button.ArmedTextColor"
		ScrollBarButton.ArmedBgColor				"Button.ArmedBgColor"
		ScrollBarButton.DepressedTextColor			"Button.DepressedTextColor"
		ScrollBarButton.DepressedBgColor			"Button.DepressedBgColor"
		
		Chat.TypingText					"PureWhite"

		Panel.FgColor					"White"
		Panel.BgColor					"blank"

		ProgressBar.FgColor				"Orange"
		ProgressBar.BgColor				"TransparentBlack"

		PropertySheet.TextColor			"Orange"
		PropertySheet.SelectedTextColor	"Orange"
		PropertySheet.TransitionEffectTime	"0.25"	// time to change from one tab to another

		RadioButton.TextColor			"PureWhite"
		RadioButton.SelectedTextColor	"PureWhite"

		RichText.TextColor				"PureWhite"
		RichText.BgColor				"0 0 0 128"
		RichText.SelectedTextColor		"PureWhite"
		RichText.SelectedBgColor		"Blank"

		ScrollBarSlider.FgColor				"255 255 255 128"		// nob color
		ScrollBarSlider.BgColor				"0 0 0 128"		// slider background color

		SectionedListPanel.HeaderTextColor	"PureWhite"
		SectionedListPanel.HeaderBgColor	"Blank"
		SectionedListPanel.DividerColor		"LightWhite"
		SectionedListPanel.TextColor		"PureWhite"
		SectionedListPanel.BrightTextColor	"PureWhite"
		SectionedListPanel.BgColor			"0 0 0 128"
		SectionedListPanel.SelectedTextColor			"PureWhite"
		SectionedListPanel.SelectedBgColor				"SectionedListPanel.BgColor"
		SectionedListPanel.OutOfFocusSelectedTextColor	"PureWhite"
		SectionedListPanel.OutOfFocusSelectedBgColor	"SectionedListPanel.BgColor"

		Slider.NobColor				"108 108 108 255"
		Slider.TextColor			"127 140 127 255"
		Slider.TrackColor			"31 31 31 255"
		Slider.DisabledTextColor1	"117 117 117 255"
		Slider.DisabledTextColor2	"30 30 30 255"

		TextEntry.TextColor			"PureWhite"
		TextEntry.BgColor			"0 0 0 128"
		TextEntry.CursorColor		"PureWhite"
		TextEntry.DisabledTextColor	"White"
		TextEntry.DisabledBgColor	"Blank"
		TextEntry.SelectedTextColor	"Black"
		TextEntry.SelectedBgColor	"255 255 255 128"
		TextEntry.OutOfFocusSelectedBgColor	"PureWhite"
		TextEntry.FocusEdgeColor	"TransparentBlack"

		ToggleButton.SelectedTextColor	"PureWhite"

		Tooltip.TextColor			"TransparentBlack"
		Tooltip.BgColor				"Red"

		TreeView.BgColor			"TransparentBlack"

		WizardSubPanel.BgColor		"Blank"

		// scheme-specific colors
		"FgColor"		"PureWhite"
		"BgColor"		"TransparentBlack"

		"ViewportBG"		"Blank"
		"team0"			"204 204 204 255" // Spectators
		"team1"			"255 64 64 255" // CT's
		"team2"			"153 204 255 255" // T's

		"MapDescriptionText"	"Orange" // the text used in the map description window
		"CT_Blue"			"153 204 255 255"
		"T_Red"				"255 64 64 255"
		"Hostage_Yellow"	"Panel.FgColor"
		"HudIcon_Green"		"0 160 0 255"
		"HudIcon_Red"		"160 0 0 255"

		// CHudMenu
		"ItemColor"		"255 167 42 200"	// default 255 167 42 255
		"MenuColor"		"233 208 173 255"
		"MenuBoxBg"		"0 0 0 100"

		// weapon selection colors
		"SelectionNumberFg"		"255 220 0 200"
		"SelectionTextFg"		"255 220 0 200"
		"SelectionEmptyBoxBg" 	"0 0 0 80"
		"SelectionBoxBg" 		"0 0 0 80"
		"SelectionSelectedBoxBg" "0 0 0 190"

		// Hint message colors
		"HintMessageFg"			"255 255 255 255"
		"HintMessageBg" 		"0 0 0 60"

		"ProgressBarFg"			"255 30 13 255"

		// Top-left corner of the "Insects Infestation" on the main screen
		"Main.Title1.X"		"70"
		"Main.Title1.Y"		"70"
		"Main.Title1.Color"	"192 192 192 255"

		// Top-left corner of the "Alpha" on the main screen
		"Main.Title2.X"		"70"
		"Main.Title2.Y"		"110"
		"Main.Title2.Color"	"192 192 192 255"

		// Top-left corner of the menu on the main screen
		"Main.Menu.X"		"70"
		"Main.Menu.Y"		"250"

		// Blank space to leave beneath the menu on the main screen
		"Main.BottomBorder"	"70"
		
		// dialog control color
		DialogTitle.Color	"PureWhite"
	}

	//
	//////////////////////// FONTS /////////////////////////////
	//
	// describes all the fonts
	Fonts
	{
		ClientTitleFont
		{
			"1"
			{
				"name"  "Hotel Coral Essex"
				"tall"  "45"
				"weight" "500"
				"additive" "0"
				"antialias" "1"
				"dropshadow" "0"
				"outline"	"0"
			}
		}

		"MenuTitle"
		{
			"1"
			{
				"name"		"Arial Boldf"
				"tall"		"24"
				"weight"	"900"
				"antialias" "1"
			}
		}
		"ScoreSmall"
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"15"
				"weight"	"100"
				"antialias" "1"
				"yres"	"480 599"
				//"outline"	"1"
				"dropshadow"	"1"
			}

			"2"
			{
				"name"		"Arial"
				"tall"		"16"
				"weight"	"100"
				"antialias" "1"
				"yres"	"600 767"
				//"outline"	"1"
				"dropshadow"	"1"
			}

			"3"
			{
				"name"		"Arial"
				"tall"		"17"
				"weight"	"100"
				"antialias" "1"
				"yres"	"768 959"
				//"outline"	"1"
				"dropshadow"	"1"
			}

			"4"
			{
				"name"		"Arial"
				"tall"		"18"
				"weight"	"100"
				"antialias" "1"
				"yres"	"960 6000"
				//"outline"	"1"
				"dropshadow"	"1"
			}
		}			
			
		"Pheromone"
		{
			"1"
			{
				"name"		"bip"
				"tall"		"12"
				"weight"	"80"
				"antialias" "1"
				"yres"	"480 599"
				//"outline"	"1"
				"dropshadow"	"1"
			}

			"2"
			{
				"name"		"bip"
				"tall"		"17"
				"weight"	"100"
				"antialias" "1"
				"yres"	"600 767"
				//"outline"	"1"
				"dropshadow"	"1"
			}

			"3"
			{
				"name"		"bip"
				"tall"		"21"
				"weight"	"100"
				"antialias" "1"
				"yres"	"768 959"
				//"outline"	"1"
				"dropshadow"	"1"
			}

			"4"
			{
				"name"		"bip"
				"tall"		"24"
				"weight"	"100"
				"antialias" "1"
				"yres"	"960 6000"
				//"outline"	"1"
				"dropshadow"	"1"
			}
		}			
			
		// fonts are used in order that they are listed
		// fonts listed later in the order will only be used if they fulfill a range not already filled
		// if a font fails to load then the subsequent fonts will replace
		"Default"
		{
			"1"
			{
				"name"		"bip"
				"tall"		"10"
				"weight"	"300"
				//"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"480 599"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"2"
			{
				"name"		"bip"
				"tall"		"13"
				"weight"	"300"
				//"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"600 767"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"3"
			{
				"name"		"bip"
				"tall"		"16"
				"weight"	"300"
				//"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"768 863"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"4"
			{
				"name"		"bip"
				"tall"		"18"
				"weight"	"300"
				//"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"864 959"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"5"
			{
				"name"		"bip"
				"tall"		"19"
				"weight"	"300"
				//"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"960 1024"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"6"
			{
				"name"		"bip"
				"tall"		"20"
				"weight"	"300"
				//"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1025 1200"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"7"
			{
				"name"		"bip"
				"tall"		"24"
				"weight"	"300"
				//"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1201 6000"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"8"
			{
				"name"		"bip"
				"tall"		"12"
				//"range" 		"0x0000 0x00FF"
				"weight"		"300"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"9"
			{
				"name"		"bip"
				"tall"		"12"
				//"range" 		"0x0000 0x00FF"
				"weight"		"300"
				"antialias"	"1"
				"dropshadow"	"1"
			}
		
		}
		"DefaultUnderline"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12"
				"weight"	"500"
				"underline" "1"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"11"
				"range" 		"0x0000 0x00FF"
				"weight"		"800"
			}
		}
		"DefaultSmall"
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"11"
				"weight"	"900"
				"range"		"0x0000 0x017F"
				"yres"	"480 599"
				"antialias"	"1"
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"13"
				"weight"	"900"
				"range"		"0x0000 0x017F"
				"yres"	"600 767"
				"antialias"	"1"
			}
			"3"
			{
				"name"		"Arial"
				"tall"		"16"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"768 863"
				"antialias"	"1"
			}
			"4"
			{
				"name"		"Arial"
				"tall"		"18"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"864 959"
				"antialias"	"1"
			}
			"5"
			{
				"name"		"Arial"
				"tall"		"19"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"960 1023"
				"antialias"	"1"
			}
			"6"
			{
				"name"		"Arial"
				"tall"		"20"
				"weight"	"900"
				"range"		"0x0000 0x017F"
				"yres"	"1024 1199"
				"antialias"	"1"
			}
			"7"
			{
				"name"		"Arial"
				"tall"		"24"
				"weight"	"900"
				"range"		"0x0000 0x017F"
				"yres"	"1200 6000"
				"antialias"	"1"
			}
			"8"
			{
				"name"		"Arial"
				"tall"		"12"
				"range" 		"0x0000 0x00FF"
				"weight"		"0"
				"antialias"	"1"
			}
		}
		"DefaultVerySmall"
		{
			"1"
			{
				"name"		"bip"
				"tall"		"10"
				"weight"	"500"
				//"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"480 599"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"2"
			{
				"name"		"bip"
				"tall"		"12"
				"weight"	"500"
				//"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"600 767"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"3"
			{
				"name"		"bip"
				"tall"		"14"
				"weight"	"500"
				//"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"768 863"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"4"
			{
				"name"		"bip"
				"tall"		"16"
				"weight"	"500"
				//"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"864 959"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"5"
			{
				"name"		"bip"
				"tall"		"19"
				"weight"	"0"
				//"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"960 1024"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"6"
			{
				"name"		"bip"
				"tall"		"20"
				"weight"	"900"
				//"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1025 1200"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"7"
			{
				"name"		"bip"
				"tall"		"24"
				"weight"	"900"
				//"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1201 6000"
				"antialias"	"1"
				"dropshadow"	"1"
			}
			"8"
			{
				"name"		"bip"
				"tall"		"12"
				"range" 		"0x0000 0x00FF"
				"weight"		"0"
			}
			"9"
			{
				"name"		"bip"
				"tall"		"11"
				"range" 		"0x0000 0x00FF"
				"weight"		"0"
			}
		}
		HudHintText
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"12"
				"weight"	"700"
				"yres"	"480 599"
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"13"
				"weight"	"700"
				"yres"	"600 767"
			}
			"3"
			{
				"name"		"Arial"
				"tall"		"14"
				"weight"	"700"
				"yres"	"768 1023"
			}
			"4"
			{
				"name"		"Arial"
				"tall"		"20"
				"weight"	"700"
				"yres"	"1024 1199"
			}
			"5"
			{
				"name"		"Arial"
				"tall"		"24"
				"weight"	"700"
				"yres"	"1200 10000"
			}
		}
		HudNumbersSmall
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"16"
				"weight"	"1000"
				//"additive"	"1"
				"antialias" "1"
				"range"		"0x0000 0x017F"
				"dropshadow"	"1"
			}
		}

		CPNotice
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"20"
				"weight"	"1000"
				//"additive"	"1"
				"antialias" "1"
				"range"		"0x0000 0x017F"
				"dropshadow"	"1"
			}
		}

		DeathNotice
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"18"
				"weight"	"1000"
				//"additive"	"1"
				"antialias" "1"
				"range"		"0x0000 0x017F"
				"dropshadow"	"1"
			}
		}

		HudNumbersBig
		{
			"1"
			{
				"name"		"Bip"
				"tall"		"22"
				"weight"	"1000"
				"antialias" "1"
				"range"		"0x0000 0x017F"
				"dropshadow"	"1"
			}
		}

		HudSelectionNumbers
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"11"
				"weight"	"700"
				"antialias" "1"
				"additive"	"1"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}

		HudSelectionText
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"11"
				"weight"	"700"
				"antialias" "1"
				"yres"	"1 599"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"additive"	"1"
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"11"
				"weight"	"700"
				"antialias" "1"
				"yres"	"600 767"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"additive"	"1"
			}
			"3"
			{
				"name"		"Arial"
				"tall"		"12"
				"weight"	"900"
				"antialias" "1"
				"yres"	"768 1023"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
			"4"
			{
				"name"		"Arial"
				"tall"		"16"
				"weight"	"900"
				"antialias" "1"
				"yres"	"1024 1199"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
			"5"
			{
				"name"		"Arial"
				"tall"		"17"
				"weight"	"1000"
				"antialias" "1"
				"yres"	"1200 10000"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}

		BudgetLabel
		{
			"1"
			{
				"name"		"Courier New"
				"tall"		"14"
				"weight"	"400"
				"outline"	"1"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}
		DebugOverlay
		{
			"1"
			{
				"name"		"Courier New"
				"tall"		"14"
				"weight"	"400"
				"outline"	"1"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}
		CSType
		  {
		   "1"
		   {
			"name"  "cs" // cs.ttf
			"tall"  "80"
			"weight" "0"
			"additive" "1"
			"antialias" "1"
		   }
		  }

		CSweapons // temporary, for testing. overlaps with CSType, above
		  {
		   "1"
		   {
			"name"  "Counter-Strike" // Cstrike.ttf
			"tall"  "70"
			"weight" "0"
			"additive" "1"
			"antialias" "1"
		   }
		  }

		CSweaponsSmall 
		  {
		   "1"
		   {
			"name"  "Counter-Strike" // Cstrike.ttf
			"tall"  "60"
			"weight" "0"
			"additive" "1"
			"antialias" "1"
		   }
		  }

		
		CSTypeSmall
		  {
		   "1"
		   {
			"name"  "cs" // cs.ttf
			"tall"  "40"
			"weight" "20"
			"additive" "1"
			"antialias" "1"
		   }
		  }
		  
		  CSTypelr
		  {
		   "1"
		   {
			"name"  "cs" // cs.ttf
			"tall"  "30"
			"weight" "0"
			"additive" "1"
			"antialias" "1"
		   }
		  }

		  CSTypeDeath
		  {
		   "1"
		   {
			"name"  "csd" // csd.ttf
			"tall"  "42"
			"weight" "0"
			"additive" "1"
			"antialias" "1"
		   }
		  }
		
		Icons
		{
			"1"
			 {
			"name"  "Counter-Strike" // Cstrike.ttf
			"tall"  "28"
			"weight" "0"
			"additive" "1"
			"antialias" "1"
			 }
		}

		"BetaFont"
		{
			"1"
			{
				"name"		"Courier New"
				"tall"		"90"
				"weight"	"900"
				"range"		"0x0000 0x007F"	//	Basic Latin
				"antialias" "1"
				"additive"	"0"
			}
		}

		HudNumbers
		{
			"1"
			{
				"name"  "Counter-Strike" // Cstrike.ttf
				"tall"  "28"
				"weight" "0"
				"additive" "1"
				"antialias" "1"
			}
			"2"
			{
				"name"  "Arial"
				"tall"  "28"
				"weight" "0"
				"additive" "1"
				"antialias" "1"
			}
		}
		"CloseCaption_Normal"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"500"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}
		"CloseCaption_Italic"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"500"
				"italic"	"1"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}
		"CloseCaption_Bold"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}
		"CloseCaption_BoldItalic"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"900"
				"italic"	"1"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}
		// this is the symbol font
		"Marlett"
		{
			"1"
			{
				"name"		"Marlett"
				"tall"		"11"
				"weight"	"0"
				"symbol"	"1"
				"range"		"0x0000 0x007F"	//	Basic Latin
			}
		}
		"DialogTitle"
		{
			"1"
			{
				"name"		"Arial Bold"
				"tall"		"24"
				"weight"	"900"
				"antialias" "1"
			}
		}
		"Trebuchet24"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"24"
				"weight"	"900"
				"range"		"0x0000 0x007F"	//	Basic Latin
				"antialias" "1"
				"additive"	"1"
			}
		}
		"Trebuchet20"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"20"
				"weight"	"900"
				"range"		"0x0000 0x007F"	//	Basic Latin
				"antialias" "1"
				"additive"	"1"
			}
		}
		"Trebuchet18"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"18"
				"weight"	"900"
				"range"		"0x0000 0x007F"	//	Basic Latin
				"antialias" "1"
				"additive"	"1"
			}
		}
		"TargetID"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"24"
				"weight"	"900"
				"range"		"0x0000 0x007F"	//	Basic Latin
				"antialias" "1"
				"additive"	"0"
			}
		}
		"ChatFont"
		{
			"1"
			{
				"name"			"Kronika"
				"tall"			"14"
				"weight"		"700"
				"yres"			"480 599"
				"antialias"		"1"
				"dropshadow"	"1"
			}
			"2"
			{
				"name"			"Kronika"
				"tall"			"15"
				"weight"		"700"
				"yres"			"600 767"
				"antialias"		"1"
				"dropshadow"	"1"
			}
			"3"
			{
				"name"			"Kronika"
				"tall"			"16"
				"weight"		"700"
				"yres"			"768 959"
				"antialias"		"1"
				"dropshadow"	"1"
			}
			"4"
			{
				"name"			"Kronika"
				"tall"			"18"
				"weight"		"700"
				"yres"			"960 1023"
				"antialias"		"1"
				"dropshadow"	"1"
			}
			"5"
			{
				"name"			"Kronika"
				"tall"			"20"
				"weight"		"700"
				"yres"			"1024 1199"
				"antialias"		"1"
				"dropshadow"	"1"
			}
			"6"
			{
				"name"			"Kronika"
				"tall"			"24"
				"weight"		"700"
				"yres"			"1200 10000"
				"antialias"		"1"
				"dropshadow"	"1"
			}
		}	

		"DefaultMedium"
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"12"
				"weight"	"700"
				"dropshadow"	"1"
				"yres"	"480 599"
				"antialias"	"1"
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"14"
				"weight"	"700"
				"dropshadow"	"1"
				"yres"	"600 767"
				"antialias"	"1"
			}
			"3"
			{
				"name"		"Arial"
				"tall"		"18"
				"weight"	"700"
				"dropshadow"	"1"
				"yres"	"768 863"
				"antialias"	"1"
			}
			"4"
			{
				"name"		"Arial"
				"tall"		"20"
				"weight"	"700"
				"dropshadow"	"1"
				"yres"	"864 959"
				"antialias"	"1"
			}
			"5"
			{
				"name"		"Arial"
				"tall"		"22"
				"weight"	"700"
				"dropshadow"	"1"
				"yres"	"960 1023"
				"antialias"	"1"
			}
			"6"
			{
				"name"		"Arial"
				"tall"		"24"
				"weight"	"700"
				"dropshadow"	"1"
				"yres"	"1024 1199"
				"antialias"	"1"
			}
			"7"
			{
				"name"		"Arial"
				"tall"		"26"
				"weight"	"700"
				"dropshadow"	"1"
				"yres"	"1200 6000"
				"antialias"	"1"
			}
		}

	}

	//
	//////////////////// BORDERS //////////////////////////////
	//
	// describes all the border types
	Borders
	{
		BaseBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}
		
		TitleButtonBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		TitleButtonDisabledBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BgColor"
					"offset" "1 0"
				}
			}
			Top
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 0"
				}
			}
		}

		TitleButtonDepressedBorder
		{
			"inset" "1 1 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}

		ScrollBarButtonBorder
		{
			"inset" "1 0 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		ScrollBarButtonDepressedBorder
		{
			"inset" "2 2 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}
		
		ButtonBorder
		{
			"inset" "0 0 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		FrameBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "0 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "0 0"
				}
			}
		}

		TabBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}

		TabActiveBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "6 2"
				}
			}
		}


		ToolTipBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		// this is the border used for default buttons (the button that gets pressed when you hit enter)
		ButtonKeyFocusBorder
		{
			"inset" "0 0 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		ButtonDepressedBorder
		{
			"inset" "0 0 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		ComboBoxBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}

		MenuBorder
		{
			"inset" "1 1 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}
		BrowserBorder
		{
			"inset" "0 0 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}
	}

	//////////////////////// CUSTOM FONT FILES /////////////////////////////
	//
	// specifies all the custom (non-system) font files that need to be loaded to service the above described fonts
	CustomFontFiles
	{
		"1"		"resource/ii.ttf"
		"2"		"resource/ii_menu.ttf"
		"3"		"resource/ii_pheromone.ttf"
		"4"		"resource/ii_chat.ttf"
	}
}