//=========== (C) Copyright 1999 Valve, L.L.C. All rights reserved. ===========
//
// The copyright to the contents herein is the property of Valve, L.L.C.
// The contents may be used and/or copied only with the written permission of
// Valve, L.L.C., or in accordance with the terms and conditions stipulated in
// the agreement/contract under which the contents have been supplied.
//=============================================================================

// No spaces in event names, max length 32
// All strings are case sensitive
//
// valid data key types are:
//   string : a zero terminated string
//   bool   : unsigned int, 1 bit
//   byte   : unsigned int, 8 bit
//   short  : signed int, 16 bit
//   long   : signed int, 32 bit
//   float  : float, 32 bit
//   local  : any data, but not networked to clients
//
// following key names are reserved:
//   local      : if set to 1, event is not networked to clients
//   unreliable : networked, but unreliable
//   suppress   : never fire this event
//   time	: firing server time
//   eventid	: holds the event ID

"modevents"
{
	"plant_info"				// a game event, name may be 32 charaters long
	{
		"type"		"short"   	// 0: created, 1: removed, 2:attacked, 3: killed
		"plant"		"short"   	// 
		"userid"	"short"   	// user ID who plant owner
		"location"	"string" 	// 
	}
	
	"player_death"				// a game event, name may be 32 charaters long
	{
		"userid"	"short"   	// user ID who died				
		"attacker"	"short"	 	// user ID who killed
		"weapon"	"string" 	// weapon name killed used 
	}

	"player_capture_point_succeed"	// a game event, name may be 32 charaters long
	{
		"users"			"string"   	// user name who captured the area (this is a string that can content many name at once)
		"team"			"short"	 	// team number of the users
		"location_name"	"string"   	// capture point location name
	}

	"player_capture_point_aborted"		// a game event, name may be 32 charaters long
	{
		"userid"		"short"   	// user ID who aborted the capture
		"team"			"short"	 	// team number of the aborted team
		"location_name"	"string"   	// capture point location name
	}
	
	"team_win"
	{
		"users"			"string"   	// user name who captured the area : winning capture or best active player
		"team"			"short"	 	// team number
		"user_id1"		"short"   	// user ID who captured more CP or best active player
		"user_id2"		"short"   	// user ID who captured more CP or best active player
		"user_id3"		"short"   	// user ID who captured more CP or best active player
		"user_id4"		"short"   	// user ID who captured more CP or best active player
		"user_id5"		"short"   	// user ID who captured more CP or best active player
		"user_id6"		"short"   	// user ID who captured more CP or best active player
		"user_id7"		"short"   	// user ID who captured more CP or best active player
		"user_id8"		"short"   	// user ID who captured more CP or best active player
		"user_id9"		"short"   	// user ID who captured more CP or best active player
		"user_id10"		"short"   	// user ID who captured more CP or best active player
		"score1"		"short"   	// user capture count or score
		"score2"		"short"   	// user capture count or score
		"score3"		"short"   	// user capture count or score
		"score4"		"short"   	// user capture count or score
		"score5"		"short"   	// user capture count or score
		"score6"		"short"   	// user capture count or score
		"score7"		"short"   	// user capture count or score
		"score8"		"short"   	// user capture count or score
		"score9"		"short"   	// user capture count or score
		"score10"		"short"   	// user capture count or score
	}

	"ii_message"				// main ii event
	{
		"message"	"byte"   	// message
		"param1"	"byte"	 	// parameter 1
		"param2"	"byte"		// parameter 2
	}
		
	"bomb_planted"
	{
		"userid"	"short"		// player who planted the bomb
		"site"		"short"		// bombsite index
		"posx"		"short"		// position x
		"posy"		"short"		// position y
	}
	
	"bomb_defused"
	{
		"userid"	"short"		// player who defused the bomb
		"site"		"short"		// bombsite index
	}
	
	"bomb_exploded"
	{
		"userid"	"short"		// player who planted the bomb
		"site"		"short"		// bombsite index
	}
	
	"bomb_dropped"
	{
		"userid"	"short"		// player who dropped the bomb
	}
	
	"bomb_pickup"
	{
		"userid"	"short"		// player who picked up the bomb
	}

	"bomb_begindefuse"
	{
		"userid"	"short"		// player who picked up the bomb
		"haskit"	"bool"
	}
	
	"hostage_follows"
	{
		"userid"	"short"		// player who touched the hostage
		"hostage"	"short"		// hostage index
	}
	
	"hostage_hurt"
	{
		"userid"	"short"		// player who hurt the hostage
		"hostage"	"short"		// hostage index
	}
	
	"hostage_killed"
	{
		"userid"	"short"		// player who killed the hostage
		"hostage"	"short"		// hostage index
	}
	
	"hostage_rescued"
	{
		"userid"	"short"		// player who rescued the hostage
		"hostage"	"short"		// hostage index
		"site"		"short"		// rescue site index
	}
}
