/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.property;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ExtendedBlockState
extends bed {
    private final ImmutableSet<IUnlistedProperty<?>> unlistedProperties;

    public ExtendedBlockState(atr blockIn, bex[] properties, IUnlistedProperty<?>[] unlistedProperties) {
        super(blockIn, properties, ExtendedBlockState.buildUnlistedMap(unlistedProperties));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (IUnlistedProperty<?> property : unlistedProperties) {
            builder.add(property);
        }
        this.unlistedProperties = builder.build();
    }

    private static ImmutableMap<IUnlistedProperty<?>, Optional<?>> buildUnlistedMap(IUnlistedProperty<?>[] unlistedProperties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (IUnlistedProperty<?> p : unlistedProperties) {
            builder.put(p, (Object)Optional.absent());
        }
        return builder.build();
    }

    protected beg createState(atr block, ImmutableMap properties, ImmutableMap unlistedProperties) {
        return new ExtendedStateImplementation(block, properties, unlistedProperties, null);
    }

    protected static class ExtendedStateImplementation
    extends beg
    implements IExtendedBlockState {
        private final ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties;
        private Map<Map<bex, Comparable>, bec> normalMap;

        protected ExtendedStateImplementation(atr block, ImmutableMap properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties, ImmutableTable<bex, Comparable, bec> table) {
            super(block, properties);
            this.unlistedProperties = unlistedProperties;
            this.c = table;
        }

        public bec a(bex property, Comparable value) {
            if (!this.b().containsKey((Object)property)) {
                throw new IllegalArgumentException("Cannot set property " + property + " as it does not exist in " + this.c().O());
            }
            if (!property.c().contains(value)) {
                throw new IllegalArgumentException("Cannot set property " + property + " to " + value + " on block " + atr.c.c((Object)this.c()) + ", it is not an allowed value");
            }
            if (this.b().get((Object)property) == value) {
                return this;
            }
            if (Iterables.all((Iterable)this.unlistedProperties.values(), (Predicate)Predicates.equalTo((Object)Optional.absent()))) {
                return super.a(property, value);
            }
            HashMap<bex, Comparable> map = new HashMap<bex, Comparable>((Map<bex, Comparable>)this.b());
            map.put(property, value);
            ImmutableTable table = this.c;
            table = ((beg)table.get((Object)property, (Object)value)).getPropertyValueTable();
            return new ExtendedStateImplementation(this.c(), ImmutableMap.copyOf(map), this.unlistedProperties, (ImmutableTable<bex, Comparable, bec>)table);
        }

        @Override
        public <V> IExtendedBlockState withProperty(IUnlistedProperty<V> property, V value) {
            if (!this.unlistedProperties.containsKey(property)) {
                throw new IllegalArgumentException("Cannot set unlisted property " + property + " as it does not exist in " + this.c().O());
            }
            if (!property.isValid(value)) {
                throw new IllegalArgumentException("Cannot set unlisted property " + property + " to " + value + " on block " + atr.c.c((Object)this.c()) + ", it is not an allowed value");
            }
            HashMap newMap = new HashMap((Map<IUnlistedProperty<?>, Optional<?>>)this.unlistedProperties);
            newMap.put(property, Optional.fromNullable(value));
            if (Iterables.all(newMap.values(), (Predicate)Predicates.equalTo((Object)Optional.absent()))) {
                return (IExtendedBlockState)this.normalMap.get(this.b());
            }
            return new ExtendedStateImplementation(this.c(), this.b(), ImmutableMap.copyOf(newMap), (ImmutableTable<bex, Comparable, bec>)this.c);
        }

        @Override
        public Collection<IUnlistedProperty<?>> getUnlistedNames() {
            return Collections.unmodifiableCollection(this.unlistedProperties.keySet());
        }

        @Override
        public <V> V getValue(IUnlistedProperty<V> property) {
            if (!this.unlistedProperties.containsKey(property)) {
                throw new IllegalArgumentException("Cannot get unlisted property " + property + " as it does not exist in " + this.c().O());
            }
            return property.getType().cast(((Optional)this.unlistedProperties.get(property)).orNull());
        }

        @Override
        public ImmutableMap<IUnlistedProperty<?>, Optional<?>> getUnlistedProperties() {
            return this.unlistedProperties;
        }

        public void a(Map map) {
            this.normalMap = map;
            super.a(map);
        }
    }
}

