/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.io.FileInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.fml.common.CertificateHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ILanguageAdapter;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.ProxyInjector;
import net.minecraftforge.fml.common.asm.transformers.BlamingTransformer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.common.versioning.VersionRange;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public class FMLModContainer
implements ModContainer {
    private Object modInstance;
    private File source;
    private ModMetadata modMetadata;
    private String className;
    private Map<String, Object> descriptor;
    private boolean enabled = true;
    private String internalVersion;
    private boolean overridesMetadata;
    private EventBus eventBus;
    private LoadController controller;
    private DefaultArtifactVersion processedVersion;
    private String annotationDependencies;
    private VersionRange minecraftAccepted;
    private boolean fingerprintNotPresent;
    private Set<String> sourceFingerprints;
    private Certificate certificate;
    private String modLanguage;
    private ILanguageAdapter languageAdapter;
    private ModContainer.Disableable disableability;
    private ListMultimap<Class<? extends FMLEvent>, Method> eventMethods;
    private Map<String, String> customModProperties;
    private ModCandidate candidate;

    public FMLModContainer(String className, ModCandidate container, Map<String, Object> modDescriptor) {
        this.className = className;
        this.source = container.getModContainer();
        this.candidate = container;
        this.descriptor = modDescriptor;
        this.modLanguage = (String)modDescriptor.get("modLanguage");
        this.languageAdapter = "scala".equals(this.modLanguage) ? new ILanguageAdapter.ScalaAdapter() : new ILanguageAdapter.JavaAdapter();
        this.eventMethods = ArrayListMultimap.create();
    }

    private ILanguageAdapter getLanguageAdapter() {
        return this.languageAdapter;
    }

    @Override
    public String getModId() {
        return (String)this.descriptor.get("modid");
    }

    @Override
    public String getName() {
        return this.modMetadata.name;
    }

    @Override
    public String getVersion() {
        return this.internalVersion;
    }

    @Override
    public File getSource() {
        return this.source;
    }

    @Override
    public ModMetadata getMetadata() {
        return this.modMetadata;
    }

    @Override
    public void bindMetadata(MetadataCollection mc) {
        String mcVersionString;
        Properties versionProps;
        this.modMetadata = mc.getMetadataForId(this.getModId(), this.descriptor);
        if (this.descriptor.containsKey("useMetadata")) {
            boolean bl = this.overridesMetadata = (Boolean)this.descriptor.get("useMetadata") == false;
        }
        if (this.overridesMetadata || !this.modMetadata.useDependencyInformation) {
            HashSet requirements = Sets.newHashSet();
            ArrayList dependencies = Lists.newArrayList();
            ArrayList dependants = Lists.newArrayList();
            this.annotationDependencies = (String)this.descriptor.get("dependencies");
            Loader.instance().computeDependencies(this.annotationDependencies, requirements, dependencies, dependants);
            this.modMetadata.requiredMods = requirements;
            this.modMetadata.dependencies = dependencies;
            this.modMetadata.dependants = dependants;
            FMLLog.log(this.getModId(), Level.TRACE, "Parsed dependency info : %s %s %s", requirements, dependencies, dependants);
        } else {
            FMLLog.log(this.getModId(), Level.TRACE, "Using mcmod dependency info : %s %s %s", this.modMetadata.requiredMods, this.modMetadata.dependencies, this.modMetadata.dependants);
        }
        if (Strings.isNullOrEmpty((String)this.modMetadata.name)) {
            FMLLog.log(this.getModId(), Level.INFO, "Mod %s is missing the required element 'name'. Substituting %s", this.getModId(), this.getModId());
            this.modMetadata.name = this.getModId();
        }
        this.internalVersion = (String)this.descriptor.get("version");
        if (Strings.isNullOrEmpty((String)this.internalVersion) && (versionProps = this.searchForVersionProperties()) != null) {
            this.internalVersion = versionProps.getProperty(this.getModId() + ".version");
            FMLLog.log(this.getModId(), Level.DEBUG, "Found version %s for mod %s in version.properties, using", this.internalVersion, this.getModId());
        }
        if (Strings.isNullOrEmpty((String)this.internalVersion) && !Strings.isNullOrEmpty((String)this.modMetadata.version)) {
            FMLLog.log(this.getModId(), Level.WARN, "Mod %s is missing the required element 'version' and a version.properties file could not be found. Falling back to metadata version %s", this.getModId(), this.modMetadata.version);
            this.internalVersion = this.modMetadata.version;
        }
        if (Strings.isNullOrEmpty((String)this.internalVersion)) {
            FMLLog.log(this.getModId(), Level.WARN, "Mod %s is missing the required element 'version' and no fallback can be found. Substituting '1.0'.", this.getModId());
            this.internalVersion = "1.0";
            this.modMetadata.version = "1.0";
        }
        this.minecraftAccepted = !Strings.isNullOrEmpty((String)(mcVersionString = (String)this.descriptor.get("acceptedMinecraftVersions"))) ? VersionParser.parseRange(mcVersionString) : Loader.instance().getMinecraftModContainer().getStaticVersionRange();
    }

    public Properties searchForVersionProperties() {
        try {
            File propsFile;
            FMLLog.log(this.getModId(), Level.DEBUG, "Attempting to load the file version.properties from %s to locate a version number for %s", this.getSource().getName(), this.getModId());
            Properties version = null;
            if (this.getSource().isFile()) {
                ZipFile source = new ZipFile(this.getSource());
                ZipEntry versionFile = source.getEntry("version.properties");
                if (versionFile != null) {
                    version = new Properties();
                    version.load(source.getInputStream(versionFile));
                }
                source.close();
            } else if (this.getSource().isDirectory() && (propsFile = new File(this.getSource(), "version.properties")).exists() && propsFile.isFile()) {
                version = new Properties();
                FileInputStream fis = new FileInputStream(propsFile);
                version.load(fis);
                fis.close();
            }
            return version;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            FMLLog.log(this.getModId(), Level.TRACE, "Failed to find a usable version.properties file", new Object[0]);
            return null;
        }
    }

    @Override
    public void setEnabledState(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Set<ArtifactVersion> getRequirements() {
        return this.modMetadata.requiredMods;
    }

    @Override
    public List<ArtifactVersion> getDependencies() {
        return this.modMetadata.dependencies;
    }

    @Override
    public List<ArtifactVersion> getDependants() {
        return this.modMetadata.dependants;
    }

    @Override
    public String getSortingRules() {
        return this.overridesMetadata || !this.modMetadata.useDependencyInformation ? Strings.nullToEmpty((String)this.annotationDependencies) : this.modMetadata.printableSortingRules();
    }

    @Override
    public boolean matches(Object mod) {
        return mod == this.modInstance;
    }

    @Override
    public Object getMod() {
        return this.modInstance;
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        if (this.enabled) {
            FMLLog.log(this.getModId(), Level.DEBUG, "Enabling mod %s", this.getModId());
            this.eventBus = bus;
            this.controller = controller;
            this.eventBus.register((Object)this);
            return true;
        }
        return false;
    }

    private Method gatherAnnotations(Class<?> clazz) throws Exception {
        Method factoryMethod = null;
        for (Method m : clazz.getDeclaredMethods()) {
            for (Annotation a2 : m.getAnnotations()) {
                if (a2.annotationType().equals(Mod.EventHandler.class)) {
                    if (m.getParameterTypes().length == 1 && FMLEvent.class.isAssignableFrom(m.getParameterTypes()[0])) {
                        m.setAccessible(true);
                        this.eventMethods.put(m.getParameterTypes()[0], (Object)m);
                        continue;
                    }
                    FMLLog.log(this.getModId(), Level.ERROR, "The mod %s appears to have an invalid event annotation %s. This annotation can only apply to methods with recognized event arguments - it will not be called", this.getModId(), a2.annotationType().getSimpleName());
                    continue;
                }
                if (!a2.annotationType().equals(Mod.InstanceFactory.class)) continue;
                if (Modifier.isStatic(m.getModifiers()) && m.getParameterTypes().length == 0 && factoryMethod == null) {
                    m.setAccessible(true);
                    factoryMethod = m;
                    continue;
                }
                if (!Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length != 0) {
                    FMLLog.log(this.getModId(), Level.ERROR, "The InstanceFactory annotation can only apply to a static method, taking zero arguments - it will be ignored on %s(%s)", m.getName(), Arrays.asList(m.getParameterTypes()));
                    continue;
                }
                if (factoryMethod == null) continue;
                FMLLog.log(this.getModId(), Level.ERROR, "The InstanceFactory annotation can only be used once, the application to %s(%s) will be ignored", m.getName(), Arrays.asList(m.getParameterTypes()));
            }
        }
        return factoryMethod;
    }

    private void processFieldAnnotations(ASMDataTable asmDataTable) throws Exception {
        SetMultimap<String, ASMDataTable.ASMData> annotations = asmDataTable.getAnnotationsFor(this);
        this.parseSimpleFieldAnnotation(annotations, Mod.Instance.class.getName(), new Function<ModContainer, Object>(){

            public Object apply(ModContainer mc) {
                return mc.getMod();
            }
        });
        this.parseSimpleFieldAnnotation(annotations, Mod.Metadata.class.getName(), new Function<ModContainer, Object>(){

            public Object apply(ModContainer mc) {
                return mc.getMetadata();
            }
        });
    }

    private void parseSimpleFieldAnnotation(SetMultimap<String, ASMDataTable.ASMData> annotations, String annotationClassName, Function<ModContainer, Object> retreiver) throws IllegalAccessException {
        String[] annName = annotationClassName.split("\\.");
        String annotationName = annName[annName.length - 1];
        for (ASMDataTable.ASMData targets : annotations.get((Object)annotationClassName)) {
            String targetMod = (String)targets.getAnnotationInfo().get("value");
            Field f = null;
            Object injectedMod = null;
            ModContainer mc = this;
            boolean isStatic = false;
            Class<?> clz = this.modInstance.getClass();
            if (!Strings.isNullOrEmpty((String)targetMod)) {
                mc = Loader.isModLoaded(targetMod) ? Loader.instance().getIndexedModList().get(targetMod) : null;
            }
            if (mc != null) {
                try {
                    clz = Class.forName(targets.getClassName(), true, Loader.instance().getModClassLoader());
                    f = clz.getDeclaredField(targets.getObjectName());
                    f.setAccessible(true);
                    isStatic = Modifier.isStatic(f.getModifiers());
                    injectedMod = retreiver.apply((Object)mc);
                }
                catch (Exception e) {
                    Throwables.propagateIfPossible((Throwable)e);
                    FMLLog.log(this.getModId(), Level.WARN, e, "Attempting to load @%s in class %s for %s and failing", annotationName, targets.getClassName(), mc.getModId());
                }
            }
            if (f == null) continue;
            Object target = null;
            if (!isStatic) {
                target = this.modInstance;
                if (!this.modInstance.getClass().equals(clz)) {
                    FMLLog.log(this.getModId(), Level.WARN, "Unable to inject @%s in non-static field %s.%s for %s as it is NOT the primary mod instance", annotationName, targets.getClassName(), targets.getObjectName(), mc.getModId());
                    continue;
                }
            }
            f.set(target, injectedMod);
        }
    }

    @Subscribe
    public void constructMod(FMLConstructionEvent event) {
        try {
            boolean hasReverseDepends;
            List props;
            BlamingTransformer.addClasses(this.getModId(), this.candidate.getClassList());
            ModClassLoader modClassLoader = event.getModClassLoader();
            modClassLoader.addFile(this.source);
            modClassLoader.clearNegativeCacheFor(this.candidate.getClassList());
            Class<?> clazz = Class.forName(this.className, true, modClassLoader);
            Certificate[] certificates = clazz.getProtectionDomain().getCodeSource().getCertificates();
            int len = 0;
            if (certificates != null) {
                len = certificates.length;
            }
            ImmutableList.Builder certBuilder = ImmutableList.builder();
            for (int i = 0; i < len; ++i) {
                certBuilder.add((Object)CertificateHelper.getFingerprint(certificates[i]));
            }
            ImmutableList certList = certBuilder.build();
            this.sourceFingerprints = ImmutableSet.copyOf((Collection)certList);
            String expectedFingerprint = (String)this.descriptor.get("certificateFingerprint");
            this.fingerprintNotPresent = true;
            if (expectedFingerprint != null && !expectedFingerprint.isEmpty()) {
                if (!this.sourceFingerprints.contains(expectedFingerprint)) {
                    Level warnLevel = Level.ERROR;
                    if (this.source.isDirectory()) {
                        warnLevel = Level.TRACE;
                    }
                    FMLLog.log(this.getModId(), warnLevel, "The mod %s is expecting signature %s for source %s, however there is no signature matching that description", this.getModId(), expectedFingerprint, this.source.getName());
                } else {
                    this.certificate = certificates[certList.indexOf((Object)expectedFingerprint)];
                    this.fingerprintNotPresent = false;
                }
            }
            if ((props = (List)this.descriptor.get("customProperties")) != null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map p : props) {
                    builder.put((Object)((String)p.get("k")), (Object)((String)p.get("v")));
                }
                this.customModProperties = builder.build();
            } else {
                this.customModProperties = EMPTY_PROPERTIES;
            }
            Boolean hasDisableableFlag = (Boolean)this.descriptor.get("canBeDeactivated");
            boolean bl = hasReverseDepends = !event.getReverseDependencies().get((Object)this.getModId()).isEmpty();
            this.disableability = hasDisableableFlag != null && hasDisableableFlag != false ? (hasReverseDepends ? ModContainer.Disableable.DEPENDENCIES : ModContainer.Disableable.YES) : (hasReverseDepends ? ModContainer.Disableable.DEPENDENCIES : ModContainer.Disableable.RESTART);
            Method factoryMethod = this.gatherAnnotations(clazz);
            this.modInstance = this.getLanguageAdapter().getNewInstance(this, clazz, modClassLoader, factoryMethod);
            NetworkRegistry.INSTANCE.register(this, clazz, (String)(this.descriptor.containsKey("acceptableRemoteVersions") ? this.descriptor.get("acceptableRemoteVersions") : null), event.getASMHarvestedData());
            if (this.fingerprintNotPresent) {
                this.eventBus.post((Object)new FMLFingerprintViolationEvent(this.source.isDirectory(), this.source, (ImmutableSet<String>)ImmutableSet.copyOf(this.sourceFingerprints), expectedFingerprint));
            }
            ProxyInjector.inject(this, event.getASMHarvestedData(), FMLCommonHandler.instance().getSide(), this.getLanguageAdapter());
            this.processFieldAnnotations(event.getASMHarvestedData());
        }
        catch (Throwable e) {
            this.controller.errorOccurred(this, e);
            Throwables.propagateIfPossible((Throwable)e);
        }
    }

    @Subscribe
    public void handleModStateEvent(FMLEvent event) {
        if (!this.eventMethods.containsKey(event.getClass())) {
            return;
        }
        try {
            for (Method m : this.eventMethods.get(event.getClass())) {
                m.invoke(this.modInstance, event);
            }
        }
        catch (Throwable t) {
            this.controller.errorOccurred(this, t);
        }
    }

    @Override
    public ArtifactVersion getProcessedVersion() {
        if (this.processedVersion == null) {
            this.processedVersion = new DefaultArtifactVersion(this.getModId(), this.getVersion());
        }
        return this.processedVersion;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public String getDisplayVersion() {
        return this.modMetadata.version;
    }

    @Override
    public VersionRange acceptableMinecraftVersionRange() {
        return this.minecraftAccepted;
    }

    @Override
    public Certificate getSigningCertificate() {
        return this.certificate;
    }

    public String toString() {
        return "FMLMod:" + this.getModId() + "{" + this.getVersion() + "}";
    }

    @Override
    public Map<String, String> getCustomModProperties() {
        return this.customModProperties;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        try {
            return this.getSource().isDirectory() ? Class.forName("net.minecraftforge.fml.client.FMLFolderResourcePack", true, this.getClass().getClassLoader()) : Class.forName("net.minecraftforge.fml.client.FMLFileResourcePack", true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public Map<String, String> getSharedModDescriptor() {
        HashMap descriptor = Maps.newHashMap();
        descriptor.put("modsystem", "FML");
        descriptor.put("id", this.getModId());
        descriptor.put("version", this.getDisplayVersion());
        descriptor.put("name", this.getName());
        descriptor.put("url", this.modMetadata.url);
        descriptor.put("authors", this.modMetadata.getAuthorList());
        descriptor.put("description", this.modMetadata.description);
        return descriptor;
    }

    @Override
    public ModContainer.Disableable canBeDisabled() {
        return this.disableability;
    }

    @Override
    public String getGuiClassName() {
        return (String)this.descriptor.get("guiFactory");
    }

    @Override
    public List<String> getOwnedPackages() {
        return this.candidate.getContainedPackages();
    }

    private boolean isTrue(Boolean value) {
        if (value == null) {
            return false;
        }
        return value;
    }

    @Override
    public boolean shouldLoadInEnvironment() {
        boolean clientSideOnly = this.isTrue((Boolean)this.descriptor.get("clientSideOnly"));
        boolean serverSideOnly = this.isTrue((Boolean)this.descriptor.get("serverSideOnly"));
        if (clientSideOnly && serverSideOnly) {
            throw new RuntimeException("Mod annotation claims to be both client and server side only!");
        }
        Side side = FMLCommonHandler.instance().getSide();
        if (clientSideOnly && side != Side.CLIENT) {
            FMLLog.info("Disabling mod %d it is client side only.", this.getModId());
            return false;
        }
        if (serverSideOnly && side != Side.SERVER) {
            FMLLog.info("Disabling mod %d it is server side only.", this.getModId());
            return false;
        }
        return true;
    }
}

