/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.common.util.EnumHelper;

public class BiomeManager {
    private static TrackedList<BiomeEntry>[] biomes = BiomeManager.setupBiomes();
    private static boolean isModded = false;
    public static List<arm> oceanBiomes = new ArrayList<arm>();
    public static ArrayList<arm> strongHoldBiomes = new ArrayList();
    public static ArrayList<arm> strongHoldBiomesBlackList = new ArrayList();

    private static TrackedList<BiomeEntry>[] setupBiomes() {
        TrackedList[] currentBiomes = new TrackedList[BiomeType.values().length];
        ArrayList<BiomeEntry> list = new ArrayList<BiomeEntry>();
        list.add(new BiomeEntry(arm.t, 10));
        list.add(new BiomeEntry(arm.S, 10));
        list.add(new BiomeEntry(arm.s, 10));
        list.add(new BiomeEntry(arm.q, 10));
        list.add(new BiomeEntry(arm.Q, 10));
        list.add(new BiomeEntry(arm.v, 10));
        currentBiomes[BiomeType.WARM.ordinal()] = new TrackedList(list);
        list.clear();
        list.add(new BiomeEntry(arm.t, 10));
        list.add(new BiomeEntry(arm.s, 10));
        list.add(new BiomeEntry(arm.u, 10));
        list.add(new BiomeEntry(arm.q, 10));
        currentBiomes[BiomeType.COOL.ordinal()] = new TrackedList(list);
        list.clear();
        list.add(new BiomeEntry(arm.B, 30));
        list.add(new BiomeEntry(arm.T, 10));
        currentBiomes[BiomeType.ICY.ordinal()] = new TrackedList(list);
        list.clear();
        currentBiomes[BiomeType.DESERT.ordinal()] = new TrackedList(list);
        return currentBiomes;
    }

    public static void addVillageBiome(arm biome, boolean canSpawn) {
        if (!bmw.d.contains(biome)) {
            ArrayList<arm> biomes = new ArrayList<arm>(bmw.d);
            biomes.add(biome);
            bmw.d = biomes;
        }
    }

    public static void removeVillageBiome(arm biome) {
        if (bmw.d.contains(biome)) {
            ArrayList biomes = new ArrayList(bmw.d);
            biomes.remove(biome);
            bmw.d = biomes;
        }
    }

    public static void addStrongholdBiome(arm biome) {
        if (!strongHoldBiomes.contains(biome)) {
            strongHoldBiomes.add(biome);
        }
    }

    public static void removeStrongholdBiome(arm biome) {
        if (!strongHoldBiomesBlackList.contains(biome)) {
            strongHoldBiomesBlackList.add(biome);
        }
    }

    public static void addSpawnBiome(arm biome) {
        if (!arz.allowedBiomes.contains(biome)) {
            arz.allowedBiomes.add(biome);
        }
    }

    public static void removeSpawnBiome(arm biome) {
        if (arz.allowedBiomes.contains(biome)) {
            arz.allowedBiomes.remove(biome);
        }
    }

    public static void addBiome(BiomeType type, BiomeEntry entry) {
        TrackedList<BiomeEntry> list;
        isModded = true;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null) {
            list.add(entry);
        }
    }

    public static void removeBiome(BiomeType type, BiomeEntry entry) {
        TrackedList<BiomeEntry> list;
        isModded = true;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null && list.contains((Object)entry)) {
            list.remove((Object)entry);
        }
    }

    public static ImmutableList<BiomeEntry> getBiomes(BiomeType type) {
        int idx = type.ordinal();
        TrackedList<BiomeEntry> list = idx > biomes.length ? null : biomes[idx];
        return list != null ? ImmutableList.copyOf(list) : null;
    }

    public static boolean isTypeListModded(BiomeType type) {
        TrackedList<BiomeEntry> list;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null) {
            return list.isModded();
        }
        return false;
    }

    static /* synthetic */ TrackedList[] access$002(TrackedList[] x0) {
        biomes = x0;
        return x0;
    }

    static {
        oceanBiomes.add(arm.p);
        oceanBiomes.add(arm.N);
        oceanBiomes.add(arm.z);
    }

    private static class TrackedList<E>
    extends ArrayList<E> {
        private boolean isModded = false;

        public TrackedList(Collection<? extends E> c) {
            super(c);
        }

        @Override
        public E set(int index, E element) {
            this.isModded = true;
            return super.set(index, element);
        }

        @Override
        public boolean add(E e) {
            this.isModded = true;
            return super.add(e);
        }

        @Override
        public void add(int index, E element) {
            this.isModded = true;
            super.add(index, element);
        }

        @Override
        public E remove(int index) {
            this.isModded = true;
            return super.remove(index);
        }

        @Override
        public boolean remove(Object o) {
            this.isModded = true;
            return super.remove(o);
        }

        @Override
        public void clear() {
            this.isModded = true;
            super.clear();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            this.isModded = true;
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.isModded = true;
            return super.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            this.isModded = true;
            return super.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            this.isModded = true;
            return super.retainAll(c);
        }

        public boolean isModded() {
            return this.isModded;
        }
    }

    public static class BiomeEntry
    extends vk {
        public final arm biome;

        public BiomeEntry(arm biome, int weight) {
            super(weight);
            this.biome = biome;
        }
    }

    public static enum BiomeType {
        DESERT,
        WARM,
        COOL,
        ICY;


        public static BiomeType getType(String name) {
            name = name.toUpperCase();
            for (BiomeType t : BiomeType.values()) {
                if (!t.name().equals(name)) continue;
                return t;
            }
            BiomeType ret = EnumHelper.addEnum(BiomeType.class, name, BiomeType.class);
            if (ret.ordinal() >= biomes.length) {
                BiomeManager.access$002(Arrays.copyOf(biomes, ret.ordinal()));
            }
            return ret;
        }
    }
}

