/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.io.Serializable;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockSnapshot
implements Serializable {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockSnapshot", "false"));
    public final dt pos;
    public final int dimId;
    public transient bec replacedBlock;
    public int flag;
    private final fn nbt;
    public transient aqu world;
    public final GameRegistry.UniqueIdentifier blockIdentifier;
    public final int meta;

    public BlockSnapshot(aqu world, dt pos, bec state) {
        this.world = world;
        this.dimId = world.t.q();
        this.pos = pos;
        this.replacedBlock = state;
        this.blockIdentifier = GameRegistry.findUniqueIdentifierFor(state.c());
        this.meta = state.c().c(state);
        this.flag = 3;
        bcm te = world.s(pos);
        if (te != null) {
            this.nbt = new fn();
            te.b(this.nbt);
        } else {
            this.nbt = null;
        }
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.P().k(), pos.n(), pos.o(), pos.p(), this.blockIdentifier, this.meta);
        }
    }

    public BlockSnapshot(aqu world, dt pos, bec state, fn nbt) {
        this.world = world;
        this.dimId = world.t.q();
        this.pos = pos;
        this.replacedBlock = state;
        this.blockIdentifier = GameRegistry.findUniqueIdentifierFor(state.c());
        this.meta = state.c().c(state);
        this.flag = 3;
        this.nbt = nbt;
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.P().k(), pos.n(), pos.o(), pos.p(), this.blockIdentifier, this.meta);
        }
    }

    public BlockSnapshot(aqu world, dt pos, bec state, int flag) {
        this(world, pos, state);
        this.flag = flag;
    }

    public BlockSnapshot(int dimension, dt pos, String modid, String blockName, int meta, int flag, fn nbt) {
        this.dimId = dimension;
        this.pos = pos;
        this.flag = flag;
        this.blockIdentifier = new GameRegistry.UniqueIdentifier(modid + ":" + blockName);
        this.meta = meta;
        this.nbt = nbt;
    }

    public static BlockSnapshot getBlockSnapshot(aqu world, dt pos) {
        return new BlockSnapshot(world, pos, world.p(pos));
    }

    public static BlockSnapshot getBlockSnapshot(aqu world, dt pos, int flag) {
        return new BlockSnapshot(world, pos, world.p(pos), flag);
    }

    public static BlockSnapshot readFromNBT(fn tag) {
        fn nbt = tag.n("hasTE") ? null : tag.m("tileEntity");
        return new BlockSnapshot(tag.f("dimension"), new dt(tag.f("posX"), tag.f("posY"), tag.f("posZ")), tag.j("blockMod"), tag.j("blockName"), tag.f("metadata"), tag.f("flag"), nbt);
    }

    public bec getCurrentBlock() {
        return this.world.p(this.pos);
    }

    public aqu getWorld() {
        if (this.world == null) {
            this.world = DimensionManager.getWorld(this.dimId);
        }
        return this.world;
    }

    public bec getReplacedBlock() {
        if (this.replacedBlock == null) {
            this.replacedBlock = GameRegistry.findBlock(this.blockIdentifier.modId, this.blockIdentifier.name).a(this.meta);
        }
        return this.replacedBlock;
    }

    public bcm getTileEntity() {
        if (this.nbt != null) {
            return bcm.c((fn)this.nbt);
        }
        return null;
    }

    public boolean restore() {
        return this.restore(false);
    }

    public boolean restore(boolean force) {
        return this.restore(force, true);
    }

    public boolean restore(boolean force, boolean applyPhysics) {
        bec current = this.getCurrentBlock();
        bec replaced = this.getReplacedBlock();
        if (current.c() != replaced.c() || current.c().c(current) != replaced.c().c(replaced)) {
            if (force) {
                this.world.a(this.pos, replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        this.world.a(this.pos, replaced, applyPhysics ? 3 : 2);
        this.world.h(this.pos);
        bcm te = null;
        if (this.nbt != null && (te = this.world.s(this.pos)) != null) {
            te.a(this.nbt);
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", this.world.P().k(), this.pos.n(), this.pos.o(), this.pos.p(), replaced.c().c(replaced), replaced.c().delegate.name(), te, force, applyPhysics);
        }
        return true;
    }

    public boolean restoreToLocation(aqu world, dt pos, boolean force, boolean applyPhysics) {
        bec current = this.getCurrentBlock();
        bec replaced = this.getReplacedBlock();
        if (current.c() != replaced.c() || current.c().c(current) != replaced.c().c(replaced)) {
            if (force) {
                world.a(pos, replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        world.a(pos, replaced, applyPhysics ? 3 : 2);
        world.h(pos);
        bcm te = null;
        if (this.nbt != null && (te = world.s(pos)) != null) {
            te.a(this.nbt);
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", world.P().k(), pos.n(), pos.o(), pos.p(), replaced.c().c(replaced), replaced.c().delegate.name(), te, force, applyPhysics);
        }
        return true;
    }

    public void writeToNBT(fn compound) {
        compound.a("blockMod", this.blockIdentifier.modId);
        compound.a("blockName", this.blockIdentifier.name);
        compound.a("posX", this.pos.n());
        compound.a("posY", this.pos.o());
        compound.a("posZ", this.pos.p());
        compound.a("flag", this.flag);
        compound.a("dimension", this.dimId);
        compound.a("metadata", this.meta);
        compound.a("hasTE", this.nbt != null);
        if (this.nbt != null) {
            compound.a("tileEntity", (gd)this.nbt);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockSnapshot other = (BlockSnapshot)obj;
        if (!this.pos.equals((Object)other.pos)) {
            return false;
        }
        if (this.meta != other.meta) {
            return false;
        }
        if (this.dimId != other.dimId) {
            return false;
        }
        if (!(this.nbt == other.nbt || this.nbt != null && this.nbt.equals((Object)other.nbt))) {
            return false;
        }
        if (!(this.world == other.world || this.world != null && this.world.equals(other.world))) {
            return false;
        }
        return this.blockIdentifier == other.blockIdentifier || this.blockIdentifier != null && this.blockIdentifier.equals(other.blockIdentifier);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.pos.n();
        hash = 73 * hash + this.pos.o();
        hash = 73 * hash + this.pos.p();
        hash = 73 * hash + this.meta;
        hash = 73 * hash + this.dimId;
        hash = 73 * hash + (this.nbt != null ? this.nbt.hashCode() : 0);
        hash = 73 * hash + (this.world != null ? this.world.hashCode() : 0);
        hash = 73 * hash + (this.blockIdentifier != null ? this.blockIdentifier.hashCode() : 0);
        return hash;
    }
}

