/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.consolefilter;

import com.chaosthedude.consolefilter.FilterEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConsoleFilterConfig {
    private ForgeConfigSpec.ConfigValue<List<? extends String>> basicFilters;
    private ForgeConfigSpec.ConfigValue<List<? extends String>> regexFilters;
    private ForgeConfigSpec spec;
    private List<FilterEntry> filterList = new ArrayList<FilterEntry>();

    public void init() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("general");
        this.basicFilters = builder.comment("Any console messages containing any of these strings will be hidden.").defineList("basicFilters", Collections.emptyList(), obj -> true);
        this.regexFilters = builder.comment("Any console messages that match any of these regular expressions will be hidden. Uses Java style regex. Backslashes must be escaped, for example use \\\\s instead of \\s to match whitespace.").defineList("regexFilters", Collections.emptyList(), obj -> true);
        builder.pop();
        this.spec = builder.build();
    }

    public void load() {
        for (String entry : (List)this.basicFilters.get()) {
            this.filterList.add(FilterEntry.wildcard(entry));
        }
        for (String entry : (List)this.regexFilters.get()) {
            this.filterList.add(FilterEntry.regex(entry));
        }
    }

    public boolean shouldFilter(String message) {
        for (FilterEntry entry : this.filterList) {
            if (!entry.shouldFilter(message)) continue;
            return true;
        }
        return false;
    }

    public int filterCount() {
        return this.filterList.size();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }
}

