/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class LokiPlaceTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("loki_placed_blocks");
    public static final LokiPlaceTrigger INSTANCE = new LokiPlaceTrigger();

    private LokiPlaceTrigger() {
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return ID;
    }

    @NotNull
    public Instance createInstance(@NotNull JsonObject json, EntityPredicate.Composite playerPred, DeserializationContext conditions) {
        return new Instance(playerPred, EntityPredicate.m_36614_((JsonElement)json.get("player")), ItemPredicate.m_45051_((JsonElement)json.get("ring")), MinMaxBounds.Ints.m_55373_((JsonElement)json.get("blocks_placed")));
    }

    public void trigger(ServerPlayer player, ItemStack ring, int blocksPlaced) {
        this.m_66234_(player, instance -> instance.test(player, ring, blocksPlaced));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final EntityPredicate player;
        private final ItemPredicate ring;
        private final MinMaxBounds.Ints blocksPlaced;

        public Instance(EntityPredicate.Composite playerPred, EntityPredicate player, ItemPredicate ring, MinMaxBounds.Ints blocksPlaced) {
            super(ID, playerPred);
            this.player = player;
            this.ring = ring;
            this.blocksPlaced = blocksPlaced;
        }

        @NotNull
        public ResourceLocation m_7294_() {
            return ID;
        }

        boolean test(ServerPlayer player, ItemStack ring, int blocksPlaced) {
            return this.player.m_36611_(player, null) && this.ring.m_45049_(ring) && this.blocksPlaced.m_55390_(blocksPlaced);
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject json = super.m_7683_(context);
            if (this.ring != ItemPredicate.f_45028_) {
                json.add("ring", this.ring.m_45048_());
            }
            if (this.blocksPlaced != MinMaxBounds.Ints.f_55364_) {
                json.add("blocks_placed", this.blocksPlaced.m_55328_());
            }
            return json;
        }

        public EntityPredicate getPlayer() {
            return this.player;
        }

        public ItemPredicate getRing() {
            return this.ring;
        }

        public MinMaxBounds.Ints getBlocksPlaced() {
            return this.blocksPlaced;
        }
    }
}

