/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaCollisionGhost;
import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.block.block_entity.PlatformBlockEntity;

public class PlatformBlock
extends BotaniaBlock
implements ManaCollisionGhost,
EntityBlock {
    private final Variant variant;

    public PlatformBlock(@NotNull Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
    }

    public Variant getVariant() {
        return this.variant;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        PlatformBlockEntity platform;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof PlatformBlockEntity && (platform = (PlatformBlockEntity)te).getCamoState() != null) {
            return platform.getCamoState().m_60808_(world, pos);
        }
        return super.m_5940_(state, world, pos, context);
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, CollisionContext context) {
        if (this.variant.collide.test(pos, context)) {
            return super.m_5940_(state, world, pos, context);
        }
        return Shapes.m_83040_();
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PlatformBlockEntity(pos, state);
    }

    @Override
    public ManaCollisionGhost.Behaviour getGhostBehaviour() {
        return ManaCollisionGhost.Behaviour.SKIP_ALL;
    }

    public static boolean isValidBlock(@Nullable BlockState state, Level world, BlockPos pos) {
        return state != null && (state.m_60804_((BlockGetter)world, pos) || state.m_60799_() == RenderShape.MODEL);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.variant.indestructible) {
            tooltip.add((Component)Component.m_237115_((String)"botaniamisc.creative").m_130940_(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile = world.m_7702_(pos);
        ItemStack currentStack = player.m_21120_(hand);
        if (this.variant.indestructible && !player.m_7500_()) {
            return InteractionResult.PASS;
        }
        if (!currentStack.m_41619_() && Block.m_49814_((Item)currentStack.m_41720_()) != Blocks.f_50016_ && tile instanceof PlatformBlockEntity) {
            PlatformBlockEntity camo = (PlatformBlockEntity)tile;
            BlockPlaceContext ctx = new BlockPlaceContext(player, hand, currentStack, hit);
            BlockState changeState = Block.m_49814_((Item)currentStack.m_41720_()).m_5573_(ctx);
            if (PlatformBlock.isValidBlock(changeState, world, pos) && !(changeState.m_60734_() instanceof PlatformBlock) && changeState.m_60767_() != Material.f_76296_) {
                if (!world.f_46443_) {
                    camo.setCamoState(changeState);
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    public static enum Variant {
        ABSTRUSE(false, (pos, context) -> {
            if (context instanceof EntityCollisionContext) {
                EntityCollisionContext econtext = (EntityCollisionContext)context;
                Entity e = econtext.m_193113_();
                return e == null || e.m_20186_() > (double)pos.m_123342_() + 0.9 && !context.m_6226_();
            }
            return true;
        }),
        SPECTRAL(false, (pos, context) -> false),
        INFRANGIBLE(true, (pos, context) -> true);

        public final boolean indestructible;
        public final BiPredicate<BlockPos, CollisionContext> collide;

        private Variant(boolean i, BiPredicate<BlockPos, CollisionContext> p) {
            this.indestructible = i;
            this.collide = p;
        }
    }
}

