/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.WandOfTheForestItem;

public class ManaSpreaderBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = ManaSpreaderBlock.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE_PADDING = ManaSpreaderBlock.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_SCAFFOLDING = ManaSpreaderBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public final Variant variant;

    public ManaSpreaderBlock(Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BotaniaStateProperties.HAS_SCAFFOLDING, (Comparable)Boolean.valueOf(false)));
        this.variant = v;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BotaniaStateProperties.HAS_SCAFFOLDING});
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        VoxelShape voxelShape;
        if (((Boolean)blockState.m_61143_((Property)BotaniaStateProperties.HAS_SCAFFOLDING)).booleanValue()) {
            return SHAPE_SCAFFOLDING;
        }
        BlockEntity be = blockGetter.m_7702_(blockPos);
        if (be instanceof ManaSpreaderBlockEntity) {
            ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity)be;
            if (spreader.paddingColor != null) {
                voxelShape = SHAPE_PADDING;
                return voxelShape;
            }
        }
        voxelShape = SHAPE;
        return voxelShape;
    }

    @NotNull
    public VoxelShape m_7952_(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return SHAPE;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction orientation = placer == null ? Direction.WEST : Direction.m_122382_((Entity)placer)[0].m_122424_();
        ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity)world.m_7702_(pos);
        switch (orientation) {
            case DOWN: {
                spreader.rotationY = -90.0f;
                break;
            }
            case UP: {
                spreader.rotationY = 90.0f;
                break;
            }
            case NORTH: {
                spreader.rotationX = 270.0f;
                break;
            }
            case SOUTH: {
                spreader.rotationX = 90.0f;
                break;
            }
            case WEST: {
                break;
            }
            case EAST: {
                spreader.rotationX = 180.0f;
            }
        }
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean shouldInsert;
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof ManaSpreaderBlockEntity)) {
            return InteractionResult.PASS;
        }
        ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity)tile;
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() instanceof WandOfTheForestItem) {
            return InteractionResult.PASS;
        }
        boolean mainHandEmpty = player.m_21205_().m_41619_();
        ItemStack lens = spreader.getItemHandler().m_8020_(0);
        boolean playerHasLens = heldItem.m_41720_() instanceof BasicLensItem;
        boolean lensIsSame = playerHasLens && ItemStack.m_150942_((ItemStack)heldItem, (ItemStack)lens);
        ItemStack wool = spreader.paddingColor != null ? new ItemStack((ItemLike)ColorHelper.WOOL_MAP.apply(spreader.paddingColor)) : ItemStack.f_41583_;
        boolean playerHasWool = ColorHelper.isWool(Block.m_49814_((Item)heldItem.m_41720_()));
        boolean woolIsSame = playerHasWool && ItemStack.m_150942_((ItemStack)heldItem, (ItemStack)wool);
        boolean playerHasScaffolding = !heldItem.m_41619_() && heldItem.m_150930_(Items.f_42340_);
        boolean bl = shouldInsert = playerHasLens && !lensIsSame || playerHasWool && !woolIsSame || playerHasScaffolding && (Boolean)state.m_61143_((Property)BotaniaStateProperties.HAS_SCAFFOLDING) == false;
        if (shouldInsert) {
            if (playerHasLens) {
                ItemStack toInsert = heldItem.m_41777_();
                toInsert.m_41764_(1);
                heldItem.m_41774_(1);
                if (!lens.m_41619_()) {
                    player.m_150109_().m_150079_(lens);
                }
                spreader.getItemHandler().m_6836_(0, toInsert);
                world.m_5594_(player, pos, BotaniaSounds.spreaderAddLens, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (playerHasWool) {
                Block woolBlock = Block.m_49814_((Item)heldItem.m_41720_());
                heldItem.m_41774_(1);
                if (spreader.paddingColor != null) {
                    ItemStack spreaderWool = new ItemStack((ItemLike)ColorHelper.WOOL_MAP.apply(spreader.paddingColor));
                    player.m_150109_().m_150079_(spreaderWool);
                }
                spreader.paddingColor = ColorHelper.getWoolColor(woolBlock);
                spreader.m_6596_();
                world.m_5594_(player, pos, BotaniaSounds.spreaderCover, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)BotaniaStateProperties.HAS_SCAFFOLDING, (Comparable)Boolean.valueOf(true)));
                world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                world.m_5594_(player, pos, BotaniaSounds.spreaderScaffold, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (((Boolean)state.m_61143_((Property)BotaniaStateProperties.HAS_SCAFFOLDING)).booleanValue() && player.m_36341_()) {
            if (!player.m_150110_().f_35937_) {
                ItemStack scaffolding = new ItemStack((ItemLike)Items.f_42340_);
                player.m_150109_().m_150079_(scaffolding);
            }
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)BotaniaStateProperties.HAS_SCAFFOLDING, (Comparable)Boolean.valueOf(false)));
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
            world.m_5594_(player, pos, BotaniaSounds.spreaderUnScaffold, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (!lens.m_41619_() && (mainHandEmpty || lensIsSame)) {
            player.m_150109_().m_150079_(lens);
            spreader.getItemHandler().m_6836_(0, ItemStack.f_41583_);
            world.m_5594_(player, pos, BotaniaSounds.spreaderRemoveLens, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (spreader.paddingColor != null && (mainHandEmpty || woolIsSame)) {
            player.m_150109_().m_150079_(wool);
            spreader.paddingColor = null;
            spreader.m_6596_();
            world.m_5594_(player, pos, BotaniaSounds.spreaderUncover, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tile = world.m_7702_(pos);
            if (!(tile instanceof ManaSpreaderBlockEntity)) {
                return;
            }
            ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity)tile;
            if (spreader.paddingColor != null) {
                ItemStack padding = new ItemStack((ItemLike)ColorHelper.WOOL_MAP.apply(spreader.paddingColor));
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)padding);
            }
            if (((Boolean)state.m_61143_((Property)BotaniaStateProperties.HAS_SCAFFOLDING)).booleanValue()) {
                ItemStack scaffolding = new ItemStack((ItemLike)Items.f_42340_);
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)scaffolding);
            }
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)spreader.getItemHandler());
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ManaSpreaderBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ManaSpreaderBlock.createTickerHelper(type, BotaniaBlockEntities.SPREADER, ManaSpreaderBlockEntity::commonTick);
    }

    public static enum Variant {
        MANA(160, 1000, 0x20FF20, 65280, 60, 4.0f, 1.0f),
        REDSTONE(160, 1000, 0xFF2020, 0xFF0000, 60, 4.0f, 1.0f),
        ELVEN(240, 1000, 16729540, 16711854, 80, 4.0f, 1.25f),
        GAIA(640, 6400, 0x20FF20, 65280, 120, 20.0f, 2.0f);

        public final int burstMana;
        public final int manaCapacity;
        public final int color;
        public final int hudColor;
        public final int preLossTicks;
        public final float lossPerTick;
        public final float motionModifier;

        private Variant(int bm, int mc, int c, int hc, int plt, float lpt, float mm) {
            this.burstMana = bm;
            this.manaCapacity = mc;
            this.color = c;
            this.hudColor = hc;
            this.preLossTicks = plt;
            this.lossPerTick = lpt;
            this.motionModifier = mm;
        }
    }
}

