/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewContainer;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.mixin.client.MinecraftAccessor;

public class TaintedBloodPendantItem
extends BaubleItem
implements BrewContainer,
BrewItem {
    private static final String TAG_BREW_KEY = "brewKey";

    public TaintedBloodPendantItem(Item.Properties props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        super.m_6787_(tab, list);
        if (this.m_220152_(tab)) {
            for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
                ItemStack brewStack = this.getItemForBrew(brew, new ItemStack((ItemLike)this));
                if (brewStack.m_41619_()) continue;
                list.add((Object)brewStack);
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag adv) {
        super.m_7373_(stack, world, tooltip, adv);
        Brew brew = this.getBrew(stack);
        if (brew == BotaniaBrews.fallbackBrew) {
            tooltip.add((Component)Component.m_237115_((String)"botaniamisc.notInfused").m_130940_(ChatFormatting.LIGHT_PURPLE));
            return;
        }
        tooltip.add((Component)Component.m_237110_((String)"botaniamisc.brewOf", (Object[])new Object[]{I18n.m_118938_((String)brew.getTranslationKey(stack), (Object[])new Object[0])}).m_130940_(ChatFormatting.LIGHT_PURPLE));
        for (MobEffectInstance effect : brew.getPotionEffects(stack)) {
            ChatFormatting format = effect.m_19544_().m_19483_().m_19497_();
            MutableComponent cmp = Component.m_237115_((String)effect.m_19576_());
            if (effect.m_19564_() > 0) {
                cmp.m_130946_(" ");
                cmp.m_7220_((Component)Component.m_237115_((String)("botania.roman" + (effect.m_19564_() + 1))));
            }
            tooltip.add((Component)cmp.m_130940_(format));
        }
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        Brew brew = ((BrewItem)stack.m_41720_()).getBrew(stack);
        if (brew != BotaniaBrews.fallbackBrew && living instanceof Player) {
            Player player = (Player)living;
            if (!living.m_9236_().f_46443_) {
                boolean doRand;
                MobEffectInstance effect = brew.getPotionEffects(stack).get(0);
                float cost = (float)brew.getManaCost(stack) / (float)effect.m_19557_() / (float)(1 + effect.m_19564_()) * 2.5f;
                boolean bl = doRand = cost < 1.0f;
                if (ManaItemHandler.instance().requestManaExact(stack, player, (int)Math.ceil(cost), false)) {
                    boolean nightVision;
                    MobEffectInstance currentEffect = living.m_21124_(effect.m_19544_());
                    boolean bl2 = nightVision = effect.m_19544_() == MobEffects.f_19611_;
                    if (currentEffect == null || currentEffect.m_19557_() < (nightVision ? 305 : 3)) {
                        MobEffectInstance applyEffect = new MobEffectInstance(effect.m_19544_(), nightVision ? 385 : 80, effect.m_19564_(), true, true);
                        living.m_7292_(applyEffect);
                    }
                    if (!doRand || Math.random() < (double)cost) {
                        ManaItemHandler.instance().requestManaExact(stack, player, (int)Math.ceil(cost), true);
                    }
                }
            }
        }
    }

    @Override
    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
        return (Brew)BotaniaAPI.instance().getBrewRegistry().m_7745_(ResourceLocation.m_135820_((String)key));
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        TaintedBloodPendantItem.setBrew(stack, BotaniaAPI.instance().getBrewRegistry().m_7981_((Object)brew));
    }

    public static void setBrew(ItemStack stack, ResourceLocation brew) {
        ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew.toString());
    }

    @Override
    public ItemStack getItemForBrew(Brew brew, ItemStack stack) {
        if (!brew.canInfuseBloodPendant() || brew.getPotionEffects(stack).size() != 1 || brew.getPotionEffects(stack).get(0).m_19544_().m_8093_()) {
            return ItemStack.f_41583_;
        }
        ItemStack brewStack = new ItemStack((ItemLike)this);
        TaintedBloodPendantItem.setBrew(brewStack, brew);
        return brewStack;
    }

    @Override
    public int getManaCost(Brew brew, ItemStack stack) {
        return brew.getManaCost() * 10;
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean armor = !living.m_6844_(EquipmentSlot.CHEST).m_41619_();
            bipedModel.f_102810_.m_104299_(ms);
            ms.m_85837_(-0.25, 0.4, armor ? 0.05 : 0.12);
            ms.m_85841_(0.5f, -0.5f, -0.5f);
            BakedModel model = MiscellaneousModels.INSTANCE.bloodPendantChain;
            VertexConsumer buffer = buffers.m_6299_(Sheets.m_110790_());
            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(ms.m_85850_(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
            model = MiscellaneousModels.INSTANCE.bloodPendantGem;
            int color = ((MinecraftAccessor)Minecraft.m_91087_()).getItemColors().m_92676_(stack, 1);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(ms.m_85850_(), buffer, null, model, r, g, b, 0xF000F0, OverlayTexture.f_118083_);
        }
    }
}

