/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.capability;

import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManaCapAttacher {
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        ManaCapProvider provider = new ManaCapProvider();
        event.addCapability(ManaCapProvider.IDENTIFIER, (ICapabilityProvider)provider);
    }

    private static class ManaCapProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static final ResourceLocation IDENTIFIER = new ResourceLocation("ars_nouveau", "mana");
        private final IManaCap backend = new ManaCap(null);
        private final LazyOptional<IManaCap> optionalData = LazyOptional.of(() -> this.backend);

        private ManaCapProvider() {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return CapabilityRegistry.MANA_CAPABILITY.orEmpty(cap, this.optionalData);
        }

        void invalidate() {
            this.optionalData.invalidate();
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.backend.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.deserializeNBT((Tag)nbt);
        }
    }
}

