/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class EntitySpellArrow
extends Arrow {
    public SpellResolver spellResolver;
    public int pierceLeft;
    BlockPos lastPosHit;
    Entity lastEntityHit;
    public static final EntityDataAccessor<Integer> RED = SynchedEntityData.m_135353_(EntitySpellArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GREEN = SynchedEntityData.m_135353_(EntitySpellArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> BLUE = SynchedEntityData.m_135353_(EntitySpellArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EntitySpellArrow(EntityType<? extends Arrow> type, Level worldIn) {
        super(type, worldIn);
        this.setDefaultColors();
    }

    public EntitySpellArrow(Level worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.setDefaultColors();
    }

    public EntitySpellArrow(Level worldIn, LivingEntity shooter) {
        super(worldIn, shooter);
        this.setDefaultColors();
    }

    public void setDefaultColors() {
        this.setColors(ParticleColor.defaultParticleColor());
    }

    public void setColors(ParticleColor color) {
        ParticleColor.IntWrapper wrapper = color.toWrapper();
        this.f_19804_.m_135381_(RED, (Object)wrapper.r);
        this.f_19804_.m_135381_(GREEN, (Object)wrapper.g);
        this.f_19804_.m_135381_(BLUE, (Object)wrapper.b);
    }

    public void m_8119_() {
        Vec3 vector3d3;
        boolean isNoClip = this.m_36797_();
        Vec3 vector3d = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            float f = Mth.m_14116_((float)((float)vector3d.m_165925_()));
            this.f_19857_ = (float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875);
            this.f_19858_ = (float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875);
            this.f_19859_ = this.f_19857_;
            this.f_19860_ = this.f_19858_;
        }
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.f_19853_.m_8055_(blockpos);
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        if (this.m_20070_()) {
            this.m_20095_();
        }
        this.f_36704_ = 0;
        Vec3 vector3d2 = this.m_20182_();
        BlockHitResult raytraceresult = this.f_19853_.m_45547_(new ClipContext(vector3d2, vector3d3 = vector3d2.m_82549_(vector3d), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            vector3d3 = raytraceresult.m_82450_();
        }
        while (!this.m_213877_()) {
            EntityHitResult entityraytraceresult = this.m_6351_(vector3d2, vector3d3);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)raytraceresult;
                Entity entity = entityHitResult.m_82443_();
                Entity entity1 = this.m_37282_();
                if (entity.f_19794_) {
                    raytraceresult = null;
                    entityraytraceresult = null;
                } else if (entity instanceof Player) {
                    Player player2;
                    Player player1 = (Player)entity;
                    if (entity1 instanceof Player && !(player2 = (Player)entity1).m_7099_(player1)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
            }
            if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !isNoClip && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                this.m_6532_((HitResult)raytraceresult);
                this.f_19812_ = true;
            }
            if (entityraytraceresult == null || this.m_36796_() <= 0) break;
            raytraceresult = null;
        }
        vector3d = this.m_20184_();
        double d3 = vector3d.f_82479_;
        double d4 = vector3d.f_82480_;
        double d0 = vector3d.f_82481_;
        if (this.m_36792_()) {
            for (int i = 0; i < 4; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + d3 * (double)i / 4.0, this.m_20186_() + d4 * (double)i / 4.0, this.m_20189_() + d0 * (double)i / 4.0, -d3, -d4 + 0.2, -d0);
            }
        }
        double d5 = this.m_20185_() + d3;
        double d1 = this.m_20186_() + d4;
        double d2 = this.m_20189_() + d0;
        float f1 = Mth.m_14116_((float)((float)vector3d.m_165925_()));
        this.f_19857_ = isNoClip ? (float)(Mth.m_14136_((double)(-d3), (double)(-d0)) * 57.2957763671875) : (float)(Mth.m_14136_((double)d3, (double)d0) * 57.2957763671875);
        this.f_19858_ = (float)(Mth.m_14136_((double)d4, (double)f1) * 57.2957763671875);
        this.f_19858_ = EntitySpellArrow.m_37273_((float)this.f_19860_, (float)this.f_19858_);
        this.f_19857_ = EntitySpellArrow.m_37273_((float)this.f_19859_, (float)this.f_19857_);
        float f2 = 0.99f;
        float f3 = 0.05f;
        if (this.m_20069_()) {
            for (int j = 0; j < 4; ++j) {
                float f4 = 0.25f;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
            }
            f2 = this.m_6882_();
        }
        this.m_20256_(vector3d.m_82490_((double)f2));
        if (!this.m_20068_() && !isNoClip) {
            Vec3 vector3d4 = this.m_20184_();
            this.m_20334_(vector3d4.f_82479_, vector3d4.f_82480_ - (double)0.05f, vector3d4.f_82481_);
        }
        this.m_6034_(d5, d1, d2);
        this.m_20101_();
        if (this.f_19853_.f_46443_ && this.f_19797_ > 1) {
            double deltaX = this.m_20185_() - this.f_19790_;
            double deltaY = this.m_20186_() - this.f_19791_;
            double deltaZ = this.m_20189_() - this.f_19792_;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 8.0);
            int counter = 0;
            for (double j = 0.0; j < dist; j += 1.0) {
                double coeff = j / dist;
                if ((counter += this.f_19853_.f_46441_.m_188503_(3)) % (((ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_()).m_35965_() == 0 ? 1 : 2 * ((ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_()).m_35965_()) != 0) continue;
                this.f_19853_.m_7106_(GlowParticleData.createData(new ParticleColor((Integer)this.f_19804_.m_135370_(RED), (Integer)this.f_19804_.m_135370_(GREEN), (Integer)this.f_19804_.m_135370_(BLUE))), (double)((float)(this.f_19854_ + deltaX * coeff)), (double)((float)(this.f_19855_ + deltaY * coeff)), (double)((float)(this.f_19856_ + deltaZ * coeff)), (double)(0.0125f * (this.f_19796_.m_188501_() - 0.5f)), (double)(0.0125f * (this.f_19796_.m_188501_() - 0.5f)), (double)(0.0125f * (this.f_19796_.m_188501_() - 0.5f)));
            }
        }
    }

    protected void attemptRemoval() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        --this.pierceLeft;
        if (this.pierceLeft < 0) {
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public byte m_36796_() {
        return 12;
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        DamageSource damagesource;
        Entity entity1;
        super.m_5790_(p_213868_1_);
        Entity entity = p_213868_1_.m_82443_();
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * this.m_36789_()), (double)0.0, (double)2.147483647E9));
        if (this.m_36792_()) {
            long j = this.f_19796_.m_188503_(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if ((entity1 = this.m_37282_()) == null) {
            damagesource = DamageSource.m_19346_((AbstractArrow)this, (Entity)this);
        } else {
            damagesource = DamageSource.m_19346_((AbstractArrow)this, (Entity)entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).m_21335_(entity);
            }
        }
        boolean flag = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (this.m_6060_() && !flag) {
            entity.m_20254_(5);
        }
        if (entity.m_6469_(damagesource, (float)i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vec3 vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.f_19853_.f_46443_ && this.m_36796_() <= 0) {
                    livingentity.m_21317_(livingentity.m_21234_() + 1);
                }
                if (this.f_36699_ > 0 && (vector3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.f_36699_ * 0.6)).m_82556_() > 0.0) {
                    livingentity.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
                }
                if (!this.f_19853_.f_46443_ && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                this.m_7761_(livingentity);
            }
        } else {
            entity.m_7311_(k);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RED, (Object)0);
        this.f_19804_.m_135372_(GREEN, (Object)0);
        this.f_19804_.m_135372_(BLUE, (Object)0);
    }

    protected void m_6532_(HitResult result) {
        HitResult.Type raytraceresult$type;
        if (this.spellResolver != null) {
            this.spellResolver.onResolveEffect(this.f_19853_, result);
        }
        if ((raytraceresult$type = result.m_6662_()) == HitResult.Type.ENTITY) {
            if (this.spellResolver != null) {
                this.spellResolver.onResolveEffect(this.f_19853_, result);
            }
            this.m_5790_((EntityHitResult)result);
            this.attemptRemoval();
            this.lastEntityHit = ((EntityHitResult)result).m_82443_();
        } else if (raytraceresult$type == HitResult.Type.BLOCK && !((BlockHitResult)result).m_82425_().equals((Object)this.lastPosHit)) {
            if (this.spellResolver != null) {
                this.spellResolver.onResolveEffect(this.f_19853_, result);
            }
            this.m_8060_((BlockHitResult)result);
            this.lastPosHit = ((BlockHitResult)result).m_82425_();
            this.attemptRemoval();
        }
    }

    protected void m_8060_(BlockHitResult p_230299_1_) {
        BlockState blockstate = this.f_19853_.m_8055_(p_230299_1_.m_82425_());
        blockstate.m_60669_(this.f_19853_, blockstate, p_230299_1_, (Projectile)this);
        this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.ENTITY_SPELL_ARROW.get();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntitySpellArrow(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)ModEntities.ENTITY_SPELL_ARROW.get(), world);
    }
}

