/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.ars_nouveau.geckolib3.util;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.io.InputStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import software.bernie.ars_nouveau.geckolib3.GeckoLib;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoBone;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoCube;

public final class RenderUtils {
    @Deprecated(forRemoval=true)
    public static void moveToPivot(GeoCube cube, PoseStack stack) {
        RenderUtils.translateToPivotPoint(stack, cube);
    }

    @Deprecated(forRemoval=true)
    public static void moveBackFromPivot(GeoCube cube, PoseStack stack) {
        RenderUtils.translateAwayFromPivotPoint(stack, cube);
    }

    @Deprecated(forRemoval=true)
    public static void moveToPivot(GeoBone bone, PoseStack stack) {
        RenderUtils.translateToPivotPoint(stack, bone);
    }

    @Deprecated(forRemoval=true)
    public static void moveBackFromPivot(GeoBone bone, PoseStack stack) {
        RenderUtils.translateAwayFromPivotPoint(stack, bone);
    }

    @Deprecated(forRemoval=true)
    public static void scale(GeoBone bone, PoseStack stack) {
        RenderUtils.scaleMatrixForBone(stack, bone);
    }

    @Deprecated(forRemoval=true)
    public static void translate(GeoBone bone, PoseStack stack) {
        RenderUtils.translateMatrixToBone(stack, bone);
    }

    @Deprecated(forRemoval=true)
    public static void rotate(GeoBone bone, PoseStack stack) {
        RenderUtils.rotateMatrixAroundBone(stack, bone);
    }

    @Deprecated(forRemoval=true)
    public static void rotate(GeoCube bone, PoseStack stack) {
        RenderUtils.rotateMatrixAroundCube(stack, bone);
    }

    public static void translateMatrixToBone(PoseStack poseStack, GeoBone bone) {
        poseStack.m_85837_((double)(-bone.getPositionX() / 16.0f), (double)(bone.getPositionY() / 16.0f), (double)(bone.getPositionZ() / 16.0f));
    }

    public static void rotateMatrixAroundBone(PoseStack poseStack, GeoBone bone) {
        if (bone.getRotationZ() != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122270_(bone.getRotationZ()));
        }
        if (bone.getRotationY() != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122270_(bone.getRotationY()));
        }
        if (bone.getRotationX() != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122270_(bone.getRotationX()));
        }
    }

    public static void rotateMatrixAroundCube(PoseStack poseStack, GeoCube cube) {
        Vector3f rotation = cube.rotation;
        poseStack.m_85845_(new Quaternion(0.0f, 0.0f, rotation.m_122269_(), false));
        poseStack.m_85845_(new Quaternion(0.0f, rotation.m_122260_(), 0.0f, false));
        poseStack.m_85845_(new Quaternion(rotation.m_122239_(), 0.0f, 0.0f, false));
    }

    public static void scaleMatrixForBone(PoseStack poseStack, GeoBone bone) {
        poseStack.m_85841_(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(PoseStack poseStack, GeoCube cube) {
        Vector3f pivot = cube.pivot;
        poseStack.m_85837_((double)(pivot.m_122239_() / 16.0f), (double)(pivot.m_122260_() / 16.0f), (double)(pivot.m_122269_() / 16.0f));
    }

    public static void translateToPivotPoint(PoseStack poseStack, GeoBone bone) {
        poseStack.m_85837_((double)(bone.rotationPointX / 16.0f), (double)(bone.rotationPointY / 16.0f), (double)(bone.rotationPointZ / 16.0f));
    }

    public static void translateAwayFromPivotPoint(PoseStack poseStack, GeoCube cube) {
        Vector3f pivot = cube.pivot;
        poseStack.m_85837_((double)(-pivot.m_122239_() / 16.0f), (double)(-pivot.m_122260_() / 16.0f), (double)(-pivot.m_122269_() / 16.0f));
    }

    public static void translateAwayFromPivotPoint(PoseStack poseStack, GeoBone bone) {
        poseStack.m_85837_((double)(-bone.rotationPointX / 16.0f), (double)(-bone.rotationPointY / 16.0f), (double)(-bone.rotationPointZ / 16.0f));
    }

    public static void translateAndRotateMatrixForBone(PoseStack poseStack, GeoBone bone) {
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
    }

    public static void prepMatrixForBone(PoseStack poseStack, GeoBone bone) {
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
    }

    @Nullable
    public static IntIntPair getTextureDimensions(ResourceLocation texture) {
        if (texture == null) {
            return null;
        }
        AbstractTexture originalTexture = null;
        Minecraft mc = Minecraft.m_91087_();
        try {
            originalTexture = (AbstractTexture)mc.m_18691_(() -> mc.m_91097_().m_118506_(texture)).get();
        }
        catch (Exception e) {
            GeckoLib.LOGGER.warn("Failed to load image for id {}", (Object)texture);
            e.printStackTrace();
        }
        if (originalTexture == null) {
            return null;
        }
        NativeImage image = null;
        try {
            NativeImage nativeImage;
            if (originalTexture instanceof DynamicTexture) {
                DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
                nativeImage = dynamicTexture.m_117991_();
            } else {
                nativeImage = NativeImage.m_85058_((InputStream)((Resource)mc.m_91098_().m_213713_(texture).get()).m_215507_());
            }
            image = nativeImage;
        }
        catch (Exception e) {
            GeckoLib.LOGGER.error("Failed to read image for id {}", (Object)texture);
            e.printStackTrace();
        }
        return image == null ? null : IntIntImmutablePair.of((int)image.m_84982_(), (int)image.m_85084_());
    }

    public static Matrix4f invertAndMultiplyMatrices(Matrix4f baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = inputMatrix.m_27658_();
        inputMatrix.m_27657_();
        inputMatrix.m_27644_(baseMatrix);
        return inputMatrix;
    }
}

