/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common;

import alexthw.starbunclemania.registry.ModRegistry;
import com.hollingsworth.arsnouveau.common.entity.ChangeableBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class StarbyMountEntity
extends Starbuncle
implements PlayerRideableJumping {
    private float playerJumpPendingScale;
    private boolean isJumping;

    public StarbyMountEntity(Level world) {
        super((EntityType)ModRegistry.STARBY_MOUNT.get(), world);
        this.setTamed(true);
    }

    public StarbyMountEntity(Level world, Starbuncle.StarbuncleData data) {
        this(world);
        this.data = data;
        this.restoreFromTag();
    }

    public StarbyMountEntity(EntityType<StarbyMountEntity> entityType, Level world) {
        super(entityType, world);
        this.setTamed(true);
    }

    public void setCosmeticItem(ItemStack stack) {
        this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack));
    }

    public void setBehavior(ChangeableBehavior behavior) {
    }

    public void getTooltip(List<Component> tooltip) {
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), ((Item)ModRegistry.STARSADDLE.get()).m_7968_()));
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModRegistry.STARBY_MOUNT.get();
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean pJumping) {
        this.isJumping = pJumping;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6084_()) {
            LivingEntity livingEntity;
            if (this.m_20160_() && (livingEntity = this.getControllingPassenger()) instanceof Player) {
                Player livingentity = (Player)livingEntity;
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float strafe = livingentity.f_20900_ * 0.5f;
                float forward = livingentity.f_20902_ * 2.0f;
                if (forward <= 0.0f) {
                    forward *= 0.25f;
                }
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && this.f_19861_) {
                    double d0 = (double)(this.m_6118_() * 2.0f) * (double)this.playerJumpPendingScale * (double)this.m_20098_();
                    double d1 = d0 + this.m_182332_();
                    Vec3 vec3 = this.m_20184_();
                    this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
                    this.setIsJumping(true);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (forward > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * this.playerJumpPendingScale), 0.0, (double)(0.4f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                this.f_20887_ = this.m_6113_() * 0.1f;
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    super.m_7023_(new Vec3((double)strafe, pTravelVector.f_82480_, (double)forward));
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.f_19861_) {
                    this.playerJumpPendingScale = 0.0f;
                    this.setIsJumping(false);
                }
            } else {
                this.f_20887_ = 0.02f;
                super.m_7023_(pTravelVector);
            }
        }
    }

    public void onWanded(Player playerEntity) {
        Starbuncle carbuncle = new Starbuncle(playerEntity.f_19853_, true);
        Starbuncle.StarbuncleData data = this.data;
        carbuncle.m_6034_(this.m_20185_() + 0.5, this.m_20186_() + 1.0, this.m_20189_() + 0.5);
        carbuncle.data = data;
        carbuncle.restoreFromTag();
        playerEntity.f_19853_.m_7967_((Entity)carbuncle);
        playerEntity.f_19853_.m_7967_((Entity)new ItemEntity(playerEntity.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), ((Item)ModRegistry.STARSADDLE.get()).m_7968_()));
        carbuncle.onWanded(playerEntity);
        carbuncle.setBehavior((ChangeableBehavior)new StarbyTransportBehavior(carbuncle, new CompoundTag()));
        this.m_146870_();
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
    }

    public void m_7332_(Entity passenger) {
        super.m_7332_(passenger);
        if (passenger instanceof Mob) {
            Mob mob = (Mob)passenger;
            if (this.getControllingPassenger() == passenger && mob.f_20902_ > 0.0f) {
                this.f_20883_ = mob.f_20883_;
            }
        }
        if (this.m_20363_(passenger) && passenger instanceof Player) {
            double d0 = this.m_20186_() + this.m_6048_() + passenger.m_6049_();
            float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            passenger.m_6034_(this.m_20185_() + (double)f1 * 0.8, d0, this.m_20189_() - (double)f * 0.8);
        }
    }

    public boolean m_6146_() {
        return true;
    }

    public LivingEntity getControllingPassenger() {
        LivingEntity livingEntity;
        Entity entity = this.m_146895_();
        return entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
    }

    protected boolean m_7341_(Entity pEntity) {
        return pEntity instanceof Player;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.f_19853_.m_5776_()) {
            return InteractionResult.PASS;
        }
        if (player.m_21205_().m_41619_() && !player.m_6144_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_7888_(int pJumpPower) {
        if (pJumpPower < 0) {
            pJumpPower = 0;
        }
        this.playerJumpPendingScale = pJumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)pJumpPower / 90.0f;
    }

    public boolean m_7132_() {
        return true;
    }

    public void m_7199_(int pJumpPower) {
    }

    public void m_8012_() {
    }
}

