/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.registry;

import alexthw.starbunclemania.StarbuncleMania;
import alexthw.starbunclemania.client.FluidSourceLinkRenderer;
import alexthw.starbunclemania.client.SourceCondenserRenderer;
import alexthw.starbunclemania.common.StarbyMountEntity;
import alexthw.starbunclemania.common.block.FluidSourcelinkBlock;
import alexthw.starbunclemania.common.block.FluidSourcelinkTile;
import alexthw.starbunclemania.common.block.LiquidJarBlock;
import alexthw.starbunclemania.common.block.LiquidJarTile;
import alexthw.starbunclemania.common.block.SourceCondenserBlock;
import alexthw.starbunclemania.common.block.SourceCondenserTile;
import alexthw.starbunclemania.common.item.DirectionScroll;
import alexthw.starbunclemania.common.item.FluidJarItem;
import alexthw.starbunclemania.common.item.FluidScroll;
import alexthw.starbunclemania.common.item.cosmetic.ExampleCosmetic;
import alexthw.starbunclemania.common.item.cosmetic.ProfHat;
import alexthw.starbunclemania.common.item.cosmetic.StarBalloon;
import alexthw.starbunclemania.common.item.cosmetic.StarBin;
import alexthw.starbunclemania.common.item.cosmetic.StarBucket;
import alexthw.starbunclemania.common.item.cosmetic.StarSword;
import alexthw.starbunclemania.common.item.cosmetic.StarWand;
import alexthw.starbunclemania.common.item.cosmetic.StarbAABattery;
import alexthw.starbunclemania.common.item.cosmetic.StarbySaddle;
import alexthw.starbunclemania.recipe.FluidSourcelinkRecipe;
import alexthw.starbunclemania.registry.MekanismCompat;
import alexthw.starbunclemania.registry.SourceFluid;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.items.RendererBlockItem;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModRegistry {
    private static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"starbunclemania");
    private static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"starbunclemania");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"starbunclemania");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"starbunclemania");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"starbunclemania");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"starbunclemania");
    public static final DeferredRegister<RecipeType<?>> RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"starbunclemania");
    public static final DeferredRegister<RecipeSerializer<?>> R_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"starbunclemania");
    public static final TagKey<Fluid> POTION = FluidTags.create((ResourceLocation)new ResourceLocation("forge", "potion"));
    public static final RegistryObject<RecipeType<FluidSourcelinkRecipe>> FLUID_SOURCELINK_RT = RECIPES.register("fluid_sourcelink", () -> RecipeType.simple((ResourceLocation)StarbuncleMania.prefix("fluid_sourcelink")));
    public static final RegistryObject<RecipeSerializer<FluidSourcelinkRecipe>> FLUID_SOURCELINK_RS = R_SERIALIZERS.register("fluid_sourcelink", FluidSourcelinkRecipe.Serializer::new);
    public static final RegistryObject<Item> DIRECTION_SCROLL;
    public static final RegistryObject<Item> FLUID_SCROLL_A;
    public static final RegistryObject<Item> FLUID_SCROLL_D;
    public static final RegistryObject<Item> STARHAT;
    public static final RegistryObject<Item> PROFHAT;
    public static final RegistryObject<Item> STARBATTERY;
    public static final RegistryObject<Item> STARBUCKET;
    public static final RegistryObject<Item> STARBALLON;
    public static final RegistryObject<Item> STARTRASH;
    public static final RegistryObject<Item> STARSWORD;
    public static final RegistryObject<Item> STARWAND;
    public static final RegistryObject<Item> STARSADDLE;
    public static final RegistryObject<Block> FLUID_JAR;
    public static final RegistryObject<BlockEntityType<LiquidJarTile>> FLUID_JAR_TILE;
    public static final RegistryObject<Block> SOURCE_CONDENSER;
    public static final RegistryObject<BlockEntityType<SourceCondenserTile>> SOURCE_CONDENSER_TILE;
    public static final RegistryObject<Block> FLUID_SOURCELINK;
    public static final RegistryObject<BlockEntityType<FluidSourcelinkTile>> FLUID_SOURCELINK_TILE;
    public static final RegistryObject<EntityType<StarbyMountEntity>> STARBY_MOUNT;
    public static final RegistryObject<FluidType> SOURCE_FLUID_TYPE;
    public static final RegistryObject<FlowingFluid> SOURCE_FLUID;
    public static final RegistryObject<Fluid> SOURCE_FLUID_FLOWING;
    public static final RegistryObject<LiquidBlock> SOURCE_FLUID_BLOCK;
    public static final RegistryObject<Item> SOURCE_FLUID_BUCKET;

    public static void registerRegistries(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        FLUID_TYPES.register(bus);
        FLUIDS.register(bus);
        BLOCK_ENTITIES.register(bus);
        ENTITIES.register(bus);
        RECIPES.register(bus);
        R_SERIALIZERS.register(bus);
        bus.addListener(ModRegistry::registerEntityAttributes);
        bus.addListener(ModRegistry::editEntityAttributes);
        if (ModList.get().isLoaded("mekanism")) {
            MekanismCompat.register(bus);
        }
    }

    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)STARBY_MOUNT.get(), Starbuncle.attributes().m_22268_(Attributes.f_22276_, 20.0).m_22265_());
    }

    public static void editEntityAttributes(EntityAttributeModificationEvent event) {
        event.add((EntityType)ModEntities.STARBUNCLE_TYPE.get(), Attributes.f_22281_, 2.0);
        event.add((EntityType)ModEntities.STARBUNCLE_TYPE.get(), Attributes.f_22277_, 5.0);
    }

    static Item.Properties basicItemProperties() {
        return new Item.Properties().m_41491_(StarbuncleMania.TAB);
    }

    private static ForgeFlowingFluid.Properties fluidProperties() {
        return new ForgeFlowingFluid.Properties(SOURCE_FLUID_TYPE, SOURCE_FLUID, SOURCE_FLUID_FLOWING).block(SOURCE_FLUID_BLOCK).bucket(SOURCE_FLUID_BUCKET);
    }

    static <T extends Entity> RegistryObject<EntityType<T>> addEntity(String name, float width, float height, boolean fire, boolean noSave, EntityType.EntityFactory<T> factory, MobCategory kind) {
        return ENTITIES.register(name, () -> {
            EntityType.Builder builder = EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)kind).setTrackingRange(32).m_20699_(width, height);
            if (noSave) {
                builder.m_20716_();
            }
            if (fire) {
                builder.m_20719_();
            }
            return builder.m_20712_("starbunclemania:" + name);
        });
    }

    static {
        STARHAT = ITEMS.register("star_hat", () -> new ExampleCosmetic(ModRegistry.basicItemProperties()));
        PROFHAT = ITEMS.register("wyrm_degree", () -> new ProfHat(ModRegistry.basicItemProperties()));
        STARBATTERY = ITEMS.register("star_battery", () -> new StarbAABattery(ModRegistry.basicItemProperties()));
        STARBUCKET = ITEMS.register("star_bucket", () -> new StarBucket(ModRegistry.basicItemProperties()));
        STARBALLON = ITEMS.register("star_balloon", () -> new StarBalloon(ModRegistry.basicItemProperties()));
        STARTRASH = ITEMS.register("star_bin", () -> new StarBin(ModRegistry.basicItemProperties()));
        STARSWORD = ITEMS.register("star_sword", () -> new StarSword(ModRegistry.basicItemProperties()));
        STARWAND = ITEMS.register("star_wand", () -> new StarWand(new Item.Properties()));
        DIRECTION_SCROLL = ITEMS.register("direction_scroll", () -> new DirectionScroll(ModRegistry.basicItemProperties()));
        FLUID_SCROLL_A = ITEMS.register("fluid_scroll_allow", () -> new FluidScroll(ModRegistry.basicItemProperties()));
        FLUID_SCROLL_D = ITEMS.register("fluid_scroll_deny", () -> new FluidScroll(ModRegistry.basicItemProperties()){

            @Override
            public boolean isDenied(ItemStack fluidScroll, FluidStack fluidInTank) {
                FluidScroll.FluidData filter = new FluidScroll.FluidData(fluidScroll);
                return filter.containsStack(fluidInTank);
            }
        });
        STARSADDLE = ITEMS.register("star_saddle", () -> new StarbySaddle(ModRegistry.basicItemProperties()));
        FLUID_JAR = BLOCKS.register("fluid_jar", () -> new LiquidJarBlock());
        ITEMS.register("fluid_jar", () -> new FluidJarItem((Block)FLUID_JAR.get(), ModRegistry.basicItemProperties().m_41487_(1)));
        FLUID_JAR_TILE = BLOCK_ENTITIES.register("fluid_jar_tile", () -> BlockEntityType.Builder.m_155273_(LiquidJarTile::new, (Block[])new Block[]{(Block)FLUID_JAR.get()}).m_58966_(null));
        SOURCE_CONDENSER = BLOCKS.register("source_condenser", () -> new SourceCondenserBlock());
        SOURCE_CONDENSER_TILE = BLOCK_ENTITIES.register("source_condenser_tile", () -> BlockEntityType.Builder.m_155273_(SourceCondenserTile::new, (Block[])new Block[]{(Block)SOURCE_CONDENSER.get()}).m_58966_(null));
        ITEMS.register("source_condenser", () -> new RendererBlockItem((Block)SOURCE_CONDENSER.get(), ModRegistry.basicItemProperties()){

            public Supplier<BlockEntityWithoutLevelRenderer> getRenderer() {
                return SourceCondenserRenderer::getISTER;
            }
        });
        FLUID_SOURCELINK = BLOCKS.register("fluid_sourcelink", () -> new FluidSourcelinkBlock());
        FLUID_SOURCELINK_TILE = BLOCK_ENTITIES.register("fluid_sourcelink_tile", () -> BlockEntityType.Builder.m_155273_(FluidSourcelinkTile::new, (Block[])new Block[]{(Block)FLUID_SOURCELINK.get()}).m_58966_(null));
        ITEMS.register("fluid_sourcelink", () -> new RendererBlockItem((Block)FLUID_SOURCELINK.get(), ModRegistry.basicItemProperties()){

            public Supplier<BlockEntityWithoutLevelRenderer> getRenderer() {
                return FluidSourceLinkRenderer::getISTER;
            }
        });
        STARBY_MOUNT = ModRegistry.addEntity("starby_mount", 2.0f, 2.0f, true, false, (entityCarbuncleEntityType, world) -> new StarbyMountEntity((EntityType<StarbyMountEntity>)entityCarbuncleEntityType, world), MobCategory.CREATURE);
        SOURCE_FLUID_TYPE = FLUID_TYPES.register("source_fluid", SourceFluid::new);
        SOURCE_FLUID = FLUIDS.register("source_fluid", () -> new ForgeFlowingFluid.Source(ModRegistry.fluidProperties()));
        SOURCE_FLUID_FLOWING = FLUIDS.register("source_fluid_flowing", () -> new ForgeFlowingFluid.Flowing(ModRegistry.fluidProperties()));
        SOURCE_FLUID_BLOCK = BLOCKS.register("source_fluid_block", () -> new LiquidBlock(SOURCE_FLUID, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_222994_()));
        SOURCE_FLUID_BUCKET = ITEMS.register("source_fluid_bucket", () -> new BucketItem(SOURCE_FLUID, ModRegistry.basicItemProperties().m_41495_(Items.f_42446_).m_41487_(1)));
    }
}

