/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal;

import com.google.common.collect.Sets;
import fuzs.puzzleslib.config.ConfigHolder;
import fuzs.puzzleslib.core.CoreServices;
import fuzs.puzzleslib.core.ModConstructor;
import fuzs.universalbonemeal.config.ServerConfig;
import fuzs.universalbonemeal.handler.BonemealHandler;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusFlowerBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusPlantBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.CoralBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.DirtBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.FruitStemBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.MyceliumBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.NetherWartBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.PodzolBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.SimpleGrowingPlantBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.SimpleSpreadBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.VineBehavior;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalBoneMeal
implements ModConstructor {
    public static final String MOD_ID = "universalbonemeal";
    public static final String MOD_NAME = "Universal Bone Meal";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Universal Bone Meal");
    public static final ConfigHolder CONFIG = CoreServices.FACTORIES.serverConfig(ServerConfig.class, () -> new ServerConfig());

    public void onConstructMod() {
        CONFIG.bakeConfigs(MOD_ID);
    }

    public void onCommonSetup() {
        UniversalBoneMeal.registerBonemealBehaviors();
    }

    private static void registerBonemealBehaviors() {
        BonemealHandler.registerBehavior(Blocks.f_50128_, SimpleGrowingPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowCactus);
        BonemealHandler.registerBehavior(Blocks.f_50130_, SimpleGrowingPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowSugarCane);
        BonemealHandler.registerBehavior(Blocks.f_50191_, VineBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowVines);
        BonemealHandler.registerBehavior(Blocks.f_50200_, NetherWartBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowNetherWart);
        BonemealHandler.registerBehavior(Sets.newHashSet((Object[])new Block[]{Blocks.f_50190_, Blocks.f_50189_}), FruitStemBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowFruitStems);
        BonemealHandler.registerBehavior(Blocks.f_50196_, () -> new SimpleSpreadBehavior(4, 3), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowLilyPad);
        BonemealHandler.registerBehavior(Blocks.f_50036_, () -> new SimpleSpreadBehavior(4, 2), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowDeadBush);
        BonemealHandler.registerBehavior((TagKey<Block>)BlockTags.f_13037_, () -> new SimpleSpreadBehavior(3, 1), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowSmallFlowers);
        BonemealHandler.registerBehavior((TagKey<Block>)BlockTags.f_13063_, CoralBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowCorals);
        BonemealHandler.registerBehavior(Blocks.f_50491_, ChorusFlowerBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowChorus);
        BonemealHandler.registerBehavior(Blocks.f_50490_, ChorusPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowChorus);
        BonemealHandler.registerBehavior(Blocks.f_50195_, MyceliumBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowMycelium);
        BonemealHandler.registerBehavior(Sets.newHashSet((Object[])new Block[]{Blocks.f_50493_, Blocks.f_50546_, Blocks.f_152481_}), DirtBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowDirt);
        BonemealHandler.registerBehavior(Blocks.f_50599_, PodzolBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowPodzol);
    }
}

