/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.traverse.bhc.common.BaubleyHeartCanisters;
import com.traverse.bhc.common.container.BladeOfVitalityContainer;
import com.traverse.bhc.common.init.RegistryHandler;
import com.traverse.bhc.common.util.HeartType;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ItemBladeOfVitality
extends SwordItem
implements MenuProvider {
    public static final UUID DAMAGE_MODIFIER_ID = UUID.fromString("432ba3b0-c3bd-4f1c-b14c-76a0b32a386c");

    public ItemBladeOfVitality() {
        super((Tier)Tiers.NETHERITE, 3, -2.4f, new Item.Properties().m_41491_(BaubleyHeartCanisters.TAB));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
        }
        if (!level.m_5776_() && player.m_6144_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, friendlyByteBuf -> friendlyByteBuf.m_130055_(player.m_21120_(hand)));
        }
        return super.m_7203_(level, player, hand);
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        int[] heartCount;
        int heartTotal;
        ImmutableMultimap.Builder RESULT = ImmutableMultimap.builder();
        RESULT.putAll(super.getAttributeModifiers(slot, stack));
        if (slot == EquipmentSlot.MAINHAND && (heartTotal = IntStream.of(heartCount = this.getHeartCount(stack)).sum()) > 0) {
            RESULT.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(DAMAGE_MODIFIER_ID, "Weapon modifier", (double)heartTotal, AttributeModifier.Operation.ADDITION));
        }
        return RESULT.build();
    }

    public int[] getHeartCount(ItemStack stack) {
        CompoundTag nbt;
        if (stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_("heart_amount")) {
            return nbt.m_128465_("heart_amount");
        }
        return new int[HeartType.values().length];
    }

    public float m_43299_() {
        return this.getMaxDamage(((Item)RegistryHandler.BLADE_OF_VITALITIY.get()).m_7968_()) + "heart_amount".length();
    }

    public boolean m_41465_() {
        return false;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.bhc.blade_of_vitality");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new BladeOfVitalityContainer(id, inventory, player.m_21205_());
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)Util.m_137492_((String)"tooltip", (ResourceLocation)new ResourceLocation("bhc", "vitalityblade"))).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GOLD)));
    }
}

