/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.jei;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;

public class SetMemorySlotMessage {
    private final ItemStack stack;
    private final int slotNumber;

    public SetMemorySlotMessage(ItemStack stack, int slotNumber) {
        this.stack = stack;
        this.slotNumber = slotNumber;
    }

    public static void encode(SetMemorySlotMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130055_(msg.stack);
        packetBuffer.writeShort(msg.slotNumber);
    }

    public static SetMemorySlotMessage decode(FriendlyByteBuf packetBuffer) {
        return new SetMemorySlotMessage(packetBuffer.m_130267_(), packetBuffer.readShort());
    }

    static void onMessage(SetMemorySlotMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SetMemorySlotMessage.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(SetMemorySlotMessage msg, @Nullable ServerPlayer sender) {
        AbstractContainerMenu abstractContainerMenu;
        if (sender == null || !((abstractContainerMenu = sender.f_36096_) instanceof SettingsContainerMenu)) {
            return;
        }
        SettingsContainerMenu settingsContainerMenu = (SettingsContainerMenu)abstractContainerMenu;
        Object storageWrapper = settingsContainerMenu.getStorageWrapper();
        storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).setFilter(msg.slotNumber, msg.stack);
        storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class).itemChanged(msg.slotNumber);
        storageWrapper.getInventoryHandler().onSlotFilterChanged(msg.slotNumber);
        settingsContainerMenu.sendAdditionalSlotInfo();
    }
}

