/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.mods.ftbteamdimensions.client.gui.StartSelectScreen;
import dev.ftb.mods.ftbteamdimensions.client.gui.VisitScreen;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.ArchivedDimension;
import dev.ftb.mods.ftbteamdimensions.mixin.client.CreateWorldScreenAccess;
import dev.ftb.mods.ftbteamdimensions.mixin.client.WorldGenSettingsComponentAccess;
import dev.ftb.mods.ftbteamdimensions.net.CreateDimensionForTeam;
import dev.ftb.mods.ftbteamdimensions.net.OpenVisitGui;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldGenSettingsComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DimensionsClient {
    public static boolean debugMode = false;
    public static final List<ArchivedDimension> knownDimensions = new ArrayList<ArchivedDimension>();

    @SubscribeEvent
    public static void registerClientCommand(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbstoneblock-client").then(Commands.m_82127_((String)"debug").executes(context -> DimensionsClient.toggleDebug())));
    }

    public static void init() {
        DimensionSpecialEffects.f_108857_.put((Object)new ResourceLocation("ftbteamdimensions", "stoneblock"), (Object)new StoneblockDimensionSpecialEffects());
        MinecraftForge.EVENT_BUS.addListener(DimensionsClient::onScreenInitPost);
    }

    private static void onScreenInitPost(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreateWorldScreen) {
            CreateWorldScreen cws = (CreateWorldScreen)screen;
            WorldGenSettingsComponent comp = ((CreateWorldScreenAccess)cws).getWorldGenSettingsComponent();
            CycleButton<Holder<WorldPreset>> cb = ((WorldGenSettingsComponentAccess)comp).getTypeButton();
            cb.f_93623_ = false;
            cb.m_93666_((Component)Component.m_237115_((String)"screens.ftbteamdimensions.world_type_locked"));
        }
    }

    public static void exportBiomes(ServerLevel level, Path path, int radius) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        try (NativeImage image = new NativeImage(radius * 2 + 1, radius * 2 + 1, true);){
            for (int x = 0; x <= radius * 2; ++x) {
                for (int z = 0; z <= radius * 2; ++z) {
                    pos.m_122178_(x - radius + Mth.m_14107_((double)player.m_20185_()), 0, z - radius + Mth.m_14107_((double)player.m_20189_()));
                    image.m_84988_(x, z, 0);
                }
            }
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
            image.m_85066_(path);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void openSelectionScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new StartSelectScreen(prebuiltStructure -> new CreateDimensionForTeam(prebuiltStructure.id()).sendToServer()));
    }

    public static void openVisitScreen(Map<ResourceLocation, OpenVisitGui.DimData> dim2name) {
        Minecraft.m_91087_().m_91152_((Screen)new VisitScreen(dim2name));
    }

    public static int toggleDebug() {
        debugMode = !debugMode;
        return 0;
    }

    public static Set<ResourceKey<Level>> playerLevels(Player player) {
        return ((LocalPlayer)player).f_108617_.m_105151_();
    }

    @Nonnull
    public static Level clientLevel() {
        return (Level)Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
    }

    private static class StoneblockDimensionSpecialEffects
    extends DimensionSpecialEffects {
        public StoneblockDimensionSpecialEffects() {
            super(Float.NaN, false, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        }

        public Vec3 m_5927_(Vec3 arg, float f) {
            return arg.m_82490_(0.15);
        }

        public boolean m_5781_(int i, int j) {
            return false;
        }

        public float[] m_7518_(float f, float g) {
            return null;
        }
    }
}

