/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakedmodels;

import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.Copyable;
import codechicken.lib.util.TransformUtils;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;

public class ModelProperties
implements Copyable<ModelProperties> {
    public static final ModelProperties DEFAULT_ITEM = ModelProperties.builder().withAO(true).build();
    public static final ModelProperties DEFAULT_BLOCK = ModelProperties.builder().withAO(true).withGui3D(true).withUsesBlockLight(true).build();
    private final boolean isAO;
    private final boolean isGui3D;
    private final boolean isBuiltInRenderer;
    private final boolean usesBlockLight;
    @Nullable
    private TextureAtlasSprite particle;

    private ModelProperties(boolean isAO, boolean isGui3D, boolean usesBlockLight, boolean isBuiltInRenderer, TextureAtlasSprite particle) {
        this.isAO = isAO;
        this.isGui3D = isGui3D;
        this.isBuiltInRenderer = isBuiltInRenderer;
        this.usesBlockLight = usesBlockLight;
        this.particle = particle;
    }

    private ModelProperties(ModelProperties other) {
        this.isAO = other.isAO;
        this.isGui3D = other.isGui3D;
        this.isBuiltInRenderer = other.isBuiltInRenderer;
        this.usesBlockLight = other.usesBlockLight;
        this.particle = other.particle;
    }

    public static ModelProperties fromModel(BakedModel model) {
        return new ModelProperties(model.m_7541_(), model.m_7539_(), model.m_7547_(), model.m_7521_(), model.m_6160_());
    }

    public boolean isAmbientOcclusion() {
        return this.isAO;
    }

    public boolean isGui3d() {
        return this.isGui3D;
    }

    public boolean isBuiltInRenderer() {
        return this.isBuiltInRenderer;
    }

    public boolean usesBlockLight() {
        return this.usesBlockLight;
    }

    public TextureAtlasSprite getParticleTexture() {
        if (this.particle == null) {
            this.particle = TextureUtils.getMissingSprite();
        }
        return this.particle;
    }

    @Override
    public ModelProperties copy() {
        return new ModelProperties(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private boolean isAO;
        private boolean isGui3D;
        private boolean isBuiltInRenderer;
        private boolean usesBlockLight;
        private TextureAtlasSprite particle;

        protected Builder() {
        }

        protected Builder(ModelProperties properties) {
            this.isAO = properties.isAO;
            this.isGui3D = properties.isGui3D;
            this.usesBlockLight = properties.usesBlockLight;
            this.isBuiltInRenderer = properties.isBuiltInRenderer;
            this.particle = properties.particle;
        }

        protected Builder(boolean isAO, boolean isGui3D, boolean usesBlockLight, boolean isBuiltInRenderer, TextureAtlasSprite particle) {
            this.isAO = isAO;
            this.isGui3D = isGui3D;
            this.usesBlockLight = usesBlockLight;
            this.isBuiltInRenderer = isBuiltInRenderer;
            this.particle = particle;
        }

        public Builder copyFrom(BakedModel model) {
            this.isAO = model.m_7541_();
            this.isGui3D = model.m_7539_();
            this.usesBlockLight = model.m_7547_();
            this.isBuiltInRenderer = model.m_7521_();
            this.particle = model.m_6160_();
            return this;
        }

        public Builder copyFrom(ModelProperties properties) {
            this.isAO = properties.isAO;
            this.isGui3D = properties.isGui3D;
            this.isBuiltInRenderer = properties.isBuiltInRenderer;
            this.particle = properties.particle;
            return this;
        }

        public Builder withAO(boolean isAO) {
            this.isAO = isAO;
            return this;
        }

        public Builder withGui3D(boolean isGui3D) {
            this.isGui3D = isGui3D;
            return this;
        }

        public Builder withUsesBlockLight(boolean usesBlockLight) {
            this.usesBlockLight = usesBlockLight;
            return this;
        }

        public Builder withBuiltInRenderer(boolean builtInRenderer) {
            this.isBuiltInRenderer = builtInRenderer;
            return this;
        }

        public Builder withParticle(TextureAtlasSprite sprite) {
            this.particle = sprite;
            return this;
        }

        public PerspectiveProperties.PerspectiveBuilder withTransforms(PerspectiveModelState transforms) {
            PerspectiveProperties.PerspectiveBuilder builder = new PerspectiveProperties.PerspectiveBuilder(this);
            builder.withTransforms(transforms);
            return builder;
        }

        public ModelProperties build() {
            return new ModelProperties(this.isAO, this.isGui3D, this.usesBlockLight, this.isBuiltInRenderer, this.particle);
        }
    }

    public static class PerspectiveProperties
    extends ModelProperties {
        public static final PerspectiveProperties DEFAULT_ITEM = ModelProperties.builder().copyFrom(DEFAULT_ITEM).withTransforms(TransformUtils.DEFAULT_ITEM).build();
        public static final PerspectiveProperties DEFAULT_BLOCK = ModelProperties.builder().copyFrom(DEFAULT_BLOCK).withTransforms(TransformUtils.DEFAULT_BLOCK).build();
        private final PerspectiveModelState transforms;

        private PerspectiveProperties(PerspectiveProperties properties) {
            this(properties.getTransforms(), properties);
        }

        private PerspectiveProperties(PerspectiveModelState transforms, ModelProperties properties) {
            super(properties);
            this.transforms = transforms;
        }

        public PerspectiveModelState getTransforms() {
            return this.transforms;
        }

        @Override
        public PerspectiveProperties copy() {
            return new PerspectiveProperties(this);
        }

        @Override
        public PerspectiveBuilder toBuilder() {
            return new PerspectiveBuilder(this);
        }

        public static class PerspectiveBuilder
        extends Builder {
            private PerspectiveModelState transforms;

            protected PerspectiveBuilder(PerspectiveProperties properties) {
                super(properties);
                this.transforms = properties.transforms;
            }

            protected PerspectiveBuilder(Builder builder) {
                super(builder.isAO, builder.isAO, builder.usesBlockLight, builder.isBuiltInRenderer, builder.particle);
            }

            @Override
            public PerspectiveBuilder withTransforms(PerspectiveModelState transforms) {
                this.transforms = transforms;
                return this;
            }

            @Override
            public PerspectiveProperties build() {
                return new PerspectiveProperties(this.transforms, super.build());
            }
        }
    }
}

