/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.texture;

import codechicken.lib.texture.AtlasRegistrar;
import codechicken.lib.texture.IIconRegister;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class SpriteRegistryHelper {
    public static final ResourceLocation TEXTURES = InventoryMenu.f_39692_;
    private final Multimap<ResourceLocation, IIconRegister> iconRegisters = HashMultimap.create();
    private final Map<ResourceLocation, AtlasRegistrarImpl> atlasRegistrars = new HashMap<ResourceLocation, AtlasRegistrarImpl>();

    public SpriteRegistryHelper() {
        this(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public SpriteRegistryHelper(IEventBus eventBus) {
        eventBus.addListener(this::onTextureStitchPre);
        eventBus.addListener(this::onTextureStitchPost);
    }

    public void addIIconRegister(ResourceLocation basePath, IIconRegister iconRegister) {
        this.iconRegisters.put((Object)basePath, (Object)iconRegister);
    }

    public void addIIconRegister(IIconRegister iconRegister) {
        this.addIIconRegister(TEXTURES, iconRegister);
    }

    private AtlasRegistrarImpl getRegistrar(TextureAtlas atlas) {
        AtlasRegistrarImpl registrar = this.atlasRegistrars.get(atlas.m_118330_());
        if (registrar == null) {
            registrar = new AtlasRegistrarImpl();
            this.atlasRegistrars.put(atlas.m_118330_(), registrar);
        }
        return registrar;
    }

    private void onTextureStitchPre(TextureStitchEvent.Pre event) {
        TextureAtlas atlas = event.getAtlas();
        AtlasRegistrarImpl registrar = this.getRegistrar(atlas);
        this.iconRegisters.get((Object)atlas.m_118330_()).forEach(e -> e.registerIcons(registrar));
        registrar.processPre(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
    }

    private void onTextureStitchPost(TextureStitchEvent.Post event) {
        TextureAtlas atlas = event.getAtlas();
        AtlasRegistrarImpl registrar = this.getRegistrar(atlas);
        registrar.processPost(atlas);
    }

    private static final class AtlasRegistrarImpl
    implements AtlasRegistrar {
        private final Multimap<ResourceLocation, Consumer<TextureAtlasSprite>> sprites = HashMultimap.create();
        private final List<Consumer<TextureAtlas>> postCallbacks = new ArrayList<Consumer<TextureAtlas>>();

        private AtlasRegistrarImpl() {
        }

        @Override
        public void registerSprite(ResourceLocation loc, Consumer<TextureAtlasSprite> onReady) {
            this.sprites.put((Object)loc, onReady);
        }

        @Override
        public void postRegister(Consumer<TextureAtlas> func) {
            this.postCallbacks.add(func);
        }

        private void processPre(Consumer<ResourceLocation> register) {
            this.sprites.keySet().forEach(register);
        }

        private void processPost(TextureAtlas atlas) {
            for (Map.Entry entry : this.sprites.asMap().entrySet()) {
                TextureAtlasSprite sprite = atlas.m_118316_((ResourceLocation)entry.getKey());
                ((Collection)entry.getValue()).forEach(e -> e.accept(sprite));
            }
            for (Consumer consumer : this.postCallbacks) {
                consumer.accept(atlas);
            }
        }
    }
}

