/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.CoFHCore;
import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.api.IResourceStorage;
import cofh.lib.util.Constants;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class ElementResourceStorage
extends ElementBase {
    protected ResourceLocation creativeTexture;
    protected ResourceLocation underlayTexture;
    protected ResourceLocation overlayTexture;
    protected IResourceStorage storage;
    protected int minDisplay = 1;
    protected Supplier<Boolean> drawStorage = Constants.TRUE;
    protected Supplier<Boolean> drawUnderlay = Constants.TRUE;
    protected Supplier<Boolean> drawOverlay = Constants.TRUE;
    protected Supplier<Boolean> claimStorage = Constants.FALSE;
    protected Supplier<Boolean> clearStorage = Constants.FALSE;
    protected Supplier<Boolean> claimable = Constants.FALSE;
    protected Supplier<Boolean> clearable;

    public ElementResourceStorage(IGuiAccess gui, int posX, int posY, IResourceStorage storage) {
        super(gui, posX, posY);
        this.storage = storage;
        this.clearable = () -> storage.getStored() > 0;
    }

    public final ElementResourceStorage setCreativeTexture(String texture) {
        if (texture == null) {
            CoFHCore.LOG.warn("Attempted to assign a NULL creative texture.");
            return this;
        }
        this.creativeTexture = new ResourceLocation(texture);
        return this;
    }

    public final ElementResourceStorage setUnderlayTexture(String texture) {
        return this.setUnderlayTexture(texture, Constants.TRUE);
    }

    public final ElementResourceStorage setUnderlayTexture(String texture, Supplier<Boolean> draw) {
        if (texture == null || draw == null) {
            CoFHCore.LOG.warn("Attempted to assign a NULL underlay texture.");
            return this;
        }
        this.underlayTexture = new ResourceLocation(texture);
        this.drawUnderlay = draw;
        return this;
    }

    public final ElementResourceStorage setOverlayTexture(String texture) {
        return this.setOverlayTexture(texture, Constants.TRUE);
    }

    public final ElementResourceStorage setOverlayTexture(String texture, Supplier<Boolean> draw) {
        if (texture == null || draw == null) {
            CoFHCore.LOG.warn("Attempted to assign a NULL overlay texture.");
            return this;
        }
        this.overlayTexture = new ResourceLocation(texture);
        this.drawOverlay = draw;
        return this;
    }

    public final ElementResourceStorage setClaimStorage(Supplier<Boolean> claimStorage) {
        this.claimStorage = claimStorage;
        return this;
    }

    public final ElementResourceStorage setClearStorage(Supplier<Boolean> clearStorage) {
        this.clearStorage = clearStorage;
        return this;
    }

    public ElementResourceStorage setMinDisplay(int minDisplay) {
        this.minDisplay = minDisplay;
        return this;
    }

    @Override
    public void drawBackground(PoseStack poseStack, int mouseX, int mouseY) {
        this.drawStorage(poseStack);
        this.drawUnderlayTexture(poseStack);
        this.drawResource(poseStack);
        this.drawOverlayTexture(poseStack);
    }

    @Override
    public void addTooltip(List<Component> tooltipList, int mouseX, int mouseY) {
        if (this.storage.isCreative()) {
            tooltipList.add((Component)Component.m_237115_((String)"info.cofh.infinite").m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.ITALIC));
        } else {
            tooltipList.add((Component)Component.m_237113_((String)(StringHelper.format(this.storage.getStored()) + " / " + StringHelper.format(this.storage.getCapacity()) + " " + this.storage.getUnit())));
        }
        if (this.clearable.get().booleanValue() && this.clearStorage != Constants.FALSE && (Screen.m_96639_() || Screen.m_96638_())) {
            tooltipList.add((Component)Component.m_237115_((String)"info.cofh.click_to_clear").m_130940_(ChatFormatting.GRAY));
        } else if (this.claimable.get().booleanValue()) {
            tooltipList.add((Component)Component.m_237115_((String)"info.cofh.click_to_claim").m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.clearable.get().booleanValue() && Screen.m_96638_() && Screen.m_96639_()) {
            return this.clearStorage.get();
        }
        if (this.claimable.get().booleanValue()) {
            return this.claimStorage.get();
        }
        return false;
    }

    protected int getScaled(int scale) {
        if (this.storage.isCreative()) {
            return scale;
        }
        double fraction = (double)this.storage.getStored() * (double)scale / (double)this.storage.getCapacity();
        int amount = MathHelper.clamp(MathHelper.round(fraction), 0, scale);
        return fraction > 0.0 ? Math.max(this.minDisplay, amount) : amount;
    }

    protected void drawStorage(PoseStack poseStack) {
        if (this.drawStorage.get().booleanValue() && this.texture != null) {
            RenderHelper.setPosTexShader();
            RenderHelper.setShaderTexture0(this.texture);
            this.drawTexturedModalRect(poseStack, this.posX(), this.posY(), 0, 0, this.width, this.height);
        }
    }

    protected void drawUnderlayTexture(PoseStack poseStack) {
        if (this.drawUnderlay.get().booleanValue() && this.underlayTexture != null) {
            RenderHelper.setPosTexShader();
            RenderHelper.setShaderTexture0(this.underlayTexture);
            this.drawTexturedModalRect(poseStack, this.posX(), this.posY(), 0, 0, this.width, this.height);
        }
    }

    protected abstract void drawResource(PoseStack var1);

    protected void drawOverlayTexture(PoseStack poseStack) {
        if (this.drawOverlay.get().booleanValue() && this.overlayTexture != null) {
            RenderHelper.setPosTexShader();
            RenderHelper.setShaderTexture0(this.overlayTexture);
            this.drawTexturedModalRect(poseStack, this.posX(), this.posY(), 0, 0, this.width, this.height);
        }
    }
}

