/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.client;

import cofh.core.CoFHCore;
import cofh.lib.network.packet.IPacketClient;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectRemovedPacket
extends PacketBase
implements IPacketClient {
    protected LivingEntity entity;
    protected MobEffect effect;

    public EffectRemovedPacket() {
        super(97, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleClient() {
        MobEffectInstance existing;
        if (!this.entity.equals((Object)Minecraft.m_91087_().f_91074_) && (existing = this.entity.m_6234_(this.effect)) != null) {
            this.entity.m_7285_(existing);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entity.m_19879_());
        buf.m_130085_(Utils.getRegistryName(this.effect));
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        Entity e = Minecraft.m_91087_().f_91074_.f_19853_.m_6815_(buf.readInt());
        if (e instanceof LivingEntity) {
            this.entity = (LivingEntity)e;
            this.effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(buf.m_130281_());
        }
    }

    public static void sendToClient(LivingEntity entity, MobEffect effect) {
        if (!entity.f_19853_.f_46443_) {
            EffectRemovedPacket packet = new EffectRemovedPacket();
            packet.entity = entity;
            packet.effect = effect;
            packet.sendToAllAround(entity.m_20182_(), 192.0, (ResourceKey<Level>)entity.f_19853_.m_46472_());
        }
    }

    public static void sendToClient(LivingEntity entity, MobEffectInstance effect) {
        EffectRemovedPacket.sendToClient(entity, effect.m_19544_());
    }
}

