/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.item.IBlockRayTraceItem;
import cofh.core.util.ProxyUtils;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ItemRayTraceBlockPacket
extends PacketBase
implements IPacketServer {
    protected InteractionHand hand;
    protected Vec3 origin;
    protected BlockHitResult result;

    public ItemRayTraceBlockPacket() {
        super(66, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        ItemStack stack = player.m_21120_(this.hand);
        Item item = stack.m_41720_();
        if (item instanceof IBlockRayTraceItem) {
            IBlockRayTraceItem item2 = (IBlockRayTraceItem)item;
            item2.handleBlockRayTrace(player.f_19853_, (Player)player, this.hand, stack, this.origin, this.result);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.hand);
        buf.writeDouble(this.origin.f_82479_);
        buf.writeFloat((float)this.origin.f_82480_);
        buf.writeDouble(this.origin.f_82481_);
        buf.m_130062_(this.result);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        this.origin = new Vec3(buf.readDouble(), (double)buf.readFloat(), buf.readDouble());
        this.result = buf.m_130283_();
    }

    public static void sendToServer(Player player, InteractionHand hand, Vec3 origin, BlockHitResult result) {
        Player client;
        if (player.f_19853_.f_46443_ && (client = ProxyUtils.getClientPlayer()) != null && client.equals((Object)player)) {
            ItemRayTraceBlockPacket packet = new ItemRayTraceBlockPacket();
            packet.hand = hand;
            packet.origin = origin;
            packet.result = result;
            packet.sendToServer();
        }
    }
}

