/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common;

import brentmaas.buildguide.common.screen.BaseScreen;
import brentmaas.buildguide.common.screen.ConfigurationScreen;
import brentmaas.buildguide.common.screen.ShapeScreen;
import brentmaas.buildguide.common.screen.ShapelistScreen;
import brentmaas.buildguide.common.screen.VisualisationScreen;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeCircle;
import brentmaas.buildguide.common.shape.ShapeRegistry;
import brentmaas.buildguide.common.shape.ShapeSet;
import java.util.ArrayList;

public class State {
    private boolean initialised = false;
    public ArrayList<ShapeSet> shapeSets = new ArrayList();
    public int iShapeSet = 0;
    public int iShapeNew = ShapeRegistry.getShapeId(ShapeCircle.class);
    public boolean enabled = false;
    public boolean depthTest = true;
    public ActiveScreen currentScreen = ActiveScreen.BuildGuide;

    public BaseScreen createNewScreen(ActiveScreen newActiveScreen) {
        this.currentScreen = newActiveScreen;
        return this.createNewScreen();
    }

    public BaseScreen createNewScreen() {
        switch (this.currentScreen) {
            case Visualisation: {
                return new VisualisationScreen();
            }
            case Shapelist: {
                return new ShapelistScreen();
            }
            case Settings: {
                return new ConfigurationScreen();
            }
        }
        return new ShapeScreen();
    }

    public Shape getCurrentShape() {
        return this.shapeSets.size() > 0 ? this.shapeSets.get(this.iShapeSet).getShape() : null;
    }

    public ShapeSet getCurrentShapeSet() {
        return this.shapeSets.size() > 0 ? this.shapeSets.get(this.iShapeSet) : null;
    }

    public void initCheck() {
        if (!this.initialised) {
            this.shapeSets.add(new ShapeSet(this.iShapeNew));
            if (this.shapeSets.get((int)0).origin == null) {
                this.shapeSets.get(0).resetOrigin();
            }
            this.initialised = true;
        }
    }

    public void shiftShape(int di) {
        this.shapeSets.get(this.iShapeSet).setIndex(Math.floorMod(this.shapeSets.get(this.iShapeSet).getIndex() + di, ShapeRegistry.getNumberOfShapes()));
    }

    public boolean isShapeAvailable() {
        return this.shapeSets.size() > 0;
    }

    public void resetOrigin() {
        this.shapeSets.get(this.iShapeSet).resetOrigin();
    }

    public void setOrigin(int x, int y, int z) {
        this.shapeSets.get((int)this.iShapeSet).origin.x = x;
        this.shapeSets.get((int)this.iShapeSet).origin.y = y;
        this.shapeSets.get((int)this.iShapeSet).origin.z = z;
    }

    public void setOriginX(int x) {
        this.shapeSets.get((int)this.iShapeSet).origin.x = x;
    }

    public void setOriginY(int y) {
        this.shapeSets.get((int)this.iShapeSet).origin.y = y;
    }

    public void setOriginZ(int z) {
        this.shapeSets.get((int)this.iShapeSet).origin.z = z;
    }

    public void shiftOrigin(int dx, int dy, int dz) {
        this.shapeSets.get(this.iShapeSet).shiftOrigin(dx, dy, dz);
    }

    public void setShapeColour(float r, float g, float b, float a) {
        this.shapeSets.get((int)this.iShapeSet).colourShapeR = r;
        this.shapeSets.get((int)this.iShapeSet).colourShapeG = g;
        this.shapeSets.get((int)this.iShapeSet).colourShapeB = b;
        this.shapeSets.get((int)this.iShapeSet).colourShapeA = a;
        this.shapeSets.get(this.iShapeSet).updateAllShapes();
    }

    public void setOriginColour(float r, float g, float b, float a) {
        this.shapeSets.get((int)this.iShapeSet).colourOriginR = r;
        this.shapeSets.get((int)this.iShapeSet).colourOriginG = g;
        this.shapeSets.get((int)this.iShapeSet).colourOriginB = b;
        this.shapeSets.get((int)this.iShapeSet).colourOriginA = a;
        this.shapeSets.get(this.iShapeSet).updateAllShapes();
    }

    public static enum ActiveScreen {
        BuildGuide,
        Visualisation,
        Shapelist,
        Settings;

    }
}

