/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Augments;

import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibTooltipUtils;
import com.mowmaster.pedestals.Items.Augments.AugmentBase;
import com.mowmaster.pedestals.PedestalUtils.References;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class AugmentTransferToggle
extends AugmentBase {
    public AugmentTransferToggle(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public static int getAugmentMode(ItemStack stack) {
        if (AugmentTransferToggle.getTransferToggle(AugmentTransferToggle.getTransferType(stack), stack)) {
            return AugmentTransferToggle.getTransferType(stack) + 5;
        }
        return AugmentTransferToggle.getTransferType(stack);
    }

    public static int getTransferType(ItemStack stack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_type");
    }

    public static boolean getTransferToggle(int type, ItemStack stack) {
        switch (type) {
            case 0: {
                return MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_toggleitem");
            }
            case 1: {
                return MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_togglefluid");
            }
            case 2: {
                return MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_toggleenergy");
            }
            case 3: {
                return MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_togglexp");
            }
            case 4: {
                return MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_toggledust");
            }
        }
        return false;
    }

    public boolean canSend(int type, ItemStack stack) {
        switch (type) {
            case 0: {
                return !MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_toggleitem");
            }
            case 1: {
                return !MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_togglefluid");
            }
            case 2: {
                return !MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_toggleenergy");
            }
            case 3: {
                return !MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_togglexp");
            }
            case 4: {
                return !MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_toggledust");
            }
        }
        return true;
    }

    public void toggleTransferType(int type, ItemStack stack) {
        switch (type) {
            case 0: {
                MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (!MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_toggleitem") ? 1 : 0) != 0, (String)"pedestals_augment_transfertoggle_toggleitem");
            }
            case 1: {
                MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (!MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_togglefluid") ? 1 : 0) != 0, (String)"pedestals_augment_transfertoggle_togglefluid");
            }
            case 2: {
                MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (!MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_toggleenergy") ? 1 : 0) != 0, (String)"pedestals_augment_transfertoggle_toggleenergy");
            }
            case 3: {
                MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (!MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_togglexp") ? 1 : 0) != 0, (String)"pedestals_augment_transfertoggle_togglexp");
            }
            case 4: {
                MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (!MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (String)"pedestals_augment_transfertoggle_toggledust") ? 1 : 0) != 0, (String)"pedestals_augment_transfertoggle_toggledust");
            }
        }
    }

    public void iterateTransferType(ItemStack stack) {
        int maxType = 3;
        if (References.isDustLoaded()) {
            maxType = 4;
        }
        int currentType = AugmentTransferToggle.getTransferType(stack);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)stack.m_41784_(), (int)(currentType + 1 > maxType ? 0 : currentType + 1), (String)"pedestals_augment_transfertoggle_type");
    }

    public InteractionResultHolder interactTargetAir(Level level, Player player, InteractionHand hand, ItemStack itemStackInHand, HitResult result) {
        this.toggleTransferType(AugmentTransferToggle.getTransferType(itemStackInHand), itemStackInHand);
        boolean currentToggle = AugmentTransferToggle.getTransferToggle(AugmentTransferToggle.getTransferType(itemStackInHand), itemStackInHand);
        String typeStringList = currentToggle ? ".augment_transfertoggle_off" : ".augment_transfertoggle_on";
        ChatFormatting chatColorList = currentToggle ? ChatFormatting.BLACK : ChatFormatting.WHITE;
        MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)chatColorList, (String)("pedestals" + typeStringList));
        return super.interactCrouchingTargetAir(level, player, hand, itemStackInHand, result);
    }

    public InteractionResultHolder interactCrouchingTargetAir(Level level, Player player, InteractionHand hand, ItemStack itemStackInHand, HitResult result) {
        this.iterateTransferType(itemStackInHand);
        int currentType = AugmentTransferToggle.getTransferType(itemStackInHand);
        ArrayList<String> typeStringList = new ArrayList<String>(Arrays.asList(".augment_transfertoggle_item", ".augment_transfertoggle_fluid", ".augment_transfertoggle_energy", ".augment_transfertoggle_xp", ".augment_transfertoggle_dust"));
        ArrayList<ChatFormatting> chatColorList = new ArrayList<ChatFormatting>(Arrays.asList(ChatFormatting.GOLD, ChatFormatting.AQUA, ChatFormatting.RED, ChatFormatting.GREEN, ChatFormatting.LIGHT_PURPLE));
        MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)((ChatFormatting)chatColorList.get(currentType)), (String)("pedestals" + (String)typeStringList.get(currentType)));
        return super.interactTargetAir(level, player, hand, itemStackInHand, result);
    }

    @Override
    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        int maxType = 3;
        if (References.isDustLoaded()) {
            maxType = 4;
        }
        ArrayList<String> typeStringList = new ArrayList<String>(Arrays.asList(".augment_transfertoggle_item", ".augment_transfertoggle_fluid", ".augment_transfertoggle_energy", ".augment_transfertoggle_xp", ".augment_transfertoggle_dust"));
        ArrayList<ChatFormatting> chatColorList = new ArrayList<ChatFormatting>(Arrays.asList(ChatFormatting.GOLD, ChatFormatting.AQUA, ChatFormatting.RED, ChatFormatting.GREEN, ChatFormatting.LIGHT_PURPLE));
        for (int i = 0; i <= maxType; ++i) {
            boolean currentToggle = AugmentTransferToggle.getTransferToggle(i, p_41421_);
            String typeStringListBool = currentToggle ? ".augment_transfertoggle_off" : ".augment_transfertoggle_on";
            MutableComponent componentColon = Component.m_237113_((String)": ");
            MutableComponent component = Component.m_237115_((String)("pedestals" + (String)typeStringList.get(i)));
            component.m_130940_((ChatFormatting)chatColorList.get(i));
            MutableComponent componentBool = Component.m_237115_((String)("pedestals" + typeStringListBool));
            componentBool.m_130940_(ChatFormatting.WHITE);
            component.m_7220_((Component)componentColon);
            component.m_7220_((Component)componentBool);
            MowLibTooltipUtils.addTooltipMessage(p_41423_, (ItemStack)p_41421_, (MutableComponent)component);
        }
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
    }
}

