/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.MechanicalOnlyStorage;

import com.mowmaster.mowlib.Items.BaseDustDropItem;
import com.mowmaster.mowlib.MowLibUtils.MowLibTooltipUtils;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.MechanicalOnlyStorage.IBulkItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class BaseFluidBulkStorageItem
extends BaseDustDropItem
implements IBulkItem {
    private int counter = 0;

    public BaseFluidBulkStorageItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    private int getDischargeCounter(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_dischargeCounter")) {
            return BaseFluidBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_dischargeCounter");
        }
        this.setDischargeCounter(stack);
        return 0;
    }

    private void increaseDischargeCounter(ItemStack stack) {
        int current = 0;
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if (tag.m_128441_("pedestals_dischargeCounter")) {
            current = BaseFluidBulkStorageItem.readIntegerFromNBT("pedestals", tag, "_dischargeCounter");
        }
        BaseFluidBulkStorageItem.writeIntegerToNBT("pedestals", tag, current + 1, "_dischargeCounter");
    }

    private void setDischargeCounter(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        BaseFluidBulkStorageItem.writeIntegerToNBT("pedestals", tag, 0, "_dischargeCounter");
    }

    public static CompoundTag writeIntegerToNBT(String ModID, @Nullable CompoundTag inputNBT, int input, String intName) {
        CompoundTag compound = inputNBT != null ? inputNBT : new CompoundTag();
        compound.m_128405_(ModID + intName, input);
        return compound;
    }

    public static int readIntegerFromNBT(String ModID, CompoundTag inputNBT, String intName) {
        if (inputNBT.m_128441_(ModID + intName)) {
            return inputNBT.m_128451_(ModID + intName);
        }
        return 0;
    }

    public static CompoundTag writeFluidStackToNBT(String ModID, @Nullable CompoundTag inputNBT, FluidStack fluidStack) {
        CompoundTag compound;
        CompoundTag compoundTag = compound = inputNBT != null ? inputNBT : new CompoundTag();
        if (fluidStack.isEmpty()) {
            return compound;
        }
        compound.m_128365_(ModID + "_storedFluid", (Tag)fluidStack.writeToNBT(new CompoundTag()));
        return compound;
    }

    public static FluidStack readFluidStackFromNBT(String ModID, CompoundTag inputNBT) {
        FluidStack fluidStack = FluidStack.EMPTY;
        if (inputNBT.m_128441_(ModID + "_storedFluid")) {
            return FluidStack.loadFluidStackFromNBT((CompoundTag)inputNBT.m_128469_(ModID + "_storedFluid"));
        }
        return fluidStack;
    }

    public static int getItemColor() {
        return 2518783;
    }

    public int getMaxAllowedStorage() {
        return (Integer)PedestalConfig.COMMON.pedestal_baseFluidStorage.get() + (Integer)PedestalConfig.COMMON.augment_t4StorageFluid.get() * (Integer)PedestalConfig.COMMON.augment_t4StorageInsertSize.get();
    }

    public void setFluidStack(ItemStack stack, FluidStack stackFluid) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        BaseFluidBulkStorageItem.writeFluidStackToNBT("pedestals", tag, stackFluid);
        stack.m_41751_(tag);
    }

    public FluidStack getFluid(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        return BaseFluidBulkStorageItem.readFluidStackFromNBT("pedestals", tag);
    }

    public void addFluid(ItemStack stack, FluidStack stackFluid) {
        FluidStack currentStack;
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if ((currentStack = BaseFluidBulkStorageItem.readFluidStackFromNBT("pedestals", tag)).isFluidEqual(stackFluid)) {
            int difference = currentStack.getAmount() + stackFluid.getAmount();
            currentStack.setAmount(difference > this.getMaxAllowedStorage() ? this.getMaxAllowedStorage() : difference);
            BaseFluidBulkStorageItem.writeFluidStackToNBT("pedestals", tag, currentStack);
            stack.m_41751_(tag);
        }
    }

    public void removeFluid(ItemStack stack, int removed) {
        FluidStack currentStack;
        int difference;
        CompoundTag tag = new CompoundTag();
        if (stack.m_41782_()) {
            tag = stack.m_41783_();
        }
        if ((difference = (currentStack = BaseFluidBulkStorageItem.readFluidStackFromNBT("pedestals", tag)).getAmount() - removed) > 0) {
            currentStack.setAmount(difference);
        } else {
            currentStack = FluidStack.EMPTY;
        }
        BaseFluidBulkStorageItem.writeFluidStackToNBT("pedestals", tag, currentStack);
        stack.m_41751_(tag);
    }

    public int getItemVariant(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack).copy();
        if (!fluidStack.isEmpty()) {
            double renderDevider = 100.0 * (double)(fluidStack.getAmount() / this.getMaxAllowedStorage());
            if (renderDevider <= 25.0) {
                return 0;
            }
            if (renderDevider <= 50.0) {
                return 1;
            }
            if (renderDevider <= 75.0) {
                return 2;
            }
            if (renderDevider >= 100.0) {
                return 3;
            }
        }
        return 0;
    }

    public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.m_6883_(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
        if (!p_41405_.m_5776_()) {
            Player player;
            boolean survival = true;
            if (p_41406_ instanceof Player && (player = (Player)p_41406_).m_7500_()) {
                survival = false;
            }
            if (survival && ((Boolean)PedestalConfig.COMMON.bulkstorage_fluidDischarge_toggle.get()).booleanValue()) {
                FluidStack fluidIn = this.getFluid(p_41404_);
                if (!fluidIn.isEmpty()) {
                    ++this.counter;
                    if (this.counter >= 20) {
                        this.increaseDischargeCounter(p_41404_);
                        this.counter = 0;
                    }
                }
                if (this.getDischargeCounter(p_41404_) >= (Integer)PedestalConfig.COMMON.bulkstorage_fluidDischarge.get()) {
                    this.removeFluid(p_41405_, p_41406_.m_20097_(), p_41404_);
                    p_41404_.m_41774_(1);
                }
            }
        }
    }

    public void removeFluid(Level worldIn, BlockPos pos, ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack).copy();
        int radius = this.getItemVariant(stack) + 1;
        Item item = fluidStack.getFluid().m_6859_();
        int x = -radius;
        int z = -radius;
        int y = 0;
        while (fluidStack.getAmount() >= 1000) {
            if (item instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)item;
                BlockState state = worldIn.m_8055_(pos.m_7918_(x, y, z));
                if (state.m_60734_().equals(Blocks.f_50016_) && bucketItem.m_142073_((Player)null, worldIn, pos.m_7918_(x, y, z), (BlockHitResult)null)) {
                    fluidStack.grow(-1000);
                }
                if (x >= 1 && z >= 1) {
                    ++y;
                    x = -1;
                    z = -1;
                }
                if (x >= 1) {
                    x = -1;
                    ++z;
                }
                ++x;
            }
            if (y <= radius) continue;
            break;
        }
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        int charge;
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        FluidStack fluid = this.getFluid(p_41421_);
        if (!fluid.isEmpty()) {
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237115_((String)"pedestals.bulkstorage_fluid"), (ChatFormatting)ChatFormatting.GOLD);
            MutableComponent comp = fluid.getDisplayName().m_6881_();
            comp.m_130946_(": " + fluid.getAmount() + "mb");
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)comp, (ChatFormatting)ChatFormatting.WHITE);
        }
        if ((charge = this.getDischargeCounter(p_41421_)) > 0) {
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237115_((String)"pedestals.bulkstorage_fluid_discharge"), (ChatFormatting)ChatFormatting.RED);
            MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (MutableComponent)Component.m_237113_((String)(charge + "/" + PedestalConfig.COMMON.bulkstorage_fluidDischarge.get())), (ChatFormatting)ChatFormatting.WHITE);
        }
    }
}

