/*
 * Decompiled with CFR 0.152.
 */
package com.vyklade.ars_armiger.tetra;

import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.BasicReductionCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.ThrownModularItemEntity;

@Mod.EventBusSubscriber(modid="ars_armiger")
public class TetraEventHandler {
    @SubscribeEvent
    public static void onAttackEntityEvent(@NotNull AttackEntityEvent event) {
        Player source = event.getEntity();
        Entity target = event.getTarget();
        if (source == null || target == null) {
            return;
        }
        if (!(source instanceof Player)) {
            return;
        }
        if (!(source instanceof LivingEntity)) {
            return;
        }
        Level level = target.m_20193_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        for (ItemStack hand : source.m_6167_()) {
            int spellstriker;
            LazyOptional manaCap;
            if (hand == ItemStack.f_41583_) {
                return;
            }
            if (!(hand.m_41720_() instanceof ModularItem)) {
                return;
            }
            int sourceLeech = ((ModularItem)hand.m_41720_()).getEffectLevel(hand, ItemEffect.get((String)"source_leech"));
            if (sourceLeech > 0 && (manaCap = CapabilityRegistry.getMana((LivingEntity)source)).isPresent()) {
                IManaCap mana = (IManaCap)manaCap.resolve().get();
                int maxMana = mana.getMaxMana();
                double recover = Math.floor(sourceLeech * 100 / maxMana);
                mana.addMana(recover);
            }
            if ((spellstriker = ((ModularItem)hand.m_41720_()).getEffectLevel(hand, ItemEffect.get((String)"spellstrike"))) <= 0) continue;
            if (source.m_36335_().m_41519_(hand.m_41720_())) {
                return;
            }
            double cooldown = ((ModularItem)hand.m_41720_()).getEffectEfficiency(hand, ItemEffect.get((String)"spellstrike_duration"));
            double cost = ((ModularItem)hand.m_41720_()).getEffectEfficiency(hand, ItemEffect.get((String)"spellstrike_efficiency"));
            int power = ((ModularItem)hand.m_41720_()).getEffectLevel(hand, ItemEffect.get((String)"spellstrike_power"));
            BasicReductionCaster caster = new BasicReductionCaster(hand, spell -> {
                spell.addDiscount(MethodTouch.INSTANCE.getCastingCost());
                return spell;
            });
            PlayerCaster player = new PlayerCaster(source);
            Spell spell2 = caster.modifySpellBeforeCasting(level, (Entity)source, InteractionHand.MAIN_HAND, caster.getSpell());
            if (spell2.isEmpty()) {
                return;
            }
            int air = ((ModularItem)hand.m_41720_()).getEffectLevel(hand, ItemEffect.get((String)"air_attunement"));
            int earth = ((ModularItem)hand.m_41720_()).getEffectLevel(hand, ItemEffect.get((String)"earth_attunement"));
            int fire = ((ModularItem)hand.m_41720_()).getEffectLevel(hand, ItemEffect.get((String)"fire_attunement"));
            int water = ((ModularItem)hand.m_41720_()).getEffectLevel(hand, ItemEffect.get((String)"water_attunement"));
            if (air > 0) {
                TetraEventHandler.Amplify(spell2, SpellSchools.ELEMENTAL_AIR, air >= 2);
            } else if (earth > 0) {
                TetraEventHandler.Amplify(spell2, SpellSchools.ELEMENTAL_EARTH, earth >= 2);
            } else if (fire > 0) {
                TetraEventHandler.Amplify(spell2, SpellSchools.ELEMENTAL_FIRE, fire >= 2);
            } else if (water > 0) {
                TetraEventHandler.Amplify(spell2, SpellSchools.ELEMENTAL_WATER, water >= 2);
            }
            if (power > 0) {
                TetraEventHandler.Power(spell2, power);
            }
            spell2.addDiscount((int)((double)spell2.getNoDiscountCost() * (1.0 - cost)));
            SpellContext context = new SpellContext(level, spell2, (LivingEntity)source, (IWrappedCaster)player);
            SpellResolver resolver = new SpellResolver(context);
            resolver.onCastOnEntity(hand, target, InteractionHand.MAIN_HAND);
            source.m_36335_().m_41524_(hand.m_41720_(), (int)Math.ceil(cooldown * 20.0));
        }
    }

    @SubscribeEvent
    public static void onProjectileImpactEvent(@NotNull ProjectileImpactEvent event) {
        int spellstriker;
        LazyOptional manaCap;
        Projectile proj = event.getProjectile();
        HitResult result = event.getRayTraceResult();
        if (proj == null || result == null) {
            return;
        }
        Level level = proj.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (result.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        if (!(proj instanceof ThrownModularItemEntity)) {
            return;
        }
        ItemStack item = ((ThrownModularItemEntity)proj).getThrownStack();
        if (item == null) {
            return;
        }
        if (item == ItemStack.f_41583_) {
            return;
        }
        if (!(item.m_41720_() instanceof ModularItem)) {
            return;
        }
        CompoundTag data = proj.getPersistentData();
        Entity owner = proj.m_37282_();
        if (owner == null) {
            return;
        }
        int sourceLeech = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"source_leech"));
        if (sourceLeech > 0 && (manaCap = CapabilityRegistry.getMana((LivingEntity)((Player)owner))).isPresent()) {
            IManaCap mana = (IManaCap)manaCap.resolve().get();
            int maxMana = mana.getMaxMana();
            double recover = Math.floor(sourceLeech * 100 / maxMana);
            mana.addMana(recover);
        }
        if ((spellstriker = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"spellstrike"))) <= 0) {
            return;
        }
        double cooldown = ((ModularItem)item.m_41720_()).getEffectEfficiency(item, ItemEffect.get((String)"spellstrike_duration"));
        double cost = ((ModularItem)item.m_41720_()).getEffectEfficiency(item, ItemEffect.get((String)"spellstrike_efficiency"));
        int power = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"spellstrike_power"));
        BasicReductionCaster caster = new BasicReductionCaster(item, spell -> {
            spell.addDiscount(MethodTouch.INSTANCE.getCastingCost());
            return spell;
        });
        PlayerCaster player = new PlayerCaster((Player)owner);
        Spell spell2 = caster.modifySpellBeforeCasting(level, owner, InteractionHand.MAIN_HAND, caster.getSpell());
        if (spell2.isEmpty()) {
            return;
        }
        int air = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"air_attunement"));
        int earth = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"earth_attunement"));
        int fire = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"fire_attunement"));
        int water = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"water_attunement"));
        if (air > 0) {
            TetraEventHandler.Amplify(spell2, SpellSchools.ELEMENTAL_AIR, air >= 2);
        } else if (earth > 0) {
            TetraEventHandler.Amplify(spell2, SpellSchools.ELEMENTAL_EARTH, earth >= 2);
        } else if (fire > 0) {
            TetraEventHandler.Amplify(spell2, SpellSchools.ELEMENTAL_FIRE, fire >= 2);
        } else if (water > 0) {
            TetraEventHandler.Amplify(spell2, SpellSchools.ELEMENTAL_WATER, water >= 2);
        }
        if (power > 0) {
            TetraEventHandler.Power(spell2, power);
        }
        spell2.addDiscount((int)((double)spell2.getNoDiscountCost() * (1.0 - cost)));
        SpellContext context = new SpellContext(level, spell2, (LivingEntity)owner, (IWrappedCaster)player);
        SpellResolver resolver = new SpellResolver(context);
        switch (result.m_6662_()) {
            case ENTITY: {
                if (!(result instanceof EntityHitResult)) {
                    return;
                }
                byte pierce = ((ThrownModularItemEntity)proj).m_36796_();
                if (!data.m_128441_("ars_armiger:collided_entities")) {
                    data.m_128405_("ars_armiger:collided_entities", 0);
                }
                int collisions = data.m_128451_("ars_armiger:collided_entities");
                if (data.m_128441_("ars_armiger:hit_entity") && collisions > pierce && data.m_128471_("ars_armiger:hit_entity")) {
                    return;
                }
                Entity target = ((EntityHitResult)result).m_82443_();
                if (target == null) {
                    return;
                }
                resolver.onCastOnEntity(item, target, InteractionHand.MAIN_HAND);
                data.m_128379_("ars_armiger:hit_entity", true);
                data.m_128405_("ars_armiger:collided_entities", data.m_128451_("ars_armiger:collided_entities") + 1);
                break;
            }
            case BLOCK: {
                if (!(result instanceof BlockHitResult)) {
                    return;
                }
                if (data.m_128441_("ars_armiger:hit_block") && data.m_128471_("ars_armiger:hit_block")) {
                    return;
                }
                if (data.m_128441_("ars_armiger:hit_entity") && data.m_128471_("ars_armiger:hit_entity")) {
                    return;
                }
                resolver.onCastOnBlock((BlockHitResult)result);
                data.m_128379_("ars_armiger:hit_block", true);
            }
        }
        ((Player)owner).m_36335_().m_41524_(item.m_41720_(), (int)Math.ceil(cooldown * 20.0));
    }

    @SubscribeEvent
    public static void onBlockAttack(@NotNull ShieldBlockEvent event) {
        LivingEntity blocker = event.getEntity();
        if (blocker == null) {
            return;
        }
        if (!(blocker instanceof Player)) {
            return;
        }
        Player playerEntity = (Player)blocker;
        Level level = playerEntity.m_20193_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        DamageSource source = event.getDamageSource();
        if (source.m_7639_() == null) {
            return;
        }
        Entity attacker = source.m_7639_();
        ItemStack itemStack = playerEntity.m_21211_();
        if (itemStack == ItemStack.f_41583_) {
            return;
        }
        if (!(itemStack.m_41720_() instanceof ItemModularHandheld)) {
            return;
        }
        if (playerEntity.m_36335_().m_41519_(itemStack.m_41720_())) {
            return;
        }
        float spellguard = ((ModularItem)itemStack.m_41720_()).getEffectEfficiency(itemStack, ItemEffect.get((String)"spellguard"));
        int spellguardChance = ((ModularItem)itemStack.m_41720_()).getEffectLevel(itemStack, ItemEffect.get((String)"spellguard"));
        if (spellguardChance <= 0) {
            return;
        }
        if (new Random().nextInt(101) <= spellguardChance + 1) {
            BasicReductionCaster caster = new BasicReductionCaster(itemStack, spell -> {
                spell.addDiscount(MethodTouch.INSTANCE.getCastingCost());
                return spell;
            });
            PlayerCaster player = new PlayerCaster(playerEntity);
            Spell spell2 = caster.modifySpellBeforeCasting(level, (Entity)playerEntity, InteractionHand.MAIN_HAND, caster.getSpell());
            if (spell2.isEmpty()) {
                return;
            }
            if (spellguard < 1.0f) {
                int cost = spell2.getNoDiscountCost();
                spell2.addDiscount(Math.round((float)cost * (1.0f - spellguard)));
            }
            SpellContext context = new SpellContext(level, spell2, (LivingEntity)playerEntity, (IWrappedCaster)player);
            SpellResolver resolver = new SpellResolver(context);
            resolver.onCastOnEntity(itemStack, attacker, InteractionHand.MAIN_HAND);
            double baseCooldown = ((ItemModularHandheld)itemStack.m_41720_()).getCooldownBase(itemStack);
            playerEntity.m_36335_().m_41524_(itemStack.m_41720_(), (int)Math.round(Math.max(1.0, baseCooldown * 20.0)));
        }
    }

    public static void Amplify(Spell Spell2, SpellSchool school, boolean trueAttune) {
        for (int i = 0; i < Spell2.recipe.size(); ++i) {
            AbstractSpellPart part = (AbstractSpellPart)Spell2.recipe.get(i);
            if (!(part instanceof AbstractEffect) || !SpellSchools.ELEMENTAL.isPartOfSchool(part)) continue;
            if (school.isPartOfSchool(part)) {
                Spell2.add((AbstractSpellPart)AugmentAmplify.INSTANCE, 1, i + 1);
                Spell2.addDiscount(AugmentAmplify.INSTANCE.getCastingCost());
                continue;
            }
            if (trueAttune) continue;
            Spell2.add((AbstractSpellPart)AugmentDampen.INSTANCE, 1, i + 1);
            Spell2.addDiscount(AugmentDampen.INSTANCE.getCastingCost());
        }
    }

    public static void Power(Spell Spell2, int level) {
        int added = 0;
        for (int i = Spell2.recipe.size() - 1; i >= 0; --i) {
            AbstractSpellPart part = (AbstractSpellPart)Spell2.recipe.get(i);
            if (!(part instanceof AbstractEffect)) continue;
            if (added >= level) {
                return;
            }
            Spell2.add((AbstractSpellPart)AugmentAmplify.INSTANCE, 1, i + 1);
            Spell2.addDiscount(AugmentAmplify.INSTANCE.getCastingCost());
            ++added;
        }
    }
}

