/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part.aspect;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integratedtunnels.api.network.IFluidNetwork;
import org.cyclops.integratedtunnels.capability.network.FluidNetworkConfig;
import org.cyclops.integratedtunnels.core.part.PartStateRoundRobin;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;
import org.cyclops.integratedtunnels.part.aspect.ChanneledTargetCapabilityProvider;
import org.cyclops.integratedtunnels.part.aspect.IFluidTarget;
import org.cyclops.integratedtunnels.part.aspect.ITunnelConnection;
import org.cyclops.integratedtunnels.part.aspect.ITunnelTransfer;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders;
import org.cyclops.integratedtunnels.part.aspect.TunnelConnectionPositionedNetworkCapabilityProvider;

public class FluidTargetCapabilityProvider
extends ChanneledTargetCapabilityProvider<IFluidNetwork, FluidStack, Integer>
implements IFluidTarget {
    private final ITunnelConnection connection;
    private final PartTarget partTarget;
    private final IngredientPredicate<FluidStack, Integer> fluidStackMatcher;
    private final IAspectProperties properties;

    public FluidTargetCapabilityProvider(ITunnelTransfer transfer, INetwork network, @Nullable ICapabilityProvider capabilityProvider, Direction side, IngredientPredicate<FluidStack, Integer> fluidStackMatcher, PartTarget partTarget, IAspectProperties properties, @Nullable PartStateRoundRobin<?> partState) {
        super(network, capabilityProvider, side, (IFluidNetwork)network.getCapability(FluidNetworkConfig.CAPABILITY).orElse(null), partState, ((ValueTypeInteger.ValueInteger)properties.getValue(TunnelAspectWriteBuilders.PROP_CHANNEL)).getRawValue(), ((ValueTypeBoolean.ValueBoolean)properties.getValue(TunnelAspectWriteBuilders.PROP_ROUNDROBIN)).getRawValue(), ((ValueTypeBoolean.ValueBoolean)properties.getValue(TunnelAspectWriteBuilders.PROP_CRAFT)).getRawValue(), ((ValueTypeBoolean.ValueBoolean)properties.getValue(TunnelAspectWriteBuilders.PROP_PASSIVE_IO)).getRawValue());
        this.connection = new TunnelConnectionPositionedNetworkCapabilityProvider(network, this.getChannel(), partTarget.getTarget(), transfer, capabilityProvider);
        this.fluidStackMatcher = fluidStackMatcher;
        this.partTarget = partTarget;
        this.properties = properties;
    }

    @Override
    public PartTarget getPartTarget() {
        return this.partTarget;
    }

    @Override
    public IIngredientComponentStorage<FluidStack, Integer> getFluidChannel() {
        if (this.getFluidStackMatcher().hasMatchFlags()) {
            return ((IFluidNetwork)this.getChanneledNetwork()).getChannel(this.getChannel());
        }
        return ((IFluidNetwork)this.getChanneledNetwork()).getChannelSlotted(this.getChannel());
    }

    @Override
    public IngredientPredicate<FluidStack, Integer> getFluidStackMatcher() {
        return this.fluidStackMatcher;
    }

    @Override
    public IAspectProperties getProperties() {
        return this.properties;
    }

    @Override
    public ITunnelConnection getConnection() {
        return this.connection;
    }

    @Override
    protected IngredientComponent<FluidStack, Integer> getComponent() {
        return IngredientComponent.FLUIDSTACK;
    }
}

