/*
 * Decompiled with CFR 0.152.
 */
package com.prunoideae.schema;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import com.prunoideae.custom.brew.BotaniaRegistryObjectBuilderTypes;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.component.BlockComponent;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.TagKeyComponent;
import dev.latvian.mods.kubejs.typings.desc.DescriptionContext;
import dev.latvian.mods.kubejs.typings.desc.TypeDescJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.crafting.StateIngredientHelper;

public interface BotaniaSchema {
    public static final RecipeComponent<Either<Block, TagKey<Block>>> BLOCK_OR_TAG = new RecipeComponent<Either<Block, TagKey<Block>>>(){

        public Class<?> componentClass() {
            return Block.class;
        }

        public TypeDescJS constructorDescription(DescriptionContext ctx) {
            return BlockComponent.INPUT.constructorDescription(ctx).or(TagKeyComponent.BLOCK.constructorDescription(ctx));
        }

        public JsonElement write(RecipeJS recipe, Either<Block, TagKey<Block>> value) {
            JsonObject object = new JsonObject();
            if (value.left().isPresent()) {
                object.addProperty("type", "block");
                object.addProperty("block", Registry.f_122824_.m_7981_((Object)((Block)value.left().get())).toString());
            } else if (value.right().isPresent()) {
                object.addProperty("type", "tag");
                object.addProperty("tag", ((TagKey)value.right().get()).f_203868_().toString());
            }
            return object;
        }

        public Either<Block, TagKey<Block>> read(RecipeJS recipe, Object from) {
            if (from instanceof Block) {
                Block block = (Block)from;
                return Either.left((Object)block);
            }
            if (from instanceof TagKey) {
                TagKey tag = (TagKey)from;
                return tag.m_207647_(Registry.f_122901_).map(Either::right).orElseThrow(() -> new IllegalArgumentException("Tag " + tag + " does not exist"));
            }
            if (from instanceof JsonObject) {
                JsonObject object = (JsonObject)from;
                String type = object.get("type").getAsString();
                if (type.equals("block")) {
                    return Either.left((Object)((Block)Registry.f_122824_.m_7745_(new ResourceLocation(object.get("block").getAsString()))));
                }
                if (type.equals("tag")) {
                    return Either.right((Object)TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(object.get("tag").getAsString())));
                }
                return null;
            }
            String name = from.toString();
            if (name.startsWith("#")) {
                return Either.right((Object)TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(name.substring(1))));
            }
            return Either.left((Object)((Block)Registry.f_122824_.m_7745_(new ResourceLocation(name))));
        }
    };
    public static final RecipeComponent<BlockState> BLOCK_OUTPUT = new RecipeComponent<BlockState>(){

        public Class<?> componentClass() {
            return BlockState.class;
        }

        public ComponentRole role() {
            return ComponentRole.OUTPUT;
        }

        public TypeDescJS constructorDescription(DescriptionContext ctx) {
            return super.constructorDescription(ctx).or(ctx.javaType(Block.class));
        }

        public JsonElement write(RecipeJS recipe, BlockState value) {
            return StateIngredientHelper.serializeBlockState((BlockState)value);
        }

        public BlockState read(RecipeJS recipe, Object from) {
            if (from instanceof Block) {
                Block b = (Block)from;
                return b.m_49966_();
            }
            if (from instanceof BlockState) {
                BlockState bs = (BlockState)from;
                return bs;
            }
            if (from instanceof JsonObject) {
                JsonObject object = (JsonObject)from;
                return StateIngredientHelper.readBlockState((JsonObject)object);
            }
            return UtilsJS.parseBlockState((String)from.toString());
        }
    };
    public static final RecipeComponent<Brew> BREW = new RecipeComponent<Brew>(){

        public Class<?> componentClass() {
            return Brew.class;
        }

        public ComponentRole role() {
            return ComponentRole.OUTPUT;
        }

        public JsonElement write(RecipeJS recipe, Brew value) {
            ResourceLocation key = BotaniaRegistryObjectBuilderTypes.BREW_REGISTRY.m_7981_((Object)value);
            if (key == null) {
                throw new IllegalArgumentException("Brew " + value + " is not registered");
            }
            return new JsonPrimitive(key.toString());
        }

        public Brew read(RecipeJS recipe, Object from) {
            if (from instanceof Brew) {
                Brew brew = (Brew)from;
                return brew;
            }
            if (from instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)from;
                return (Brew)BotaniaRegistryObjectBuilderTypes.BREW_REGISTRY.m_7745_(new ResourceLocation(primitive.getAsString()));
            }
            return (Brew)BotaniaRegistryObjectBuilderTypes.BREW_REGISTRY.m_7745_(new ResourceLocation(from.toString()));
        }
    };
}

