/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsartifice.client;

import com.github.jarva.arsartifice.ArsArtifice;
import com.github.jarva.arsartifice.client.gui.CraftingButton;
import com.github.jarva.arsartifice.client.gui.GlyphButton;
import com.github.jarva.arsartifice.client.gui.PlainTextLabel;
import com.github.jarva.arsartifice.glyphs.AbstractArtificeMethod;
import com.github.jarva.arsartifice.validators.CombinedArtificeValidator;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.client.gui.book.BaseBook;
import com.hollingsworth.arsnouveau.client.gui.buttons.CreateSpellButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.common.capability.IPlayerCap;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateCaster;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ArtificeCreationMenu
extends BaseBook {
    public final ISpellValidator spellValidator;
    private InteractionHand hand;
    private ItemStack held;
    public List<AbstractSpellPart> unlockedSpells;
    public int page = 0;
    public int glyphsPerPage = 58;
    public List<CraftingButton> craftingCells = new ArrayList<CraftingButton>();
    public List<GlyphButton> glyphButtons = new ArrayList<GlyphButton>();
    public PageButton nextButton;
    public PageButton prevButton;
    public int PER_ROW = 6;
    public int PER_PAGE = 6;
    public static final Map<Integer, Component> typeIndexLabels = new HashMap<Integer, Component>();

    public ArtificeCreationMenu(InteractionHand hand) {
        this.hand = hand;
        this.api = ArsNouveauAPI.getInstance();
        IPlayerCap cap = (IPlayerCap)CapabilityRegistry.getPlayerDataCap((LivingEntity)Minecraft.m_91087_().f_91074_).orElse(null);
        this.unlockedSpells = cap == null ? new ArrayList<AbstractSpellPart>() : new ArrayList<AbstractSpellPart>(cap.getKnownGlyphs().stream().filter(AbstractSpellPart::isEnabled).toList());
        this.unlockedSpells.addAll(this.api.getDefaultStartingSpells());
        this.unlockedSpells = this.unlockedSpells.stream().filter(s -> s instanceof AbstractArtificeMethod || s instanceof AbstractAugment).collect(Collectors.toList());
        this.unlockedSpells = this.unlockedSpells.stream().filter(s -> {
            if (s instanceof AbstractAugment) {
                return this.unlockedSpells.stream().anyMatch(part -> part.compatibleAugments.contains(s));
            }
            return true;
        }).collect(Collectors.toList());
        this.held = Minecraft.m_91087_().f_91074_.m_21120_(hand);
        this.spellValidator = new CombinedArtificeValidator();
    }

    public void m_7856_() {
        super.m_7856_();
        for (int i = 0; i < 10; ++i) {
            int offset = i >= 5 ? 14 : 0;
            CraftingButton cell = new CraftingButton(this, this.bookLeft + 19 + 24 * i + offset, this.bookTop + 194 - 47, i, this::onCraftingSlotClick);
            this.m_142416_((GuiEventListener)cell);
            this.craftingCells.add(cell);
        }
        this.updateCraftingSlots(0);
        this.layoutAllGlyphs(this.page);
        this.m_142416_((GuiEventListener)new CreateSpellButton((BaseBook)this, this.bookRight - 71, this.bookBottom - 13, this::onCreateClick));
        this.m_142416_((GuiEventListener)new GuiImageButton(this.bookRight - 126, this.bookBottom - 13, 0, 0, 41, 12, 41, 12, "textures/gui/clear_icon.png", this::clear));
        this.nextButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(this.bookRight - 20, this.bookBottom - 10, true, btn -> this.changePage(1), true));
        this.prevButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(this.bookLeft - 5, this.bookBottom - 10, true, btn -> this.changePage(-1), true));
        this.updatePageButtons();
        this.validate();
    }

    public int getNumPages() {
        return (int)Math.ceil((double)this.unlockedSpells.size() / (double)this.glyphsPerPage);
    }

    public void updatePageButtons() {
        if (this.page == 0) {
            this.prevButton.f_93623_ = false;
            this.prevButton.f_93624_ = false;
        }
        if (this.page == this.getNumPages() - 1 || this.getNumPages() <= 2) {
            this.nextButton.f_93623_ = false;
            this.nextButton.f_93624_ = false;
        }
    }

    public void changePage(int val) {
        int newPage = this.page + val;
        if (newPage > this.getNumPages()) {
            return;
        }
        if (newPage < 0) {
            return;
        }
        this.page = newPage;
        this.updatePageButtons();
        this.layoutAllGlyphs(this.page);
        this.validate();
    }

    public void clear(Button button) {
        for (CraftingButton slot : this.craftingCells) {
            slot.clear();
        }
        this.validate();
    }

    public void validate() {
        List<AbstractSpellPart> recipe = this.craftingCells.stream().filter(b -> b.spellTag != ArsNouveauAPI.EMPTY_KEY).map(b -> (AbstractSpellPart)this.api.getSpellpartMap().get(b.spellTag)).toList();
        List errors = this.spellValidator.validate(recipe);
        for (SpellValidationError error : errors) {
            int pos = error.getPosition();
            if (pos < 0 || pos >= this.craftingCells.size()) continue;
            this.craftingCells.get((int)pos).validationErrors.add(error);
        }
        for (GlyphButton glyphButton : this.glyphButtons) {
            this.validateGlyphButton(recipe, glyphButton);
        }
    }

    private void validateGlyphButton(List<AbstractSpellPart> recipe, GlyphButton glyphButton) {
        glyphButton.validationErrors.clear();
        ArrayList<AbstractSpellPart> changed = new ArrayList<AbstractSpellPart>(recipe);
        changed.add(this.api.getSpellPart(glyphButton.abstractSpellPart.getRegistryName()));
        List<SpellValidationError> errors = this.spellValidator.validate(changed).stream().filter(err -> err.getPosition() >= changed.size() - 1).toList();
        glyphButton.validationErrors.addAll(errors);
    }

    public void onCreateClick(Button button) {
        this.validate();
        if (this.validationErrors.isEmpty()) {
            Spell spell = new Spell();
            this.craftingCells.stream().map(cell -> this.api.getSpellPart(cell.spellTag)).filter(Objects::nonNull).forEach(arg_0 -> ((Spell)spell).add(arg_0));
            Networking.INSTANCE.sendToServer((Object)new PacketUpdateCaster(spell, 0, "Event", this.hand == InteractionHand.MAIN_HAND));
        }
    }

    public void updateCraftingSlots(int sel) {
        List recipe = CasterUtil.getCaster((ItemStack)this.held).getSpell((int)sel).recipe;
        for (int i = 0; i < this.craftingCells.size(); ++i) {
            CraftingButton slot = this.craftingCells.get(i);
            slot.spellTag = ArsNouveauAPI.EMPTY_KEY;
            slot.abstractSpellPart = null;
            if (recipe == null || i >= recipe.size()) continue;
            slot.spellTag = ((AbstractSpellPart)recipe.get(i)).getRegistryName();
            slot.abstractSpellPart = (AbstractSpellPart)recipe.get(i);
        }
    }

    public void clearButtons(List<GlyphButton> glyphButtons) {
        for (GlyphButton glyphButton : glyphButtons) {
            this.f_169369_.remove((Object)glyphButton);
            this.m_6702_().remove((Object)glyphButton);
        }
        glyphButtons.clear();
    }

    public void layoutAllGlyphs(int page) {
        this.clearButtons(this.glyphButtons);
        ArrayList<AbstractSpellPart> filtered = new ArrayList<AbstractSpellPart>(this.unlockedSpells);
        filtered.sort(COMPARE_TYPE_THEN_NAME);
        List sorted = filtered.subList(this.glyphsPerPage * page, Math.min(filtered.size(), this.glyphsPerPage * (page + 1)));
        Map<Integer, List<AbstractSpellPart>> partitioned = sorted.stream().collect(Collectors.groupingBy(AbstractSpellPart::getTypeIndex));
        int yStart = this.bookTop + 20;
        int xStart = this.bookLeft + 20;
        int rows = 0;
        for (Map.Entry<Integer, List<AbstractSpellPart>> group : partitioned.entrySet()) {
            int index = group.getKey();
            List<AbstractSpellPart> glyphs = group.getValue();
            int labelX = xStart;
            Objects.requireNonNull(this.f_96541_.f_91062_);
            int labelY = rows * 18 + yStart + (20 - 9) / 2;
            PlainTextLabel label = new PlainTextLabel(labelX, labelY, 0, 0, typeIndexLabels.getOrDefault(index, (Component)Component.m_237113_((String)"Label")), this.f_96541_.f_91062_, -8355712);
            this.m_169394_((Widget)label);
            for (int i = 0; i < glyphs.size(); ++i) {
                AbstractSpellPart part = glyphs.get(i);
                int col = i % this.PER_ROW;
                if (col == 0) {
                    ++rows;
                }
                boolean nextPage = rows >= this.PER_PAGE;
                int row = rows % this.PER_PAGE;
                int x = xStart + (nextPage ? 134 : 0) + 20 * col;
                int y = row * 18 + yStart;
                ArsArtifice.LOGGER.info("Drawing Glyph {} at {} and {}, with values row {} col {} idx {}", (Object)part.getName(), (Object)x, (Object)y, (Object)rows, (Object)col, (Object)i);
                GlyphButton cell = new GlyphButton(this, x, y, false, part);
                this.m_142416_((GuiEventListener)cell);
                this.glyphButtons.add(cell);
            }
            ++rows;
        }
    }

    public void drawBackgroundElements(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(stack, mouseX, mouseY, partialTicks);
        ArtificeCreationMenu.drawFromTexture((ResourceLocation)new ResourceLocation("ars_nouveau", "textures/gui/clear_paper.png"), (int)161, (int)179, (int)0, (int)0, (int)47, (int)15, (int)47, (int)15, (PoseStack)stack);
        ArtificeCreationMenu.drawFromTexture((ResourceLocation)new ResourceLocation("ars_nouveau", "textures/gui/create_paper.png"), (int)216, (int)179, (int)0, (int)0, (int)56, (int)15, (int)56, (int)15, (PoseStack)stack);
        if (this.validationErrors.isEmpty()) {
            this.f_96541_.f_91062_.m_92889_(stack, (Component)Component.m_237115_((String)"ars_nouveau.spell_book_gui.create"), 233.0f, 183.0f, -8355712);
        } else {
            MutableComponent textComponent = Component.m_237115_((String)"ars_nouveau.spell_book_gui.create").m_130938_(s -> s.m_178522_(Boolean.valueOf(true)).m_131148_(TextColor.m_131268_((String)"#FFB2B2")));
            this.f_96541_.f_91062_.m_92889_(stack, (Component)textComponent, 233.0f, 183.0f, -8355712);
        }
        this.f_96541_.f_91062_.m_92883_(stack, Component.m_237115_((String)"ars_nouveau.spell_book_gui.clear").getString(), 177.0f, 183.0f, -8355712);
    }

    public void onCraftingSlotClick(Button button) {
        if (button instanceof CraftingButton) {
            CraftingButton craftingButton = (CraftingButton)button;
            craftingButton.clear();
        }
        this.validate();
    }

    public void onGlyphClick(Button button) {
        if (button instanceof GlyphButton) {
            GlyphButton glyphButton = (GlyphButton)button;
            if (!glyphButton.validationErrors.isEmpty()) {
                return;
            }
            Optional<CraftingButton> slot = this.craftingCells.stream().filter(cell -> cell.abstractSpellPart == null).findFirst();
            slot.ifPresent(cell -> {
                cell.abstractSpellPart = glyphButton.abstractSpellPart;
                cell.spellTag = glyphButton.abstractSpellPart.getRegistryName();
                this.validate();
            });
        }
    }

    static {
        typeIndexLabels.put(1, (Component)Component.m_237115_((String)"ars_nouveau.spell_book_gui.form"));
        typeIndexLabels.put(5, (Component)Component.m_237115_((String)"ars_nouveau.spell_book_gui.augment"));
    }
}

