/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsartifice.glyphs;

import com.github.jarva.arsartifice.ArsArtifice;
import com.github.jarva.arsartifice.glyphs.AbstractArtificeMethod;
import com.github.jarva.arsartifice.item.ArtificerCurio;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="ars_artifice", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AnguishArtificeMethod
extends AbstractArtificeMethod {
    public static AnguishArtificeMethod INSTANCE = new AnguishArtificeMethod(ArsArtifice.prefix("glyph_anguish"), "Anguish");
    public ForgeConfigSpec.IntValue THRESHOLD;
    public ForgeConfigSpec.IntValue STEP;

    public AnguishArtificeMethod(ResourceLocation tag, String description) {
        super(tag, description);
    }

    public String getBookDescription() {
        return "Anguish triggers when you take damage. Amplify increases the required damage to trigger. Dampen reduces the required damage to trigger.";
    }

    public int getDefaultManaCost() {
        return 0;
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.THRESHOLD = builder.comment("Damage threshold, in half-hearts").defineInRange("threshold", 6, 1, Integer.MAX_VALUE);
        this.STEP = builder.comment("Damage threshold step, in half-hearts").defineInRange("step", 2, 1, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE});
    }

    @SubscribeEvent
    public static void onEntityDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        Optional curios = CuriosApi.getCuriosHelper().getEquippedCurios(entity).resolve();
        curios.ifPresent(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                AbstractArtificeMethod method;
                Object patt3066$temp;
                ArtificerCurio.ArtificerCaster caster;
                Spell artifice;
                ItemStack item = handler.getStackInSlot(i);
                if (!(item.m_41720_() instanceof ArtificerCurio) || (artifice = (caster = new ArtificerCurio.ArtificerCaster(item)).getSpell(0)).isEmpty() || !((patt3066$temp = artifice.recipe.get(0)) instanceof AbstractArtificeMethod) || !((method = (AbstractArtificeMethod)((Object)((Object)patt3066$temp))) instanceof AnguishArtificeMethod)) continue;
                AnguishArtificeMethod retaliateMethod = (AnguishArtificeMethod)method;
                SpellStats stats = retaliateMethod.getSpellStats((ISpellCaster)caster, entity, artifice);
                if (!((double)((Integer)retaliateMethod.THRESHOLD.get()).intValue() + stats.getAmpMultiplier() * (double)((Integer)retaliateMethod.STEP.get()).intValue() <= (double)event.getAmount())) continue;
                caster.castSpell(entity.f_19853_, entity, InteractionHand.MAIN_HAND, (Component)Component.m_237115_((String)"ars_nouveau.spell.validation.crafting.invalid"), caster.getSpell(1));
            }
        });
    }
}

