/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsartifice.glyphs;

import com.github.jarva.arsartifice.ArsArtifice;
import com.github.jarva.arsartifice.glyphs.AbstractArtificeMethod;
import com.github.jarva.arsartifice.glyphs.TickableArtificeMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="ars_artifice", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LandingArtificeMethod
extends AbstractArtificeMethod
implements TickableArtificeMethod {
    public static LandingArtificeMethod INSTANCE = new LandingArtificeMethod(ArsArtifice.prefix("glyph_landing"), "Landing");
    public ForgeConfigSpec.IntValue DISTANCE;
    public ForgeConfigSpec.IntValue STEP;
    public boolean triggered = false;
    public float previousDistance = 0.0f;

    public LandingArtificeMethod(ResourceLocation tag, String description) {
        super(tag, description);
    }

    public String getBookDescription() {
        return "Landing triggers when you land. Amplify increases the distance you need to have fallen for it to trigger.";
    }

    public int getDefaultManaCost() {
        return 0;
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.DISTANCE = builder.comment("Default distance fall to trigger from, in blocks").defineInRange("distance", 0, 0, Integer.MAX_VALUE);
        this.STEP = builder.comment("Distance increase, in blocks").defineInRange("step", 1, 1, Integer.MAX_VALUE);
    }

    @Override
    public void tick(LivingEntity entity, ItemStack stack, ISpellCaster caster, SpellStats stats, Spell spell) {
        InteractionResultHolder result;
        int distance = (int)((double)((Integer)this.DISTANCE.get()).intValue() + stats.getAmpMultiplier() * (double)((Integer)this.STEP.get()).intValue());
        if (!this.triggered && entity.f_19789_ == 0.0f && this.previousDistance >= (float)distance && (result = caster.castSpell(entity.f_19853_, entity, InteractionHand.MAIN_HAND, (Component)Component.m_237115_((String)"ars_nouveau.spell.validation.crafting.invalid"), spell)).m_19089_() == InteractionResult.SUCCESS) {
            this.triggered = true;
        }
        if (this.triggered && entity.f_19789_ >= 0.0f) {
            this.previousDistance = entity.f_19789_;
            this.triggered = false;
        }
    }

    @Override
    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE});
    }
}

