/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsartifice.item;

import com.github.jarva.arsartifice.glyphs.AbstractArtificeMethod;
import com.github.jarva.arsartifice.glyphs.TickableArtificeMethod;
import com.hollingsworth.arsnouveau.api.item.ArsNouveauCurio;
import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class ArtificerCurio
extends ArsNouveauCurio
implements ICasterTool {
    public ISpellCaster getSpellCaster() {
        return new ArtificerCaster(new CompoundTag());
    }

    public ISpellCaster getSpellCaster(CompoundTag tag) {
        return new ArtificerCaster(tag);
    }

    @NotNull
    public ISpellCaster getSpellCaster(ItemStack stack) {
        return new ArtificerCaster(stack);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        AbstractArtificeMethod method;
        ISpellCaster caster = this.getSpellCaster(stack);
        Spell artifice = caster.getSpell(0);
        if (artifice.isEmpty()) {
            return;
        }
        Object e = artifice.recipe.get(0);
        if (e instanceof AbstractArtificeMethod && (method = (AbstractArtificeMethod)((Object)e)) instanceof TickableArtificeMethod) {
            TickableArtificeMethod tickable = (TickableArtificeMethod)((Object)method);
            LivingEntity entity = slotContext.entity();
            SpellStats stats = method.getSpellStats(caster, entity, artifice);
            tickable.tick(entity, stack, caster, stats, caster.getSpell(1));
        }
    }

    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level worldIn, List<Component> tooltip2, TooltipFlag flagIn) {
        Spell spell;
        if (worldIn == null) {
            return;
        }
        ISpellCaster caster = this.getSpellCaster(stack);
        Spell method = caster.getSpell(0);
        if (method.isValid()) {
            tooltip2.add((Component)Component.m_237113_((String)("Trigger: " + method.getDisplayString())));
        }
        if ((spell = caster.getSpell(1)).isValid()) {
            tooltip2.add((Component)Component.m_237113_((String)("Spell: " + spell.getDisplayString())));
        }
        super.m_7373_(stack, worldIn, tooltip2, flagIn);
    }

    public static class ArtificerCaster
    extends SpellCaster {
        public ArtificerCaster(ItemStack stack) {
            super(stack);
        }

        public ArtificerCaster(CompoundTag tag) {
            super(tag);
        }

        public int getMaxSlots() {
            return 2;
        }

        public int getCurrentSlot() {
            return 1;
        }

        public InteractionResultHolder<ItemStack> castSpell(Level worldIn, LivingEntity entity, InteractionHand handIn, @Nullable Component invalidMessage, @NotNull Spell spell) {
            spell.addDiscount(-spell.getNoDiscountCost());
            return super.castSpell(worldIn, entity, handIn, invalidMessage, spell);
        }
    }
}

