/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsartifice.validators;

import com.github.jarva.arsartifice.validators.ArtificeMethodSpellValidator;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.common.spell.validation.AugmentCompatibilityValidator;
import com.hollingsworth.arsnouveau.common.spell.validation.CombinedSpellValidator;
import com.hollingsworth.arsnouveau.common.spell.validation.GlyphOccurrencesPolicyValidator;
import com.hollingsworth.arsnouveau.common.spell.validation.InvalidCombinationValidator;
import java.util.LinkedList;
import java.util.List;

public class CombinedArtificeValidator
implements ISpellValidator {
    private static final ISpellValidator ARTIFICE_METHOD = new ArtificeMethodSpellValidator();
    private static final ISpellValidator GLYPH_OCCURRENCES_POLICY = new GlyphOccurrencesPolicyValidator();
    private static final ISpellValidator AUGMENT_COMPATIBILITY = new AugmentCompatibilityValidator();
    private static final ISpellValidator INVALID_COMBINATION_POLICY = new InvalidCombinationValidator();
    private final ISpellValidator combinedValidator;

    public CombinedArtificeValidator() {
        LinkedList<ISpellValidator> validators = new LinkedList<ISpellValidator>();
        validators.add(ARTIFICE_METHOD);
        validators.add(GLYPH_OCCURRENCES_POLICY);
        validators.add(AUGMENT_COMPATIBILITY);
        validators.add(INVALID_COMBINATION_POLICY);
        this.combinedValidator = new CombinedSpellValidator(validators);
    }

    public List<SpellValidationError> validate(List<AbstractSpellPart> list) {
        return this.combinedValidator.validate(list);
    }
}

