/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import dev.xkmc.l2library.base.NamedEntry;
import dev.xkmc.l2library.repack.registrate.AbstractRegistrate;
import dev.xkmc.l2library.repack.registrate.builders.AbstractBuilder;
import dev.xkmc.l2library.repack.registrate.builders.BuilderCallback;
import dev.xkmc.l2library.repack.registrate.providers.RegistrateLangProvider;
import dev.xkmc.l2library.repack.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.l2library.repack.registrate.util.nullness.NonnullType;
import dev.xkmc.l2library.serial.handler.RLClassHandler;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class L2Registrate
extends AbstractRegistrate<L2Registrate> {
    public L2Registrate(String modid) {
        super(modid);
        this.registerEventListeners(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public <T extends NamedEntry<T>, P extends T> GenericBuilder<T, P> generic(RegistryInstance<T> cls, String id, NonNullSupplier<P> sup) {
        return this.entry(id, cb -> new GenericBuilder(this, id, (BuilderCallback)cb, cls.key(), sup));
    }

    public <T extends Recipe<?>> RegistryObject<RecipeType<T>> recipe(DeferredRegister<RecipeType<?>> type, String id) {
        return type.register(id, () -> new RecipeType<T>(){});
    }

    public <E extends NamedEntry<E>> RegistryInstance<E> newRegistry(String id, Class<?> cls) {
        ResourceKey key = this.makeRegistry(id, () -> new RegistryBuilder().onCreate((r, s) -> new RLClassHandler(cls, () -> r)));
        return new RegistryInstance(Suppliers.memoize(() -> RegistryManager.ACTIVE.getRegistry(key)), key);
    }

    public <E extends NamedEntry<E>> RegistryInstance<E> newRegistry(String id, Class<?> cls, Consumer<RegistryBuilder<E>> cons) {
        ResourceKey key = this.makeRegistry(id, () -> {
            RegistryBuilder builder = new RegistryBuilder();
            cons.accept(builder);
            return builder.onCreate((r, s) -> new RLClassHandler(cls, () -> r));
        });
        return new RegistryInstance(Suppliers.memoize(() -> RegistryManager.ACTIVE.getRegistry(key)), key);
    }

    public <E extends NamedEntry<E>> RegistryInstance<E> newDatapackRegistry(String id, Class<E> cls, Codec<E> codec) {
        ResourceKey key = this.makeRegistry(id, () -> new RegistryBuilder().dataPackRegistry(codec).onCreate((r, s) -> new RLClassHandler(cls, () -> r)));
        return new RegistryInstance(Suppliers.memoize(() -> RegistryManager.ACTIVE.getRegistry(key)), key);
    }

    public <E extends NamedEntry<E>> RegistryInstance<E> newDatapackRegistry(String id, Class<E> cls, Supplier<E> sup) {
        return this.newDatapackRegistry(id, cls, Codec.unit(sup));
    }

    public record RegistryInstance<E extends NamedEntry<E>>(Supplier<IForgeRegistry<E>> supplier, ResourceKey<Registry<E>> key) implements Supplier<IForgeRegistry<E>>
    {
        @Override
        public IForgeRegistry<E> get() {
            return this.supplier().get();
        }
    }

    public static class GenericBuilder<T extends NamedEntry<T>, P extends T>
    extends AbstractBuilder<T, P, L2Registrate, GenericBuilder<T, P>> {
        private final NonNullSupplier<P> sup;

        GenericBuilder(L2Registrate parent, String name, BuilderCallback callback, ResourceKey<Registry<T>> registryType, NonNullSupplier<P> sup) {
            super(parent, parent, name, callback, registryType);
            this.sup = sup;
        }

        @Override
        @NonnullType
        @NotNull
        protected P createEntry() {
            return (P)((NamedEntry)this.sup.get());
        }

        public GenericBuilder<T, P> defaultLang() {
            return (GenericBuilder)this.lang(NamedEntry::getDescriptionId, RegistrateLangProvider.toEnglishName(this.getName()));
        }
    }
}

