/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.effects;

import dev.xkmc.l2library.base.effects.EffectToClient;
import dev.xkmc.l2library.init.L2Library;
import dev.xkmc.l2library.util.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EffectSyncEvents {
    public static final Map<UUID, Map<MobEffect, Integer>> EFFECT_MAP = new HashMap<UUID, Map<MobEffect, Integer>>();
    public static final Set<MobEffect> TRACKED = new HashSet<MobEffect>();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (Proxy.getClientPlayer() == null) {
            EFFECT_MAP.clear();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sync(EffectToClient eff) {
        Map<MobEffect, Integer> set = EFFECT_MAP.get(eff.entity);
        if (eff.exist) {
            if (set == null) {
                set = new HashMap<MobEffect, Integer>();
                EFFECT_MAP.put(eff.entity, set);
            }
            set.put(eff.effect, eff.level);
        } else if (set != null) {
            set.remove(eff.effect);
        }
    }

    @SubscribeEvent
    public static void onPotionAddedEvent(MobEffectEvent.Added event) {
        if (TRACKED.contains(event.getEffectInstance().m_19544_())) {
            EffectSyncEvents.onEffectAppear(event.getEffectInstance().m_19544_(), event.getEntity(), event.getEffectInstance().m_19564_());
        }
    }

    @SubscribeEvent
    public static void onPotionRemoveEvent(MobEffectEvent.Remove event) {
        if (event.getEffectInstance() != null && TRACKED.contains(event.getEffectInstance().m_19544_())) {
            EffectSyncEvents.onEffectDisappear(event.getEffectInstance().m_19544_(), event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPotionExpiryEvent(MobEffectEvent.Expired event) {
        if (event.getEffectInstance() != null && TRACKED.contains(event.getEffectInstance().m_19544_())) {
            EffectSyncEvents.onEffectDisappear(event.getEffectInstance().m_19544_(), event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)entity;
        for (MobEffect eff : le.m_21221_().keySet()) {
            if (!TRACKED.contains(eff)) continue;
            EffectSyncEvents.onEffectAppear(eff, le, ((MobEffectInstance)le.m_21221_().get(eff)).m_19564_());
        }
    }

    @SubscribeEvent
    public static void onPlayerStopTracking(PlayerEvent.StopTracking event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)entity;
        for (MobEffect eff : le.m_21221_().keySet()) {
            if (!TRACKED.contains(eff)) continue;
            EffectSyncEvents.onEffectDisappear(eff, le);
        }
    }

    @SubscribeEvent
    public static void onServerPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer e = (ServerPlayer)event.getEntity();
        if (e != null) {
            for (MobEffect eff : e.m_21221_().keySet()) {
                if (!TRACKED.contains(eff)) continue;
                EffectSyncEvents.onEffectAppear(eff, (LivingEntity)e, ((MobEffectInstance)e.m_21221_().get(eff)).m_19564_());
            }
        }
    }

    @SubscribeEvent
    public static void onServerPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer e = (ServerPlayer)event.getEntity();
        if (e != null) {
            for (MobEffect eff : e.m_21221_().keySet()) {
                if (!TRACKED.contains(eff)) continue;
                EffectSyncEvents.onEffectDisappear(eff, (LivingEntity)e);
            }
        }
    }

    private static void onEffectAppear(MobEffect eff, LivingEntity e, int lv) {
        if (e.f_19853_.m_5776_()) {
            return;
        }
        L2Library.PACKET_HANDLER.toTrackingPlayers(new EffectToClient(e.m_20148_(), eff, true, lv), (Entity)e);
    }

    private static void onEffectDisappear(MobEffect eff, LivingEntity e) {
        if (e.f_19853_.m_5776_()) {
            return;
        }
        L2Library.PACKET_HANDLER.toTrackingPlayers(new EffectToClient(e.m_20148_(), eff, false, 0), (Entity)e);
    }
}

