/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.menu;

import dev.xkmc.l2library.base.menu.PredSlot;
import dev.xkmc.l2library.base.menu.SlotLocked;
import dev.xkmc.l2library.base.menu.SpriteManager;
import dev.xkmc.l2library.util.code.Wrappers;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BaseContainerMenu<T extends BaseContainerMenu<T>>
extends AbstractContainerMenu {
    public final Inventory inventory;
    public final SimpleContainer container;
    public final SpriteManager sprite;
    protected int added = 0;
    protected final boolean isVirtual;
    private boolean updating = false;
    private final Map<SlotKey, Slot> slotMap = new TreeMap<SlotKey, Slot>(SlotKey.COMPARATOR);

    public static void clearSlot(Player pPlayer, Container pContainer, int index) {
        if (!pPlayer.m_6084_() || pPlayer instanceof ServerPlayer && ((ServerPlayer)pPlayer).m_9232_()) {
            pPlayer.m_36176_(pContainer.m_8016_(index), false);
        } else {
            Inventory inventory = pPlayer.m_150109_();
            if (inventory.f_35978_ instanceof ServerPlayer) {
                inventory.m_150079_(pContainer.m_8016_(index));
            }
        }
    }

    protected BaseContainerMenu(MenuType<?> type, int wid, Inventory plInv, SpriteManager manager, Function<T, SimpleContainer> factory, boolean isVirtual) {
        super(type, wid);
        this.inventory = plInv;
        this.container = factory.apply((BaseContainerMenu)((Object)Wrappers.cast(this)));
        this.sprite = manager;
        int x = manager.getPlInvX();
        int y = manager.getPlInvY();
        this.bindPlayerInventory(plInv, x, y);
        this.isVirtual = isVirtual;
    }

    protected void bindPlayerInventory(Inventory plInv, int x, int y) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(this.createSlot(plInv, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(this.createSlot(plInv, k, x + k * 18, y + 58));
        }
    }

    protected Slot createSlot(Inventory inv, int slot, int x, int y) {
        return this.shouldLock(inv, slot) ? new SlotLocked(inv, slot, x, y) : new Slot((Container)inv, slot, x, y);
    }

    protected boolean shouldLock(Inventory inv, int slot) {
        return false;
    }

    protected void addSlot(String name, Predicate<ItemStack> pred) {
        this.sprite.getSlot(name, (x, y) -> new PredSlot((Container)this.container, this.added++, x, y, pred), this::addSlot);
    }

    protected void addSlot(String name, BiPredicate<Integer, ItemStack> pred) {
        int current = this.added;
        this.sprite.getSlot(name, (x, y) -> {
            PredSlot ans = new PredSlot((Container)this.container, this.added, x, y, e -> pred.test(this.added - current, (ItemStack)e));
            ++this.added;
            return ans;
        }, this::addSlot);
    }

    protected void addSlot(String name, Predicate<ItemStack> pred, Consumer<PredSlot> modifier) {
        this.sprite.getSlot(name, (x, y) -> {
            PredSlot s = new PredSlot((Container)this.container, this.added++, x, y, pred);
            modifier.accept(s);
            return s;
        }, this::addSlot);
    }

    protected void addSlot(String name, BiPredicate<Integer, ItemStack> pred, BiConsumer<Integer, PredSlot> modifier) {
        int current = this.added;
        this.sprite.getSlot(name, (x, y) -> {
            int i = this.added - current;
            PredSlot ans = new PredSlot((Container)this.container, this.added, x, y, e -> pred.test(i, (ItemStack)e));
            modifier.accept(i, ans);
            ++this.added;
            return ans;
        }, this::addSlot);
    }

    protected void addSlot(String name, int i, int j, Slot slot) {
        this.slotMap.put(new SlotKey(name, i, j), slot);
        this.m_38897_(slot);
    }

    protected Slot getSlot(String name, int i, int j) {
        return this.slotMap.get(new SlotKey(name, i, j));
    }

    protected PredSlot getAsPredSlot(String name, int i, int j) {
        return (PredSlot)this.getSlot(name, i, j);
    }

    protected PredSlot getAsPredSlot(String name) {
        return (PredSlot)this.getSlot(name, 0, 0);
    }

    public ItemStack m_7648_(Player pl, int id) {
        ItemStack stack = ((Slot)this.f_38839_.get(id)).m_7993_();
        int n = this.container.m_6643_();
        if (id >= 36) {
            this.m_38903_(stack, 0, 36, true);
        } else {
            this.m_38903_(stack, 36, 36 + n, false);
        }
        this.container.m_6596_();
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return player.m_6084_();
    }

    public void m_6877_(Player player) {
        if (this.isVirtual && !player.f_19853_.m_5776_()) {
            this.clearContainerFiltered(player, (Container)this.container);
        }
        super.m_6877_(player);
    }

    protected boolean shouldClear(Container container, int slot) {
        return this.isVirtual;
    }

    protected void clearContainerFiltered(Player player, Container container) {
        if (!player.m_6084_() || player instanceof ServerPlayer && ((ServerPlayer)player).m_9232_()) {
            for (int j = 0; j < container.m_6643_(); ++j) {
                if (!this.shouldClear(container, j)) continue;
                player.m_36176_(container.m_8016_(j), false);
            }
        } else {
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < container.m_6643_(); ++i) {
                if (!this.shouldClear(container, i) || !(inventory.f_35978_ instanceof ServerPlayer)) continue;
                inventory.m_150079_(container.m_8016_(i));
            }
        }
    }

    public void m_6199_(Container cont) {
        if (this.inventory.f_35978_.f_19853_.m_5776_()) {
            super.m_6199_(cont);
        } else {
            if (!this.updating) {
                this.updating = true;
                this.securedServerSlotChange(cont);
                this.updating = false;
            }
            super.m_6199_(cont);
        }
    }

    protected void securedServerSlotChange(Container cont) {
    }

    private record SlotKey(String name, int i, int j) {
        private static final Comparator<SlotKey> COMPARATOR;

        static {
            Comparator<SlotKey> comp = Comparator.comparing(SlotKey::name);
            comp = comp.thenComparingInt(SlotKey::i);
            comp = comp.thenComparingInt(SlotKey::j);
            COMPARATOR = comp;
        }
    }

    public static class BaseContainer<T extends BaseContainerMenu<T>>
    extends SimpleContainer {
        protected final T parent;
        private boolean updating = false;

        public BaseContainer(int size, T menu) {
            super(size);
            this.parent = menu;
        }

        public void m_6596_() {
            super.m_6596_();
            if (!this.updating) {
                this.updating = true;
                ((BaseContainerMenu)((Object)this.parent)).m_6199_((Container)this);
                this.updating = false;
            }
        }
    }
}

