/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.menu;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.xkmc.l2library.serial.SerialClass;
import dev.xkmc.l2library.serial.codec.JsonCodec;
import dev.xkmc.l2library.util.code.Wrappers;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class SpriteManager {
    public static final TreeMap<ResourceLocation, JsonElement> CACHE = new TreeMap();
    private final String name;
    private final ResourceLocation coords;
    private final ResourceLocation texture;
    @SerialClass.SerialField
    public int height;
    @SerialClass.SerialField
    public HashMap<String, Rect> side;
    @SerialClass.SerialField
    public HashMap<String, Rect> comp;
    private boolean loaded = false;

    public SpriteManager(String mod, String str) {
        this.name = mod + ":" + str;
        this.coords = new ResourceLocation(mod, str);
        this.texture = new ResourceLocation(mod, "textures/gui/container/" + str + ".png");
        this.check();
    }

    public Rect getComp(String key) {
        this.check();
        return this.comp.getOrDefault(key, Rect.ZERO);
    }

    public int getHeight() {
        this.check();
        return this.height;
    }

    public int getPlInvX() {
        this.check();
        return 8;
    }

    public int getPlInvY() {
        this.check();
        return this.height - 82;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenRenderer getRenderer(AbstractContainerScreen<?> gui) {
        this.check();
        return new ScreenRenderer(gui);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenRenderer getRenderer(Screen gui, int x, int y, int w, int h) {
        this.check();
        return new ScreenRenderer(gui, x, y, w, h);
    }

    public Rect getSide(String key) {
        this.check();
        return this.side.getOrDefault(key, Rect.ZERO);
    }

    public <T extends Slot> void getSlot(String key, SlotFactory<T> fac, SlotAcceptor con) {
        this.check();
        Rect c = this.getComp(key);
        for (int j = 0; j < c.ry; ++j) {
            for (int i = 0; i < c.rx; ++i) {
                T slot = fac.getSlot(c.x + i * c.w, c.y + j * c.h);
                if (slot == null) continue;
                con.addSlot(key, i, j, (Slot)slot);
            }
        }
    }

    public int getWidth() {
        this.check();
        return 176;
    }

    public String toString() {
        return this.name;
    }

    public boolean within(String key, double x, double y) {
        this.check();
        Rect c = this.getComp(key);
        return x > (double)c.x && x < (double)(c.x + c.w) && y > (double)c.y && y < (double)(c.y + c.h);
    }

    private void check() {
        if (!this.loaded) {
            this.load();
        }
    }

    private void load() {
        JsonObject jo = (JsonObject)DistExecutor.unsafeRunForDist(() -> () -> Wrappers.get(() -> GsonHelper.m_13859_((Reader)new InputStreamReader(((Resource)Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation(this.coords.m_135827_(), "textures/gui/coords/" + this.coords.m_135815_() + ".json")).get()).m_215507_())).getAsJsonObject()), () -> () -> CACHE.get(this.coords).getAsJsonObject());
        JsonCodec.from((JsonElement)jo, SpriteManager.class, this);
        this.loaded = true;
    }

    @SerialClass
    public static class Rect {
        public static final Rect ZERO = new Rect();
        @SerialClass.SerialField
        public int x;
        @SerialClass.SerialField
        public int y;
        @SerialClass.SerialField
        public int w;
        @SerialClass.SerialField
        public int h;
        @SerialClass.SerialField
        public int rx = 1;
        @SerialClass.SerialField
        public int ry = 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ScreenRenderer {
        private final int x;
        private final int y;
        private final int w;
        private final int h;
        private final Screen scr;

        public ScreenRenderer(Screen gui, int x, int y, int w, int h) {
            this.scr = gui;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        private ScreenRenderer(AbstractContainerScreen<?> scrIn) {
            this.x = scrIn.getGuiLeft();
            this.y = scrIn.getGuiTop();
            this.w = scrIn.getXSize();
            this.h = scrIn.getYSize();
            this.scr = scrIn;
        }

        public void draw(PoseStack mat, String c, String s) {
            Rect cr = SpriteManager.this.getComp(c);
            Rect sr = SpriteManager.this.getSide(s);
            this.scr.m_93228_(mat, this.x + cr.x, this.y + cr.y, sr.x, sr.y, sr.w, sr.h);
        }

        public void draw(PoseStack mat, String c, String s, int xoff, int yoff) {
            Rect cr = SpriteManager.this.getComp(c);
            Rect sr = SpriteManager.this.getSide(s);
            this.scr.m_93228_(mat, this.x + cr.x + xoff, this.y + cr.y + yoff, sr.x, sr.y, sr.w, sr.h);
        }

        public void drawBottomUp(PoseStack mat, String c, String s, int prog, int max) {
            if (prog == 0 || max == 0) {
                return;
            }
            Rect cr = SpriteManager.this.getComp(c);
            Rect sr = SpriteManager.this.getSide(s);
            int dh = sr.h * prog / max;
            this.scr.m_93228_(mat, this.x + cr.x, this.y + cr.y + sr.h - dh, sr.x, sr.y + sr.h - dh, sr.w, dh);
        }

        public void drawLeftRight(PoseStack mat, String c, String s, int prog, int max) {
            if (prog == 0 || max == 0) {
                return;
            }
            Rect cr = SpriteManager.this.getComp(c);
            Rect sr = SpriteManager.this.getSide(s);
            int dw = sr.w * prog / max;
            this.scr.m_93228_(mat, this.x + cr.x, this.y + cr.y, sr.x, sr.y, dw, sr.h);
        }

        public void drawLiquid(PoseStack mat, String c, double per, int height, int sw, int sh) {
            Rect cr = SpriteManager.this.getComp(c);
            int base = cr.y + height;
            int h = (int)Math.round(per * (double)height);
            this.circularBlit(mat, this.x + cr.x, base - h, 0, -h, cr.w, h, sw, sh);
        }

        public void start(PoseStack mat) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.scr.m_7333_(mat);
            RenderSystem.m_157456_((int)0, (ResourceLocation)SpriteManager.this.texture);
            this.scr.m_93228_(mat, this.x, this.y, 0, 0, this.w, this.h);
        }

        private void circularBlit(PoseStack mat, int sx, int sy, int ix, int iy, int w, int h, int iw, int ih) {
            int x0;
            int yb = iy;
            int x1 = w;
            int x2 = sx;
            for (x0 = ix; x0 < 0; x0 += iw) {
            }
            while (yb < ih) {
                yb += ih;
            }
            while (x1 > 0) {
                int dx = Math.min(x1, iw - x0);
                int y0 = yb;
                int y1 = h;
                int y2 = sy;
                while (y1 > 0) {
                    int dy = Math.min(y1, ih - y0);
                    this.scr.m_93228_(mat, x2, y2, x0, y0, x1, y1);
                    y1 -= dy;
                    y0 += dy;
                    y2 += dy;
                }
                x1 -= dx;
                x0 += dx;
                x2 += dx;
            }
        }
    }

    public static interface SlotFactory<T extends Slot> {
        @Nullable
        public T getSlot(int var1, int var2);
    }

    public static interface SlotAcceptor {
        public void addSlot(String var1, int var2, int var3, Slot var4);
    }
}

