/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import dev.xkmc.l2library.init.L2LibraryConfig;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class OverlayUtils
extends GuiComponent {
    public final int screenWidth;
    public final int screenHeight;
    public int bg = OverlayUtils.getBGColor();
    public int bs = 0x505000FF;
    public int be = 1344798847;
    public int tc = -1;

    private static int getBGColor() {
        return (int)Math.round((Double)L2LibraryConfig.CLIENT.infoAlpha.get() * 255.0) << 24 | 0x100010;
    }

    public OverlayUtils(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public int getX(int w) {
        return Math.round((float)this.screenWidth / 8.0f);
    }

    public int getY(int h) {
        return Math.round((float)(this.screenHeight - h) / 2.0f);
    }

    public int getMaxWidth() {
        return this.screenWidth / 4;
    }

    public void renderLongText(ForgeGui gui, PoseStack stack, int x0, int y0, int maxWidth, List<Component> list) {
        Font font = gui.m_93082_();
        int tooltipTextWidth = list.stream().mapToInt(arg_0 -> ((Font)font).m_92852_(arg_0)).max().orElse(0);
        if (maxWidth < 0) {
            maxWidth = this.getMaxWidth();
        }
        int finalMaxWidth = maxWidth;
        List ans = list.stream().flatMap(text -> font.m_92923_((FormattedText)text, finalMaxWidth).stream()).toList();
        int h = ans.size() * 12 - 2;
        int w = Math.min(tooltipTextWidth, maxWidth);
        if (x0 < 0) {
            x0 = this.getX(w);
        }
        if (y0 < 0) {
            y0 = this.getY(h);
        }
        int y1 = y0;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = stack.m_85850_().m_85861_();
        OverlayUtils.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(x0 - 3), (int)(y1 - 4), (int)(x0 + w + 3), (int)(y1 - 3), (int)400, (int)this.bg, (int)this.bg);
        OverlayUtils.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(x0 - 3), (int)(y1 + h + 3), (int)(x0 + w + 3), (int)(y1 + h + 4), (int)400, (int)this.bg, (int)this.bg);
        OverlayUtils.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(x0 - 3), (int)(y1 - 3), (int)(x0 + w + 3), (int)(y1 + h + 3), (int)400, (int)this.bg, (int)this.bg);
        OverlayUtils.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(x0 - 4), (int)(y1 - 3), (int)(x0 - 3), (int)(y1 + h + 3), (int)400, (int)this.bg, (int)this.bg);
        OverlayUtils.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(x0 + w + 3), (int)(y1 - 3), (int)(x0 + w + 4), (int)(y1 + h + 3), (int)400, (int)this.bg, (int)this.bg);
        OverlayUtils.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(x0 - 3), (int)(y1 - 3 + 1), (int)(x0 - 3 + 1), (int)(y1 + h + 3 - 1), (int)400, (int)this.bs, (int)this.be);
        OverlayUtils.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(x0 + w + 2), (int)(y1 - 3 + 1), (int)(x0 + w + 3), (int)(y1 + h + 3 - 1), (int)400, (int)this.bs, (int)this.be);
        OverlayUtils.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(x0 - 3), (int)(y1 - 3), (int)(x0 + w + 3), (int)(y1 - 3 + 1), (int)400, (int)this.bs, (int)this.bs);
        OverlayUtils.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(x0 - 3), (int)(y1 + h + 2), (int)(x0 + w + 3), (int)(y1 + h + 3), (int)400, (int)this.be, (int)this.be);
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69465_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.m_69493_();
        for (FormattedCharSequence text2 : ans) {
            font.m_92877_(stack, text2, (float)x0, (float)y0, this.tc);
            y0 += 12;
        }
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
    }

    public void renderLongText(ForgeGui gui, PoseStack stack, List<Component> list) {
        this.renderLongText(gui, stack, -1, -1, -1, list);
    }

    public static void drawRect(BufferBuilder builder, int x, int y, int w, int h, int r, int g, int b, int a) {
        OverlayUtils.fillRect(builder, x - 1, y - 1, w + 2, 1, r, g, b, a);
        OverlayUtils.fillRect(builder, x - 1, y - 1, 1, h + 2, r, g, b, a);
        OverlayUtils.fillRect(builder, x - 1, y + h, w + 2, 1, r, g, b, a);
        OverlayUtils.fillRect(builder, x + w, y - 1, 1, h + 2, r, g, b, a);
    }

    public static void fillRect(BufferBuilder builder, int x, int y, int w, int h, int r, int g, int b, int a) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_5483_((double)x, (double)y, 0.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_((double)x, (double)(y + h), 0.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_((double)(x + w), (double)(y + h), 0.0).m_6122_(r, g, b, a).m_5752_();
        builder.m_5483_((double)(x + w), (double)y, 0.0).m_6122_(r, g, b, a).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }
}

