/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.xkmc.l2library.serial.codec.JsonCodec;
import dev.xkmc.l2library.serial.codec.PacketCodec;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.UpgradeRecipe;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class AbstractSmithingRecipe<T extends AbstractSmithingRecipe<T>>
extends UpgradeRecipe {
    public AbstractSmithingRecipe(ResourceLocation rl, Ingredient left, Ingredient right, ItemStack result) {
        super(rl, left, right, result);
    }

    public abstract Serializer<T> getSerializer();

    public static class Serializer<T extends AbstractSmithingRecipe<T>>
    extends UpgradeRecipe.Serializer {
        private final RecipeFactory<T> factory;

        public Serializer(RecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject obj) {
            UpgradeRecipe r = super.m_6729_(id, obj);
            return this.factory.create(r.m_6423_(), r.f_44518_, r.f_44519_, r.m_8043_());
        }

        public T fromNetwork(ResourceLocation id, FriendlyByteBuf obj) {
            UpgradeRecipe r = super.m_8005_(id, obj);
            if (r == null) {
                return null;
            }
            return this.factory.create(r.m_6423_(), r.f_44518_, r.f_44519_, r.m_8043_());
        }

        public void toJson(T recipe, JsonObject obj) {
        }
    }

    public static class SerialSerializer<T extends AbstractSmithingRecipe<T>>
    extends Serializer<T> {
        private final Class<T> cls;

        public SerialSerializer(Class<T> cls, RecipeFactory<T> factory) {
            super(factory);
            this.cls = cls;
        }

        @Override
        public T fromJson(ResourceLocation id, JsonObject obj) {
            return (T)((Object)Objects.requireNonNull((AbstractSmithingRecipe)((Object)JsonCodec.from((JsonElement)obj, this.cls, super.fromJson(id, obj)))));
        }

        public void m_6178_(FriendlyByteBuf buf, UpgradeRecipe rec) {
            super.m_6178_(buf, rec);
            PacketCodec.to(buf, rec);
        }

        @Override
        public T fromNetwork(ResourceLocation id, FriendlyByteBuf obj) {
            return (T)((Object)((AbstractSmithingRecipe)((Object)PacketCodec.from(obj, this.cls, super.fromNetwork(id, obj)))));
        }

        @Override
        public void toJson(T recipe, JsonObject obj) {
            JsonCodec.toJsonObject(recipe, obj);
        }
    }

    @FunctionalInterface
    public static interface RecipeFactory<T extends AbstractSmithingRecipe<T>> {
        public T create(ResourceLocation var1, Ingredient var2, Ingredient var3, ItemStack var4);
    }
}

