/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.tabs.core;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.xkmc.l2library.base.tabs.contents.BaseTextScreen;
import dev.xkmc.l2library.base.tabs.core.BaseTab;
import dev.xkmc.l2library.base.tabs.core.TabRegistry;
import dev.xkmc.l2library.base.tabs.core.TabToken;
import dev.xkmc.l2library.init.L2LibraryConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;

public class TabManager {
    private final List<BaseTab<?>> list = new ArrayList();
    private final Screen screen;
    public int tabPage;
    public int maxPages;
    public TabToken<?> selected;

    public TabManager(Screen screen) {
        this.screen = screen;
    }

    public void init(Consumer<AbstractWidget> adder, TabToken<?> selected) {
        int guiTop;
        int guiLeft;
        this.list.clear();
        if (!((Boolean)L2LibraryConfig.CLIENT.showTabs.get()).booleanValue()) {
            return;
        }
        this.selected = selected;
        Screen screen = this.screen;
        if (screen instanceof BaseTextScreen) {
            BaseTextScreen tx = (BaseTextScreen)screen;
            guiLeft = tx.leftPos;
            guiTop = tx.topPos;
        } else {
            screen = this.screen;
            if (screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen tx = (AbstractContainerScreen)screen;
                guiLeft = tx.getGuiLeft();
                guiTop = tx.getGuiTop();
            } else {
                guiLeft = (this.screen.f_96543_ - 176) / 2;
                guiTop = (this.screen.f_96544_ - 166) / 2;
            }
        }
        guiLeft -= 56;
        for (TabToken<?> token : TabRegistry.getTabs()) {
            Object tab = token.create(this);
            ((BaseTab)((Object)tab)).f_93620_ = guiLeft + (token.index + 2) * 28;
            ((BaseTab)((Object)tab)).f_93621_ = guiTop - 28;
            adder.accept((AbstractWidget)tab);
            this.list.add((BaseTab<?>)((Object)tab));
        }
        if (TabRegistry.getTabs().size() > 8) {
            adder.accept((AbstractWidget)new Button(guiLeft, guiTop - 50, 20, 20, (Component)Component.m_237113_((String)"<"), b -> {
                this.tabPage = Math.max(this.tabPage - 1, 0);
                this.updateVisibility();
            }));
            adder.accept((AbstractWidget)new Button(guiLeft + 252 - 20, guiTop - 50, 20, 20, (Component)Component.m_237113_((String)">"), b -> {
                this.tabPage = Math.min(this.tabPage + 1, this.maxPages);
                this.updateVisibility();
            }));
            this.maxPages = TabRegistry.getTabs().size() / 8;
        }
        this.updateVisibility();
    }

    private void updateVisibility() {
        for (BaseTab<?> tab : this.list) {
            tab.f_93623_ = tab.f_93624_ = tab.token.index >= this.tabPage * 8 && tab.token.index < (this.tabPage + 1) * 8;
        }
    }

    public Screen getScreen() {
        return this.screen;
    }

    public void onToolTipRender(PoseStack stack, int mouseX, int mouseY) {
        for (BaseTab<?> tab : this.list) {
            if (!tab.f_93624_ || !tab.m_198029_()) continue;
            tab.onTooltip(stack, mouseX, mouseY);
        }
    }
}

