/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.block;

import dev.xkmc.l2library.block.type.BlockMethod;
import dev.xkmc.l2library.block.type.MultipleBlockMethod;
import dev.xkmc.l2library.block.type.SingletonBlockMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class BlockImplementor {
    final BlockBehaviour.Properties props;
    private final List<MultipleBlockMethod> list = new ArrayList<MultipleBlockMethod>();
    private final HashMap<Class<?>, SingletonBlockMethod> map = new HashMap();

    public BlockImplementor(BlockBehaviour.Properties p) {
        this.props = p;
    }

    public BlockImplementor addImpls(BlockMethod ... impls) {
        for (BlockMethod impl : impls) {
            if (impl instanceof MultipleBlockMethod) {
                this.list.add((MultipleBlockMethod)impl);
            }
            if (!(impl instanceof SingletonBlockMethod)) continue;
            SingletonBlockMethod one = (SingletonBlockMethod)impl;
            ArrayList list = new ArrayList();
            this.addOneImpl(one.getClass(), list);
            for (Class clazz : list) {
                if (this.map.containsKey(clazz)) {
                    throw new RuntimeException("class " + clazz + " is implemented twice with " + this.map.get(clazz) + " and " + impl);
                }
                this.map.put(clazz, one);
            }
        }
        return this;
    }

    private void addOneImpl(Class<?> cls, List<Class<?>> list) {
        Class<?> sup = cls.getSuperclass();
        if (sup != null && SingletonBlockMethod.class.isAssignableFrom(sup)) {
            this.addOneImpl(sup, list);
        }
        for (Class<?> ci : cls.getInterfaces()) {
            if (ci == SingletonBlockMethod.class) {
                throw new RuntimeException("class " + cls + " should not implement IOneImpl directly");
            }
            if (!SingletonBlockMethod.class.isAssignableFrom(ci)) continue;
            Class<?>[] arr = ci.getInterfaces();
            if (arr.length == 1 && arr[0] == SingletonBlockMethod.class) {
                list.add(ci);
                continue;
            }
            this.addOneImpl(ci, list);
        }
    }

    @Deprecated
    public <T extends MultipleBlockMethod> Stream<T> execute(Class<T> cls) {
        return this.list.stream().filter(cls::isInstance).map(e -> e);
    }

    public <T extends MultipleBlockMethod> void forEach(Class<T> cls, Consumer<T> cons) {
        for (MultipleBlockMethod method : this.list) {
            if (!cls.isInstance(method)) continue;
            cons.accept(method);
        }
    }

    public <T extends MultipleBlockMethod, U> U reduce(Class<T> cls, U init, BiFunction<U, T, U> func) {
        for (MultipleBlockMethod method : this.list) {
            if (!cls.isInstance(method)) continue;
            init = func.apply((MultipleBlockMethod)init, (U)method);
        }
        return init;
    }

    public <T extends SingletonBlockMethod> Optional<T> one(Class<T> cls) {
        return Optional.ofNullable(this.map.get(cls));
    }
}

