/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.compat.curio;

import dev.xkmc.l2library.base.menu.BaseContainerMenu;
import dev.xkmc.l2library.base.menu.SpriteManager;
import dev.xkmc.l2library.compat.curio.BaseCuriosWrapper;
import dev.xkmc.l2library.compat.curio.CuriosEventHandler;
import dev.xkmc.l2library.compat.curio.CuriosSlotWrapper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public abstract class BaseCuriosListMenu<T extends BaseContainerMenu<T>>
extends BaseContainerMenu<T> {
    public static final SpriteManager[] MANAGER = new SpriteManager[4];
    public final BaseCuriosWrapper curios;

    private static SpriteManager getManager(int size) {
        return MANAGER[Math.min(Math.max(size - 3, 0), 3)];
    }

    protected BaseCuriosListMenu(MenuType<?> type, int wid, Inventory plInv, BaseCuriosWrapper curios) {
        super(type, wid, plInv, BaseCuriosListMenu.getManager(curios.getRows()), e -> new BaseContainerMenu.BaseContainer<BaseContainerMenu>(curios.getSize(), (BaseContainerMenu)((Object)e)), false);
        this.addCurioSlot("grid", curios);
        this.curios = curios;
    }

    protected void addCurioSlot(String name, BaseCuriosWrapper curios) {
        int current = this.added;
        int[] removed = new int[]{0};
        this.sprite.getSlot(name, (x, y) -> {
            int i = this.added - current;
            CuriosSlotWrapper slot = curios.getSlotAtPosition(i + removed[0]);
            if (slot == null) {
                removed[0] = removed[0] + 1;
                return null;
            }
            Slot ans = slot.toSlot(x, y);
            ++this.added;
            return ans;
        }, (x$0, x$1, x$2, x$3) -> this.addSlot(x$0, x$1, x$2, x$3));
    }

    private boolean checkSwitch(Player player, int page) {
        if (page >= 0 && page < this.curios.total) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                CuriosEventHandler.openMenuWrapped(sp, () -> this.switchPage(sp, page));
            } else {
                this.f_38839_.clear();
            }
            return true;
        }
        return false;
    }

    public abstract void switchPage(ServerPlayer var1, int var2);

    public boolean m_6366_(Player player, int btn) {
        if (btn == 1) {
            return this.checkSwitch(player, this.curios.page - 1);
        }
        if (btn == 2) {
            return this.checkSwitch(player, this.curios.page + 1);
        }
        return super.m_6366_(player, btn);
    }

    static {
        for (int i = 0; i < 4; ++i) {
            BaseCuriosListMenu.MANAGER[i] = new SpriteManager("l2library", "curios_" + (i + 3));
        }
    }
}

