/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.compat.curio;

import javax.annotation.Nonnull;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.CurioEquipEvent;
import top.theillusivec4.curios.api.event.CurioUnequipEvent;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.CurioSlot;

public class TabCurioSlot
extends CurioSlot {
    private final String identifier;
    private final LivingEntity player;
    private final SlotContext slotContext;
    private final NonNullList<Boolean> renderStatuses;
    private final boolean canToggleRender;
    private final IDynamicStackHandler handler;
    private final int index;

    public TabCurioSlot(LivingEntity player, IDynamicStackHandler handler, int index, String identifier, int xPosition, int yPosition, NonNullList<Boolean> renders, boolean canToggleRender) {
        super(player instanceof Player ? (pl = (Player)player) : null, handler, index, identifier, xPosition, yPosition, renders);
        Player pl;
        this.identifier = identifier;
        this.renderStatuses = renders;
        this.player = player;
        this.canToggleRender = canToggleRender;
        this.slotContext = new SlotContext(identifier, player, index, false, ((Boolean)renders.get(index)).booleanValue());
        this.setBackground(InventoryMenu.f_39692_, player.m_20193_().m_5776_() ? CuriosApi.getIconHelper().getIcon(identifier) : new ResourceLocation("curios", "slot/empty_curio_slot"));
        this.handler = handler;
        this.index = index;
    }

    public boolean isValid() {
        return this.handler.getSlots() > this.index;
    }

    @NotNull
    public ItemStack m_7993_() {
        if (!this.isValid()) {
            return ItemStack.f_41583_;
        }
        return super.m_7993_();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean getRenderStatus() {
        return this.renderStatuses.size() > this.getSlotIndex() && (Boolean)this.renderStatuses.get(this.getSlotIndex()) != false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getSlotName() {
        return I18n.m_118938_((String)("curios.identifier." + this.identifier), (Object[])new Object[0]);
    }

    public boolean m_5857_(@Nonnull ItemStack stack) {
        if (!this.isValid()) {
            return false;
        }
        CurioEquipEvent equipEvent = new CurioEquipEvent(stack, this.slotContext);
        MinecraftForge.EVENT_BUS.post((Event)equipEvent);
        Event.Result result = equipEvent.getResult();
        if (result == Event.Result.DENY) {
            return false;
        }
        return result == Event.Result.ALLOW || CuriosApi.getCuriosHelper().isStackValid(this.slotContext, stack) && CuriosApi.getCuriosHelper().getCurio(stack).map(curio -> curio.canEquip(this.slotContext)).orElse(true) != false && super.m_5857_(stack);
    }

    public boolean m_8010_(Player playerIn) {
        if (!this.isValid()) {
            return false;
        }
        ItemStack stack = this.m_7993_();
        CurioUnequipEvent unequipEvent = new CurioUnequipEvent(stack, this.slotContext);
        MinecraftForge.EVENT_BUS.post((Event)unequipEvent);
        Event.Result result = unequipEvent.getResult();
        if (result == Event.Result.DENY) {
            return false;
        }
        return result == Event.Result.ALLOW || (stack.m_41619_() || playerIn.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)stack)) && CuriosApi.getCuriosHelper().getCurio(stack).map(curio -> curio.canUnequip(this.slotContext)).orElse(true) != false && super.m_8010_(playerIn);
    }
}

