/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.compat.patchouli;

import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.base.recipe.ConditionalRecipeWrapper;
import dev.xkmc.l2library.compat.patchouli.PatchouliProvider;
import dev.xkmc.l2library.compat.patchouli.ShapedPatchouliBuilder;
import dev.xkmc.l2library.compat.patchouli.ShapelessPatchouliBuilder;
import dev.xkmc.l2library.repack.registrate.AbstractRegistrate;
import dev.xkmc.l2library.repack.registrate.providers.ProviderType;
import dev.xkmc.l2library.repack.registrate.providers.RegistrateRecipeProvider;
import dev.xkmc.l2library.repack.registrate.util.DataIngredient;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.item.PatchouliItems;

public class PatchouliHelper {
    public static final ProviderType<PatchouliProvider> PATCHOULI = ProviderType.register("patchouli", (p, e) -> new PatchouliProvider((AbstractRegistrate<?>)p, e.getGenerator()));
    private final L2Registrate reg;
    private final ResourceLocation book;
    private ResourceLocation model;

    public static ItemStack getBook(ResourceLocation book) {
        return ItemModBook.forBook((ResourceLocation)book);
    }

    public static LootTable.Builder getBookLoot(ResourceLocation book) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("patchouli:book", book.toString());
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)PatchouliItems.BOOK).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)tag))));
    }

    public PatchouliHelper(L2Registrate reg, String name) {
        this.reg = reg;
        this.book = new ResourceLocation(reg.getModid(), name);
    }

    public PatchouliHelper buildModel() {
        return this.buildModel("book");
    }

    public PatchouliHelper buildModel(String path) {
        this.model = new ResourceLocation(this.reg.getModid(), path);
        this.reg.addDataGenerator(ProviderType.ITEM_MODEL, pvd -> ((ItemModelBuilder)((ItemModelBuilder)pvd.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", "item/" + path));
        return this;
    }

    public PatchouliHelper buildShapelessRecipe(Consumer<ShapelessPatchouliBuilder> cons, Supplier<Item> unlock) {
        return this.buildRecipe(() -> (RecipeBuilder)Util.m_137469_((Object)((Object)new ShapelessPatchouliBuilder(this.book)), (Consumer)cons), unlock);
    }

    public PatchouliHelper buildShapedRecipe(Consumer<ShapedPatchouliBuilder> cons, Supplier<Item> unlock) {
        return this.buildRecipe(() -> (RecipeBuilder)Util.m_137469_((Object)((Object)new ShapedPatchouliBuilder(this.book)), (Consumer)cons), unlock);
    }

    private PatchouliHelper buildRecipe(Supplier<RecipeBuilder> cons, Supplier<Item> unlock) {
        this.reg.addDataGenerator(ProviderType.RECIPE, pvd -> {
            RecipeBuilder builder = (RecipeBuilder)cons.get();
            builder.m_126132_("has_" + pvd.safeName((ItemLike)unlock.get()), (CriterionTriggerInstance)DataIngredient.items((ItemLike)((Item)unlock.get()), (ItemLike[])new Item[0]).getCritereon((RegistrateRecipeProvider)pvd));
            builder.m_126140_(ConditionalRecipeWrapper.mod(pvd, "patchouli"), new ResourceLocation(this.reg.getModid(), "book"));
        });
        return this;
    }

    public PatchouliHelper buildBook(String title, String landing, int ver, ResourceKey<CreativeModeTab> tab) {
        if (this.model == null) {
            throw new IllegalStateException("Patchouli Book must have a model first");
        }
        String titleId = "patchouli." + this.reg.getModid() + ".title";
        String descId = "patchouli." + this.reg.getModid() + ".landing";
        this.reg.addRawLang(titleId, title);
        this.reg.addRawLang(descId, landing);
        this.reg.addDataGenerator(PATCHOULI, pvd -> pvd.accept(this.reg.getModid() + "/patchouli_books/" + this.book.m_135815_() + "/book", new BookEntry(titleId, descId, ver, this.model, tab.m_135782_(), true)));
        return this;
    }

    public record BookEntry(String name, String landing_text, int version, ResourceLocation model, ResourceLocation creative_tab, boolean use_resource_pack) {
    }
}

