/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.infmaze.init;

import dev.xkmc.l2library.idea.infmaze.dim3d.MazeCell3D;
import dev.xkmc.l2library.idea.infmaze.pos.BasePos;

public class CellLoaderChain {
    private final MazeCell3D[] list;
    private final int end;
    private final BasePos pos;

    public CellLoaderChain(MazeCell3D root, BasePos pos) {
        this.end = root.pos.scale();
        this.pos = pos;
        this.list = new MazeCell3D[this.end + 1];
        this.list[this.end] = root;
    }

    public MazeCell3D load() {
        for (int s = this.end; s >= 0; --s) {
            if (this.list[s] == null) {
                int index = CellLoaderChain.locate(this.pos, s);
                this.list[s] = this.list[s + 1].loadChild(index);
            }
            if (!this.list[s].isLeaf()) continue;
            return this.list[s];
        }
        return this.list[0];
    }

    private static int locate(BasePos pos, int scale) {
        long x = pos.x() >> scale & 1L;
        long y = pos.y() >> scale & 1L;
        long z = pos.z() >> scale & 1L;
        return (int)(x | y << 1 | z << 2);
    }
}

