/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.infmaze.init;

import dev.xkmc.l2library.idea.infmaze.dim3d.GenerationHelper;
import dev.xkmc.l2library.idea.infmaze.dim3d.MazeCell3D;
import dev.xkmc.l2library.idea.infmaze.dim3d.MazeWall3D;
import dev.xkmc.l2library.idea.infmaze.init.CellLoaderChain;
import dev.xkmc.l2library.idea.infmaze.init.GenerationConfig;
import dev.xkmc.l2library.idea.infmaze.pos.BasePos;
import dev.xkmc.l2library.idea.infmaze.pos.CellPos;
import dev.xkmc.l2library.idea.infmaze.pos.MazeAxis;
import dev.xkmc.l2library.idea.infmaze.pos.MazeDirection;
import dev.xkmc.l2library.idea.infmaze.pos.WallPos;
import java.util.TreeMap;

public class InfiniMaze {
    public final GenerationConfig config;
    public GenerationHelper helper;
    private final TreeMap<BasePos, MazeCell3D> cellMap = new TreeMap();
    private final TreeMap<WallPos, MazeWall3D> wallMap = new TreeMap();

    public InfiniMaze(GenerationConfig config) {
        this.config = config;
        this.helper = new GenerationHelper(config);
    }

    public int getMaxScale() {
        return this.config.maxScale();
    }

    public void clearCache() {
        this.helper = new GenerationHelper(this.config);
        this.cellMap.clear();
        this.wallMap.clear();
    }

    public CellLoaderChain getCell(BasePos pos) {
        if (this.helper.cellCount > this.config.cacheSize()) {
            this.clearCache();
        }
        return new CellLoaderChain(this.getOrGenerateRootCell(pos), pos);
    }

    private MazeCell3D getOrGenerateRootCell(BasePos pos) {
        int scale = this.getMaxScale();
        BasePos raw = new BasePos(pos.x() >> scale, pos.y() >> scale, pos.z() >> scale);
        long seed = this.helper.getRootCellSeed(this.config.seed(), raw);
        return this.cellMap.computeIfAbsent(raw, k -> this.generateCell(raw, seed));
    }

    private MazeCell3D generateCell(BasePos raw, long seed) {
        int scale = this.getMaxScale();
        MazeWall3D[] ans = new MazeWall3D[6];
        BasePos cell = new BasePos(raw.x() << scale, raw.y() << scale, raw.z() << scale);
        CellPos pos = new CellPos(cell, scale);
        for (MazeDirection dire : MazeDirection.values()) {
            WallPos wallPos = pos.getWallPos(dire);
            ans[dire.ordinal()] = this.getOrGenerateRootWall(wallPos.pos(), wallPos.normal());
        }
        return new MazeCell3D(this.helper, pos, seed, ans);
    }

    private MazeWall3D getOrGenerateRootWall(BasePos pos, MazeAxis axis) {
        int scale = this.getMaxScale();
        BasePos raw = new BasePos(pos.x() >> scale, pos.y() >> scale, pos.z() >> scale);
        WallPos key = new WallPos(raw, 0, axis);
        return this.wallMap.computeIfAbsent(key, k -> this.generateWall(raw, axis));
    }

    private MazeWall3D generateWall(BasePos raw, MazeAxis axis) {
        int scale = this.getMaxScale();
        BasePos cell = new BasePos(raw.x() << scale, raw.y() << scale, raw.z() << scale);
        long seed = this.helper.getRootWallSeed(this.config.seed(), raw, axis);
        return new MazeWall3D(this.helper, new WallPos(cell, scale, axis), axis != MazeAxis.Y, seed);
    }
}

